/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot;

import com.cartoplot.CartoPlotListener;
import com.cartoplot.CartoPlotModel;
import com.cartoplot.CartoPlotView;
import com.cartoplot.Geometry2Shape;
import com.cartoplot.axis.AxisModel;
import com.macrofocus.common.concurrent.ExecutorService;
import com.macrofocus.common.concurrent.Runtime;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.transform.RangesScreenTransformCoordinator;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.graphics.colortheme.LightColorTheme;
import org.mkui.graphics.pressure.LinearPressure;
import org.mkui.graphics.pressure.Pressure;
import org.mkui.palette.FixedPalette;
import org.mkui.tooltip.Tooltip;
import org.mkui.transform.MutableTwoDScreenTransform;
import org.mkui.transform.SimpleTwoDScreenTransform;
import org.mkui.visual.VisualLayer;
import org.mkui.visual.VisualListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 \u00a8\u0001*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0006\u00a7\u0001\u00a8\u0001\u00a9\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010p\u001a\u00020q2\u0006\u0010+\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020q2\u0006\u0010t\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020q2\u0006\u0010t\u001a\u00020wH\u0016J\u0010\u0010x\u001a\u00020q2\u0006\u0010t\u001a\u00020yH\u0016J\u0017\u0010z\u001a\u0004\u0018\u00010\u000f2\u0006\u0010{\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010|J\b\u0010}\u001a\u00020qH\u0004J#\u0010~\u001a\u0004\u0018\u00018\u00002\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u0001H\u0016\u00a2\u0006\u0003\u0010\u0082\u0001J\u001a\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u0006\u0010{\u001a\u00028\u0000H\u0004\u00a2\u0006\u0003\u0010\u0085\u0001J\u001a\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u0006\u0010{\u001a\u00028\u0000H\u0004\u00a2\u0006\u0003\u0010\u0085\u0001J\u0016\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0084\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001J\u001b\u0010\u0089\u0001\u001a\t\u0012\u0004\u0012\u00028\u00000\u008a\u00012\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010CH\u0016J\u0018\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u000f2\u0006\u0010{\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010|J\u0015\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001J\t\u0010\u008d\u0001\u001a\u00020qH\u0016J5\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008f\u0001\u001a\u00020C2\u0006\u0010\u007f\u001a\u00020@2\u0007\u0010\u0081\u0001\u001a\u00020@2\u0007\u0010\u0090\u0001\u001a\u00020@2\u0007\u0010\u0091\u0001\u001a\u00020@H\u0002J\t\u0010\u0092\u0001\u001a\u00020qH\u0014J\t\u0010\u0093\u0001\u001a\u00020qH$J\u0007\u0010\u0094\u0001\u001a\u00020qJ\u0007\u0010\u0095\u0001\u001a\u00020qJ\t\u0010\u0096\u0001\u001a\u00020qH$J$\u0010\u0097\u0001\u001a\u00020q2\b\u0010{\u001a\u0004\u0018\u00018\u00002\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010aH\u0016\u00a2\u0006\u0003\u0010\u0099\u0001J\u001c\u0010\u009a\u0001\u001a\u00020q2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u0001H\u0016J\t\u0010\u009b\u0001\u001a\u00020qH\u0016J\u001c\u0010\u009c\u0001\u001a\u00020q2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u0001H\u0016J&\u0010\u009d\u0001\u001a\u00020C2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\b\u0010\u009e\u0001\u001a\u00030\u0080\u0001H\u0004J\u0011\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\u0007\u0010\u00a1\u0001\u001a\u00020CJ6\u0010\u009e\u0001\u001a\u00020q2\u0007\u0010\u00a2\u0001\u001a\u00020\u00072\u0007\u0010\u00a3\u0001\u001a\u00020@2\u0007\u0010\u00a4\u0001\u001a\u00020@2\u0007\u0010\u00a5\u0001\u001a\u00020@2\u0007\u0010\u00a6\u0001\u001a\u00020@H\u0016R0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00160\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\fR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\nR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\nR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010&\"\u0004\b*\u0010(R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010.\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010-2\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010-@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010<\u001a\b\u0012\u0004\u0012\u00020;0\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020;0\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\n\"\u0004\b>\u0010\fR\u000e\u0010?\u001a\u00020@X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0016\u0010F\u001a\u0004\u0018\u00010C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR0\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\n\"\u0004\bO\u0010\fR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\nR\u0014\u0010S\u001a\u00020TX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR;\u0010Y\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010X2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010X8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b^\u0010_\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u0083\u0001\u0010b\u001a.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010-\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000X\u0018\u00010`22\u0010W\u001a.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010-\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000X\u0018\u00010`8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bg\u0010_\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\u0017\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\nR\u0011\u0010j\u001a\u00020k\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010mR\u0011\u0010n\u001a\u00020k\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010m\u00a8\u0006\u00aa\u0001"}, d2={"Lcom/cartoplot/AbstractCartoPlotView;", "Row", "Column", "Lcom/cartoplot/CartoPlotView;", "()V", "value", "Lcom/macrofocus/common/properties/MutableProperty;", "", "antialiasing", "getAntialiasing", "()Lcom/macrofocus/common/properties/MutableProperty;", "setAntialiasing", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "cache", "", "Lorg/mkui/geom/Shape;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas;", "setCanvas", "(Lorg/mkui/canvas/CPCanvas;)V", "Lorg/mkui/graphics/colortheme/ColorTheme;", "colorTheme", "getColorTheme", "setColorTheme", "converter", "Lcom/cartoplot/Geometry2Shape;", "doubleBuffered", "getDoubleBuffered", "drawTileGrid", "getDrawTileGrid", "drawTiles", "getDrawTiles", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "maintainAspectRatio", "isMaintainAspectRatio", "()Z", "setMaintainAspectRatio", "(Z)V", "isSelectionMode", "setSelectionMode", "listener", "Lcom/cartoplot/CartoPlotListener;", "Lcom/cartoplot/CartoPlotModel;", "model", "getModel", "()Lcom/cartoplot/CartoPlotModel;", "setModel", "(Lcom/cartoplot/CartoPlotModel;)V", "optimizeAffine", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "Lcom/cartoplot/CartoPlotView$PropertyType;", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "rangesScreenTransformCoordinator", "Lcom/macrofocus/common/transform/RangesScreenTransformCoordinator;", "Lorg/mkui/canvas/Rendering;", "rendering", "getRendering", "setRendering", "resolution", "", "rubberBand", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "Lorg/mkui/geom/Rectangle2D;", "getRubberBand", "()Lcom/macrofocus/common/selection/MutableSingleSelection;", "rubberBandScreen", "getRubberBandScreen", "()Lorg/mkui/geom/Rectangle2D;", "screenTransform", "Lorg/mkui/transform/MutableTwoDScreenTransform;", "getScreenTransform", "()Lorg/mkui/transform/MutableTwoDScreenTransform;", "showFiltered", "getShowFiltered", "setShowFiltered", "tileEffect", "Lcom/cartoplot/CartoPlotView$TileEffect;", "getTileEffect", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "<set-?>", "Lorg/mkui/tooltip/Tooltip;", "tooltip", "getTooltip", "()Lorg/mkui/tooltip/Tooltip;", "setTooltip", "(Lorg/mkui/tooltip/Tooltip;)V", "tooltip$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lkotlin/Function3;", "Lorg/mkui/geom/Point;", "tooltipFactory", "getTooltipFactory", "()Lkotlin/jvm/functions/Function3;", "setTooltipFactory", "(Lkotlin/jvm/functions/Function3;)V", "tooltipFactory$delegate", "wrap", "getWrap", "xRangeModel", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "getXRangeModel", "()Lcom/macrofocus/common/interval/MutableBoundedInterval;", "yRangeModel", "getYRangeModel", "addKeyListener", "", "Lorg/mkui/canvas/KeyListener;", "addMouseListener", "l", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "computeShape", "row", "(Ljava/lang/Object;)Lorg/mkui/geom/Shape;", "createOverplots", "getClosestRow", "x", "", "y", "(II)Ljava/lang/Object;", "getForegroundPoint", "Lorg/mkui/geom/Point2D;", "(Ljava/lang/Object;)Lorg/mkui/geom/Point2D;", "getPoint", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "getRows", "", "rect", "getShape", "hideTooltip", "intersects", "s", "w", "h", "populateOverplots", "repaint", "resetXAxis", "resetYAxis", "scheduleUpdate", "showTooltip", "location", "(Ljava/lang/Object;Lorg/mkui/geom/Point;)V", "startRubberBand", "stopRubberBand", "stretchRubberBand", "tile2boundingBox", "zoom", "worldToScreen", "Lorg/mkui/geom/Rectangle;", "r", "animate", "x1", "x2", "y1", "y2", "AbstractVisualLayerIDrawing", "Companion", "RubberbandDrawing", "cartoplot"})
@SourceDebugExtension(value={"SMAP\nAbstractCartoPlotView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCartoPlotView.kt\ncom/cartoplot/AbstractCartoPlotView\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,813:1\n33#2,3:814\n33#2,3:817\n1#3:820\n*S KotlinDebug\n*F\n+ 1 AbstractCartoPlotView.kt\ncom/cartoplot/AbstractCartoPlotView\n*L\n95#1:814,3\n125#1:817,3\n*E\n"})
public abstract class AbstractCartoPlotView<Row, Column>
implements CartoPlotView<Row, Column> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private CartoPlotModel<Row, Column> model;
    @NotNull
    private CPCanvas canvas = new CPCanvas();
    @NotNull
    private final CPTimer timer;
    private final boolean optimizeAffine;
    private final double resolution;
    @NotNull
    private final Map<Row, Shape> cache = new LinkedHashMap();
    @NotNull
    private final MutableSingleSelection<Rectangle2D> rubberBand = (MutableSingleSelection)new SimpleSingleSelection();
    private boolean isSelectionMode = true;
    @Nullable
    private RangesScreenTransformCoordinator rangesScreenTransformCoordinator;
    @NotNull
    private final MutableProperties<CartoPlotView.PropertyType> properties = (MutableProperties)new EnumProperties((Enum[])CartoPlotView.PropertyType.values());
    @NotNull
    private final MutableBoundedInterval xRangeModel;
    @NotNull
    private final MutableBoundedInterval yRangeModel;
    @NotNull
    private final MutableTwoDScreenTransform screenTransform;
    @NotNull
    private final ReadWriteProperty tooltipFactory$delegate;
    @NotNull
    private final ReadWriteProperty tooltip$delegate;
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final CartoPlotListener listener;
    @NotNull
    private final Geometry2Shape converter;
    @NotNull
    private MutableProperty<Boolean> showFiltered;
    @NotNull
    private MutableProperty<Boolean> antialiasing;
    @NotNull
    private MutableProperty<Rendering> rendering;
    @NotNull
    private final MutableProperty<Boolean> doubleBuffered;
    @NotNull
    private final MutableProperty<Boolean> drawTileGrid;
    @NotNull
    private final MutableProperty<Boolean> drawTiles;
    @NotNull
    private final MutableProperty<CartoPlotView.TileEffect> tileEffect;
    @NotNull
    private final MutableProperty<Boolean> wrap;
    @NotNull
    private MutableProperty<ColorTheme> colorTheme;
    private static final float rubberbandStroke = 1.0f;
    private static final boolean MULTITHREADED = false;
    private static final int nAvailableProcessors;
    @Nullable
    private static ExecutorService executor;

    public AbstractCartoPlotView() {
        this.resolution = 0.1;
        Delegates delegates = Delegates.INSTANCE;
        Object initialValue$iv = null;
        boolean $i$f$observable = false;
        this.tooltipFactory$delegate = (ReadWriteProperty)new ObservableProperty<Function3<? super CartoPlotModel<Row, Column>, ? super Row, ? super org.mkui.geom.Point, ? extends Tooltip<Row>>>(initialValue$iv, this){
            final /* synthetic */ AbstractCartoPlotView this$0;
            {
                this.this$0 = abstractCartoPlotView;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Function3 cfr_ignored_0 = (Function3)newValue;
                Function3 cfr_ignored_1 = (Function3)oldValue;
                boolean bl = false;
                this.this$0.repaint();
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = null;
        $i$f$observable = false;
        this.tooltip$delegate = (ReadWriteProperty)new ObservableProperty<Tooltip<Row>>(initialValue$iv, this){
            final /* synthetic */ AbstractCartoPlotView this$0;
            {
                this.this$0 = abstractCartoPlotView;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Tooltip cfr_ignored_0 = (Tooltip)newValue;
                Tooltip cfr_ignored_1 = (Tooltip)oldValue;
                boolean bl = false;
                this.this$0.repaint();
            }
        };
        this.geometryFactory = new GeometryFactory(new PrecisionModel(1.0), 0, null, 6, null);
        this.xRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(-180.0, 360.0, -180.0, 180.0);
        double start = Companion.lat2y(-85.0511);
        double end = Companion.lat2y(85.0511);
        this.yRangeModel = (MutableBoundedInterval)new SimpleBoundedInterval(start, end - start, start, end);
        this.screenTransform = (MutableTwoDScreenTransform)new SimpleTwoDScreenTransform((BoundedInterval)this.xRangeModel, (BoundedInterval)this.yRangeModel, 0, 0, this.xRangeModel.getExtent() / this.yRangeModel.getExtent());
        this.timer = CPHelper.Companion.getInstance().createTimer("CartoPlotResizer", 40, true, new CPTimerListener(){

            public void timerTriggered() {
                if (this.getCanvas().getWidth() > 0.0 && this.getCanvas().getHeight() > 0.0) {
                    this.getCanvas().refresh();
                }
            }
        });
        this.canvas.addCanvasListener(new CanvasListener(){

            public void sizeChange(int width, int height) {
                this.getScreenTransform().setScreenSize(width, height);
            }
        });
        this.screenTransform.addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(@NotNull ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                cache.clear();
                this.getTimer().restart();
            }
        });
        this.setMaintainAspectRatio(true);
        this.listener = new CartoPlotListener(this){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void cartoPlotChanged() {
                this.this$0.resetXAxis();
                this.this$0.resetYAxis();
                this.this$0.scheduleUpdate();
            }
        };
        this.converter = new Geometry2Shape(new Geometry2Shape.PointConverter(this){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Point2D toViewPoint(@Nullable Coordinate modelCoordinate) {
                Coordinate coordinate = modelCoordinate;
                Intrinsics.checkNotNull((Object)coordinate);
                double x = coordinate.x;
                double y = modelCoordinate.y;
                y = AbstractCartoPlotView.Companion.lat2y(y);
                return (Point2D)new Point2D.Double(this.this$0.getScreenTransform().getX().worldToScreenPrecise(x), this.this$0.getScreenTransform().getY().worldToScreenPrecise(y));
            }

            public double getScale() {
                return (this.this$0.getXRangeModel().getMaximum() - this.this$0.getXRangeModel().getMinimum()) / this.this$0.getXRangeModel().getExtent();
            }
        }, this.resolution);
        this.showFiltered = this.properties.createProperty((Object)CartoPlotView.PropertyType.ShowFiltered, (Object)true);
        this.antialiasing = this.properties.createProperty((Object)CartoPlotView.PropertyType.Antialiasing, (Object)true);
        this.rendering = this.properties.createProperty((Object)CartoPlotView.PropertyType.Rendering, (Object)Rendering.AlphaBlended);
        this.doubleBuffered = this.properties.createProperty((Object)CartoPlotView.PropertyType.DoubleBuffered, (Object)true);
        this.drawTileGrid = this.properties.createProperty((Object)CartoPlotView.PropertyType.DrawTileGrid, (Object)false);
        this.drawTiles = this.properties.createProperty((Object)CartoPlotView.PropertyType.DrawTiles, (Object)true);
        this.tileEffect = this.properties.createProperty((Object)CartoPlotView.PropertyType.TileEffect, (Object)CartoPlotView.TileEffect.None);
        this.wrap = this.properties.createProperty((Object)CartoPlotView.PropertyType.Wrap, (Object)false);
        this.colorTheme = this.properties.createProperty((Object)CartoPlotView.PropertyType.ColorTheme, (Object)new LightColorTheme());
    }

    @Override
    @Nullable
    public CartoPlotModel<Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(@Nullable CartoPlotModel<Row, Column> value) {
        CartoPlotModel<Row, Column> cartoPlotModel = this.model;
        if (cartoPlotModel != null) {
            cartoPlotModel.removeCartoPlotListener(this.listener);
        }
        this.model = value;
        this.createOverplots();
        CartoPlotModel<Row, Column> cartoPlotModel2 = this.model;
        if (cartoPlotModel2 != null) {
            cartoPlotModel2.addCartoPlotListener(this.listener);
        }
        this.resetXAxis();
        this.resetYAxis();
        this.timer.restart();
    }

    @NotNull
    protected final CPCanvas getCanvas() {
        return this.canvas;
    }

    protected final void setCanvas(@NotNull CPCanvas cPCanvas) {
        Intrinsics.checkNotNullParameter((Object)cPCanvas, (String)"<set-?>");
        this.canvas = cPCanvas;
    }

    @NotNull
    protected final CPTimer getTimer() {
        return this.timer;
    }

    @NotNull
    public MutableSingleSelection<Rectangle2D> getRubberBand() {
        return this.rubberBand;
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean bl) {
        this.isSelectionMode = bl;
    }

    @NotNull
    protected final MutableProperties<CartoPlotView.PropertyType> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public final MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    @NotNull
    public final MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @NotNull
    public final MutableTwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Override
    public boolean isMaintainAspectRatio() {
        return this.rangesScreenTransformCoordinator != null;
    }

    @Override
    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        if (maintainAspectRatio && this.rangesScreenTransformCoordinator == null) {
            this.rangesScreenTransformCoordinator = new RangesScreenTransformCoordinator(this.xRangeModel, this.yRangeModel);
        } else if (!maintainAspectRatio && this.rangesScreenTransformCoordinator != null) {
            RangesScreenTransformCoordinator rangesScreenTransformCoordinator = this.rangesScreenTransformCoordinator;
            Intrinsics.checkNotNull((Object)rangesScreenTransformCoordinator);
            rangesScreenTransformCoordinator.setRanges(null, null);
            this.rangesScreenTransformCoordinator = null;
        }
        this.screenTransform.setMaintainAspectRatio(maintainAspectRatio);
    }

    @Override
    @Nullable
    public Function3<CartoPlotModel<Row, Column>, Row, org.mkui.geom.Point, Tooltip<Row>> getTooltipFactory() {
        return (Function3)this.tooltipFactory$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setTooltipFactory(@Nullable Function3<? super CartoPlotModel<Row, Column>, ? super Row, ? super org.mkui.geom.Point, ? extends Tooltip<Row>> function3) {
        this.tooltipFactory$delegate.setValue((Object)this, $$delegatedProperties[0], function3);
    }

    @Override
    public void showTooltip(@Nullable Row row, @Nullable org.mkui.geom.Point location) {
        if (row != null) {
            org.mkui.geom.Point location2;
            org.mkui.geom.Point point = location;
            if (point == null) {
                Shape shape = this.getShape(row);
                if (shape != null) {
                    Rectangle rectangle = shape.getBounds();
                    Intrinsics.checkNotNull((Object)rectangle);
                    Rectangle bounds = rectangle;
                    point = new org.mkui.geom.Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
                } else {
                    point = null;
                }
            }
            if ((location2 = point) != null) {
                Tooltip tooltip;
                Function3<CartoPlotModel<Row, Column>, Row, org.mkui.geom.Point, Tooltip<Row>> function3 = this.getTooltipFactory();
                if (function3 != null) {
                    CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
                    Intrinsics.checkNotNull(cartoPlotModel);
                    tooltip = (Tooltip)function3.invoke(cartoPlotModel, row, (Object)location2);
                } else {
                    tooltip = null;
                }
                this.setTooltip(tooltip);
            } else {
                this.hideTooltip();
            }
        } else {
            this.hideTooltip();
        }
    }

    @Override
    public void hideTooltip() {
        this.setTooltip(null);
    }

    @Override
    @Nullable
    public Tooltip<Row> getTooltip() {
        return (Tooltip)this.tooltip$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    public void setTooltip(@Nullable Tooltip<Row> tooltip) {
        this.tooltip$delegate.setValue((Object)this, $$delegatedProperties[1], tooltip);
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.xRangeModel.setValue(x1, x2 - x1);
        this.yRangeModel.setValue(y1, y2 - y1);
    }

    public final void resetXAxis() {
        AxisModel<Row> xAxisModel;
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        AxisModel<Row> axisModel = xAxisModel = cartoPlotModel != null ? cartoPlotModel.getXAxisModel() : null;
        if (xAxisModel != null) {
            double min = xAxisModel.getMinimum();
            double max = xAxisModel.getMaximum();
            this.xRangeModel.setMinMax(min, max);
            this.xRangeModel.setValue(min, max - min);
        }
    }

    public final void resetYAxis() {
        AxisModel<Row> yAxisModel;
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        AxisModel<Row> axisModel = yAxisModel = cartoPlotModel != null ? cartoPlotModel.getYAxisModel() : null;
        if (yAxisModel != null) {
            double min = Companion.lat2y(yAxisModel.getMinimum());
            double max = Companion.lat2y(yAxisModel.getMaximum());
            this.yRangeModel.setMinMax(min, max);
            this.yRangeModel.setValue(min, max - min);
            this.screenTransform.setWorldAspectRatio(this.xRangeModel.getExtent() / this.yRangeModel.getExtent());
        }
    }

    protected abstract void scheduleUpdate();

    protected abstract void repaint();

    @Override
    @Nullable
    public Row getClosestRow(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel);
        VisualLayer visible = cartoPlotModel.getVisual().getActive();
        if (this.optimizeAffine && this.screenTransform.isAffine()) {
            double modelX = this.screenTransform.xScreenToWorld(x);
            double modelY = Companion.y2lat(this.screenTransform.yScreenToWorld(y));
            for (Object row : visible) {
                Point g;
                CartoPlotModel cartoPlotModel2 = this.getModel();
                Intrinsics.checkNotNull(cartoPlotModel2);
                Geometry p = cartoPlotModel2.getGeometry(row);
                if (p == null || !p.contains((Geometry)(g = this.geometryFactory.createPoint((Coordinate)new CoordinateXY(modelX, modelY))))) continue;
                bestdistance = 0.0;
                bestrow = (Row)row;
                break;
            }
        } else {
            for (Object row : visible) {
                Shape p = this.getShape(row);
                if (p == null || !p.contains((Point2D)new Point2D.Double((double)x, (double)y))) continue;
                bestdistance = 0.0;
                bestrow = (Row)row;
                break;
            }
        }
        if (bestdistance > 0.0) {
            for (Object row : visible) {
                double distance;
                Point2D p = this.getPoint(row);
                if (p == null || !((distance = Point2D.Companion.distance(p.getX(), p.getY(), (double)x, (double)y)) < bestdistance)) continue;
                bestdistance = distance;
                bestrow = (Row)row;
            }
        }
        return bestrow;
    }

    @Override
    @NotNull
    public List<Row> getRows(@Nullable Rectangle2D rect) {
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel);
        VisualLayer visible = cartoPlotModel.getVisual().getActive();
        List list = new ArrayList();
        for (Object row : visible) {
            Shape p = this.getShape(row);
            if (p == null) continue;
            if (p instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)p;
                Rectangle2D rectangle2D2 = rect;
                Intrinsics.checkNotNull((Object)rectangle2D2);
                if (!this.intersects(rectangle2D, rectangle2D2.getX(), rect.getY(), rect.getWidth(), rect.getHeight())) continue;
                list.add(row);
                continue;
            }
            Rectangle2D rectangle2D = rect;
            Intrinsics.checkNotNull((Object)rectangle2D);
            if (!p.intersects(rectangle2D)) continue;
            list.add(row);
        }
        return list;
    }

    private final boolean intersects(Rectangle2D s, double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = s.getX();
        double y0 = s.getY();
        return x + w > x0 && y + h > y0 && x < x0 + s.getWidth() && y < y0 + s.getHeight();
    }

    @Override
    public void startRubberBand(int x, int y) {
        double xWorld = this.screenTransform.getX().screenToWorld(x);
        double yWorld = this.screenTransform.getY().screenToWorld(y);
        this.getRubberBand().setSelected((Object)new Rectangle2D.Double(xWorld, yWorld, 0.0, 0.0));
    }

    @Override
    public void stretchRubberBand(int x, int y) {
        if (this.getRubberBand().isActive()) {
            double xWorld = this.screenTransform.getX().screenToWorld(x);
            double yWorld = this.screenTransform.getY().screenToWorld(y);
            Rectangle2D r = (Rectangle2D)this.getRubberBand().getSelected();
            MutableSingleSelection<Rectangle2D> mutableSingleSelection = this.getRubberBand();
            Rectangle2D rectangle2D = r;
            Intrinsics.checkNotNull((Object)rectangle2D);
            mutableSingleSelection.setSelected((Object)new Rectangle2D.Double(rectangle2D.getX(), r.getY(), xWorld - r.getX(), yWorld - r.getY()));
        }
    }

    @Override
    public void stopRubberBand() {
        this.getRubberBand().clearSelection();
    }

    @Override
    @Nullable
    public Rectangle2D getRubberBandScreen() {
        Rectangle2D rectangle2D;
        if (this.getRubberBand().isActive()) {
            Rectangle2D rectangle2D2 = (Rectangle2D)this.getRubberBand().getSelected();
            if (rectangle2D2 != null) {
                Rectangle2D it = rectangle2D2;
                boolean bl = false;
                rectangle2D = this.worldToScreen(it).normalize();
            } else {
                rectangle2D = null;
            }
        } else {
            rectangle2D = null;
        }
        return rectangle2D;
    }

    @NotNull
    public final Rectangle worldToScreen(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        int x1 = (int)Math.INSTANCE.round(this.screenTransform.getX().worldToScreenPrecise(r.getMinX()));
        int x2 = (int)Math.INSTANCE.round(this.screenTransform.getX().worldToScreenPrecise(r.getMaxX()));
        int y1 = (int)Math.INSTANCE.round(this.screenTransform.getY().worldToScreenPrecise(r.getMinY()));
        int y2 = (int)Math.INSTANCE.round(this.screenTransform.getY().worldToScreenPrecise(r.getMaxY()));
        int minX = Math.INSTANCE.min(x1, x2);
        int maxX = Math.INSTANCE.max(x1, x2);
        int minY = Math.INSTANCE.min(y1, y2);
        int maxY = Math.INSTANCE.max(y1, y2);
        int width = maxX - minX;
        int height = maxY - minY;
        return new Rectangle(minX, minY, width, height);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getShowFiltered() {
        return this.showFiltered;
    }

    @Override
    public void setShowFiltered(@NotNull MutableProperty<Boolean> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.showFiltered = value;
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.ShowFiltered, value);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getAntialiasing() {
        return this.antialiasing;
    }

    @Override
    public void setAntialiasing(@NotNull MutableProperty<Boolean> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.antialiasing = value;
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.Antialiasing, value);
    }

    @Override
    @NotNull
    public MutableProperty<Rendering> getRendering() {
        return this.rendering;
    }

    @Override
    public void setRendering(@NotNull MutableProperty<Rendering> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.rendering = value;
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.Rendering, value);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getDoubleBuffered() {
        return this.doubleBuffered;
    }

    @NotNull
    public final MutableProperty<Boolean> getDrawTileGrid() {
        return this.drawTileGrid;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getDrawTiles() {
        return this.drawTiles;
    }

    @NotNull
    public final MutableProperty<CartoPlotView.TileEffect> getTileEffect() {
        return this.tileEffect;
    }

    @NotNull
    public final MutableProperty<Boolean> getWrap() {
        return this.wrap;
    }

    @Override
    @NotNull
    public MutableProperty<ColorTheme> getColorTheme() {
        return this.colorTheme;
    }

    @Override
    public void setColorTheme(@NotNull MutableProperty<ColorTheme> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.colorTheme = value;
        this.properties.replaceProperty((Object)CartoPlotView.PropertyType.ColorTheme, this.getColorTheme());
    }

    @NotNull
    protected final Rectangle2D tile2boundingBox(int x, int y, int zoom) {
        double north = Companion.tile2lat(y, zoom);
        double south = Companion.tile2lat(y + 1, zoom);
        double west = Companion.tile2lon(x, zoom);
        double east = Companion.tile2lon(x + 1, zoom);
        north = Companion.lat2y(north);
        south = Companion.lat2y(south);
        return (Rectangle2D)new Rectangle2D.Double(west, south, east - west, north - south);
    }

    protected final void createOverplots() {
        if (this.getModel() != null) {
            this.canvas.removeAllLayers();
            this.populateOverplots();
        }
    }

    protected void populateOverplots() {
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel);
        VisualLayer visualLayer = cartoPlotModel.getVisual().getFiltered();
        IDrawing filteredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isActive() {
                return (Boolean)this.this$0.getShowFiltered().getValue() != false && super.isActive();
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        double radius = 2.0;
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * 2.0, radius * 2.0));
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.fillShape(mp);
                    }
                }
            }
        };
        CartoPlotModel<Row, Column> cartoPlotModel2 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel2);
        VisualLayer visualLayer2 = cartoPlotModel2.getVisual().getVisible();
        IDrawing visibleDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer2){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        double radius = 4.0;
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.fillShape(mp);
                    }
                }
            }
        };
        CartoPlotModel<Row, Column> cartoPlotModel3 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel3);
        VisualLayer visualLayer3 = cartoPlotModel3.getVisual().getColorMapped();
        IDrawing colorMappedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer3){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        CartoPlotModel<Row, Column> cartoPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel2);
                        Color color = cartoPlotModel2.getColorMapping().getColor(row);
                        Intrinsics.checkNotNull((Object)color);
                        iGraphics.setColor(color);
                        double radius = 4.0;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        CartoPlotModel<Row, Column> cartoPlotModel3 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel3);
                        Color color = cartoPlotModel3.getColorMapping().getColor(row);
                        if (color != null) {
                            Color it = color;
                            boolean bl = false;
                            IGraphics iGraphics = g;
                            Intrinsics.checkNotNull((Object)iGraphics);
                            iGraphics.setColor(it);
                        }
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.fillShape(mp);
                    }
                }
            }
        };
        CartoPlotModel<Row, Column> cartoPlotModel4 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel4);
        VisualLayer visualLayer4 = cartoPlotModel4.getVisual().getColored();
        IDrawing coloredDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer4){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        CartoPlotModel<Row, Column> cartoPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel2);
                        Color color = cartoPlotModel2.getColoring().getColor(row);
                        Intrinsics.checkNotNull((Object)color);
                        iGraphics.setColor(color);
                        double radius = 4.0;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        CartoPlotModel<Row, Column> cartoPlotModel3 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel3);
                        Color color = cartoPlotModel3.getColoring().getColor(row);
                        if (color != null) {
                            Color it = color;
                            boolean bl = false;
                            IGraphics iGraphics = g;
                            Intrinsics.checkNotNull((Object)iGraphics);
                            iGraphics.setColor(it);
                        }
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.fillShape(mp);
                    }
                }
            }
        };
        CartoPlotModel<Row, Column> cartoPlotModel5 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel5);
        VisualLayer visualLayer5 = cartoPlotModel5.getVisual().getSingleSelected();
        IDrawing singleSelectedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer5){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                        double radius = 6.0;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                        CartoPlotModel<Row, Column> cartoPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel2);
                        MutableProperty<Boolean> fillSelected = cartoPlotModel2.getFillSelected();
                        if (((Boolean)fillSelected.getValue()).booleanValue()) {
                            g.fillShape(mp);
                        } else {
                            g.drawShape(mp);
                        }
                    }
                }
            }
        };
        CartoPlotModel<Row, Column> cartoPlotModel6 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel6);
        VisualLayer visualLayer6 = cartoPlotModel6.getVisual().getMultipleSelected();
        IDrawing multiSelectedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer6){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                        double radius = 6.0;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                        CartoPlotModel<Row, Column> cartoPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel2);
                        MutableProperty<Boolean> fillSelected = cartoPlotModel2.getFillSelected();
                        if (((Boolean)fillSelected.getValue()).booleanValue()) {
                            g.fillShape(mp);
                        } else {
                            g.drawShape(mp);
                        }
                    }
                }
            }
        };
        CartoPlotModel<Row, Column> cartoPlotModel7 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel7);
        VisualLayer visualLayer7 = cartoPlotModel7.getVisual().getProbed();
        IDrawing probedDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer7){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                if (cartoPlotModel.isPointGeometry()) {
                    Point2D mp = this.this$0.getPoint(row);
                    if (mp != null) {
                        IGraphics iGraphics = g;
                        Intrinsics.checkNotNull((Object)iGraphics);
                        iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing());
                        double radius = 6.0;
                        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                        CartoPlotModel<Row, Column> cartoPlotModel2 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel2);
                        if (cartoPlotModel2.getSelection().isSelected(row)) {
                            g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                            radius = 4.0;
                            g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                        }
                    }
                } else {
                    Shape mp = this.this$0.getShape(row);
                    if (mp != null) {
                        CartoPlotModel<Row, Column> cartoPlotModel3 = this.this$0.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel3);
                        MutableProperty<Boolean> fillSelected = cartoPlotModel3.getFillSelected();
                        if (((Boolean)fillSelected.getValue()).booleanValue()) {
                            CartoPlotModel<Row, Column> cartoPlotModel4 = this.this$0.getModel();
                            Intrinsics.checkNotNull(cartoPlotModel4);
                            if (cartoPlotModel4.getSelection().isSelected(row)) {
                                IGraphics iGraphics = g;
                                Intrinsics.checkNotNull((Object)iGraphics);
                                iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                                g.fillShape(mp);
                            }
                            IGraphics iGraphics = g;
                            Intrinsics.checkNotNull((Object)iGraphics);
                            iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing());
                            g.drawShape(mp);
                        } else {
                            CartoPlotModel<Row, Column> cartoPlotModel5 = this.this$0.getModel();
                            Intrinsics.checkNotNull(cartoPlotModel5);
                            if (cartoPlotModel5.getSelection().isSelected(row)) {
                                IGraphics iGraphics = g;
                                Intrinsics.checkNotNull((Object)iGraphics);
                                iGraphics.setLineWidth(3.0);
                                g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing());
                                g.drawShape(mp);
                                g.setLineWidth(1.0);
                                g.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                                g.drawShape(mp);
                            } else {
                                IGraphics iGraphics = g;
                                Intrinsics.checkNotNull((Object)iGraphics);
                                iGraphics.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing());
                                g.drawShape(mp);
                            }
                        }
                    }
                }
            }
        };
        this.canvas.addDensityLayer((Rendering)this.getRendering().getValue(), filteredDrawing2, (Pressure)new LinearPressure(), new PaletteProvider(this){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public FixedPalette getPalette() {
                return ((ColorTheme)this.this$0.getColorTheme().getValue()).getGhostedPalette();
            }
        });
        this.canvas.addDensityLayer((Rendering)this.getRendering().getValue(), visibleDrawing2, (Pressure)new LinearPressure(), new PaletteProvider(this){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public FixedPalette getPalette() {
                return ((ColorTheme)this.this$0.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        this.canvas.addAveragingLayer((Rendering)this.getRendering().getValue(), colorMappedDrawing2);
        this.canvas.addBufferedLayer(coloredDrawing2);
        this.canvas.addBufferedLayer(multiSelectedDrawing2);
        this.canvas.addLayer(singleSelectedDrawing2);
        this.canvas.addLayer(probedDrawing2);
        CartoPlotModel<Row, Column> cartoPlotModel8 = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel8);
        VisualLayer visualLayer8 = cartoPlotModel8.getVisual().getColorMapped();
        IDrawing foregroundVisibleDrawing2 = (IDrawing)new AbstractVisualLayerIDrawing(this, visualLayer8){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean isActive() {
                CartoPlotModel<Row, Column> cartoPlotModel = this.this$0.getModel();
                return (cartoPlotModel != null ? cartoPlotModel.getForegroundGeoReferencingService() : null) != null;
            }

            public void draw(@Nullable IGraphics g, Row row, double width, double height) {
                Point2D mp = this.this$0.getForegroundPoint(row);
                System.out.println(mp);
                if (mp != null) {
                    double radius = 2.0;
                    IGraphics iGraphics = g;
                    Intrinsics.checkNotNull((Object)iGraphics);
                    iGraphics.setColor(MkColorFactory.Companion.getInstance().getGray());
                    g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, radius * (double)2, radius * (double)2));
                }
            }
        };
        this.canvas.addLayer(foregroundVisibleDrawing2);
        this.canvas.addLayer((IDrawing)new RubberbandDrawing((SingleSelection<Rectangle2D>)((SingleSelection)this.getRubberBand())));
        this.canvas.addLayer((IDrawing)new AbstractIDrawing(this){
            final /* synthetic */ AbstractCartoPlotView<Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isActive() {
                return this.this$0.getTooltip() != null;
            }

            public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
                block4: {
                    int n;
                    int n2;
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                    Tooltip<Row> tooltip = this.this$0.getTooltip();
                    if (tooltip == null) break block4;
                    Tooltip<Row> tooltip2 = tooltip;
                    AbstractCartoPlotView<Row, Column> abstractCartoPlotView = this.this$0;
                    Tooltip<Row> tooltip3 = tooltip2;
                    boolean bl = false;
                    Dimension size = tooltip3.computePreferredSize(g);
                    int i = 5;
                    org.mkui.geom.Point point2 = tooltip3.getDesiredLocation();
                    Intrinsics.checkNotNull((Object)point2);
                    if ((double)(point2.getIx() + size.getIwidth() + i) <= abstractCartoPlotView.getCanvas().getWidth()) {
                        org.mkui.geom.Point point3 = tooltip3.getDesiredLocation();
                        Intrinsics.checkNotNull((Object)point3);
                        n2 = point3.getIx() + i;
                    } else {
                        org.mkui.geom.Point point4 = tooltip3.getDesiredLocation();
                        Intrinsics.checkNotNull((Object)point4);
                        n2 = point4.getIx() - size.getIwidth() - i;
                    }
                    int tx = n2;
                    org.mkui.geom.Point point5 = tooltip3.getDesiredLocation();
                    Intrinsics.checkNotNull((Object)point5);
                    if (point5.getIy() - size.getIheight() - i >= 0) {
                        org.mkui.geom.Point point6 = tooltip3.getDesiredLocation();
                        Intrinsics.checkNotNull((Object)point6);
                        n = point6.getIy() - size.getIheight() - i;
                    } else {
                        org.mkui.geom.Point point7 = tooltip3.getDesiredLocation();
                        Intrinsics.checkNotNull((Object)point7);
                        n = point7.getIy() + i;
                    }
                    int ty = n;
                    g.translate(tx, ty);
                    tooltip3.paint(g, size);
                    g.translate(-tx, -ty);
                }
            }
        });
    }

    @Nullable
    protected final Point2D getPoint(Row row) {
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel);
        Geometry geometry = cartoPlotModel.getGeometry(row);
        return this.getPoint(geometry);
    }

    @Nullable
    protected final Point2D getForegroundPoint(Row row) {
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel);
        Geometry geometry = cartoPlotModel.getForegroundGeometry(row);
        return this.getPoint(geometry);
    }

    @Nullable
    public final Point2D getPoint(@Nullable Geometry geometry) {
        Point2D point2D;
        if (geometry != null) {
            double y = geometry.getCentroid().getY();
            y = Companion.lat2y(y);
            point2D = (Point2D)new Point2D.Double((double)this.screenTransform.getX().worldToScreen(geometry.getCentroid().getX()), (double)this.screenTransform.getY().worldToScreen(y));
        } else {
            point2D = null;
        }
        return point2D;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final Shape getShape(Row row) {
        Shape shape;
        if (this.cache.containsKey(row)) {
            shape = this.cache.get(row);
        } else {
            void var2_2;
            Shape shape2 = this.computeShape(row);
            this.cache.put(row, shape2);
            shape = var2_2;
        }
        return shape;
    }

    @Nullable
    protected final Shape computeShape(Row row) {
        CartoPlotModel<Row, Column> cartoPlotModel = this.getModel();
        Intrinsics.checkNotNull(cartoPlotModel);
        Geometry geometry = cartoPlotModel.getGeometry(row);
        return this.getShape(geometry);
    }

    @Nullable
    public final Shape getShape(@Nullable Geometry geometry) {
        return geometry != null ? this.converter.toShape(geometry) : null;
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(@NotNull KeyListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.canvas.addKeyListener(listener2);
    }

    @JvmStatic
    public static final int getTileY(double lat, int zoom) {
        return Companion.getTileY(lat, zoom);
    }

    @JvmStatic
    public static final int getTileX(double lon, int zoom) {
        return Companion.getTileX(lon, zoom);
    }

    public static final /* synthetic */ int access$getNAvailableProcessors$cp() {
        return nAvailableProcessors;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$cp() {
        return executor;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AbstractCartoPlotView.class, "tooltipFactory", "getTooltipFactory()Lkotlin/jvm/functions/Function3;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AbstractCartoPlotView.class, "tooltip", "getTooltip()Lorg/mkui/tooltip/Tooltip;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        nAvailableProcessors = Math.INSTANCE.max(Runtime.Companion.getRuntime().availableProcessors(), 1);
        CPHelper cPHelper = CPHelper.Companion.getInstance();
        String string = Reflection.getOrCreateKotlinClass(AbstractCartoPlotView.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        executor = cPHelper.newFixedThreadPool(string, nAvailableProcessors / 2, nAvailableProcessors);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0015\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J/\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH&\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/cartoplot/AbstractCartoPlotView$AbstractVisualLayerIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "visualLayer", "Lorg/mkui/visual/VisualLayer;", "(Lcom/cartoplot/AbstractCartoPlotView;Lorg/mkui/visual/VisualLayer;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "row", "(Lorg/mkui/graphics/IGraphics;Ljava/lang/Object;DD)V", "cartoplot"})
    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        @NotNull
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            Intrinsics.checkNotNullParameter(visualLayer, (String)"visualLayer");
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            if (this.visualLayer.getObjectCount() > 0) {
                for (Object row : this.visualLayer) {
                    this.draw(g, row, width, height);
                }
            }
        }

        public abstract void draw(@Nullable IGraphics var1, Row var2, double var3, double var5);

        private static final Object draw$lambda$0(AbstractVisualLayerIDrawing this$0, int $fromRow, int $toRow, IGraphics $g, double $width, double $height) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$g, (String)"$g");
            for (Object row : this$0.visualLayer.iterable($fromRow, $toRow - 1)) {
                this$0.draw($g, row, $width, $height);
            }
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/cartoplot/AbstractCartoPlotView$Companion;", "", "()V", "MULTITHREADED", "", "executor", "Lcom/macrofocus/common/concurrent/ExecutorService;", "nAvailableProcessors", "", "rubberbandStroke", "", "getTileX", "lon", "", "zoom", "getTileY", "lat", "lat2y", "aLat", "tile2lat", "y", "z", "tile2lon", "x", "y2lat", "aY", "cartoplot"})
    public static final class Companion {
        private Companion() {
        }

        public final double y2lat(double aY) {
            return Angle.INSTANCE.toDegrees((double)2 * java.lang.Math.atan(java.lang.Math.exp(Angle.INSTANCE.toRadians(aY))) - 1.5707963267948966);
        }

        public final double lat2y(double aLat) {
            return Angle.INSTANCE.toDegrees(Math.INSTANCE.log(java.lang.Math.tan(0.7853981633974483 + Angle.INSTANCE.toRadians(aLat) / (double)2)));
        }

        public final double tile2lon(int x, int z) {
            return (double)x / Math.INSTANCE.pow(2.0, (double)z) * 360.0 - (double)180;
        }

        public final double tile2lat(int y, int z) {
            double n = java.lang.Math.PI - java.lang.Math.PI * 2 * (double)y / Math.INSTANCE.pow(2.0, (double)z);
            return Angle.INSTANCE.toDegrees(java.lang.Math.atan(java.lang.Math.sinh(n)));
        }

        @JvmStatic
        public final int getTileY(double lat, int zoom) {
            return (int)java.lang.Math.floor((1.0 - Math.INSTANCE.log(java.lang.Math.tan(Angle.INSTANCE.toRadians(lat)) + 1.0 / java.lang.Math.cos(Angle.INSTANCE.toRadians(lat))) / java.lang.Math.PI) / (double)2 * (double)(1 << zoom));
        }

        @JvmStatic
        public final int getTileX(double lon, int zoom) {
            return (int)java.lang.Math.floor((lon + (double)180) / (double)360 * (double)(1 << zoom));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/cartoplot/AbstractCartoPlotView$RubberbandDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "rubberband", "Lcom/macrofocus/common/selection/SingleSelection;", "Lorg/mkui/geom/Rectangle2D;", "(Lcom/cartoplot/AbstractCartoPlotView;Lcom/macrofocus/common/selection/SingleSelection;)V", "isActive", "", "()Z", "rubberbandListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "getRubberbandListener", "()Lcom/macrofocus/common/selection/SingleSelectionListener;", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "cartoplot"})
    private final class RubberbandDrawing
    extends AbstractIDrawing {
        @NotNull
        private final SingleSelection<Rectangle2D> rubberband;
        @NotNull
        private final SingleSelectionListener<Rectangle2D> rubberbandListener;

        public RubberbandDrawing(SingleSelection<Rectangle2D> rubberband) {
            Intrinsics.checkNotNullParameter(rubberband, (String)"rubberband");
            this.rubberband = rubberband;
            this.rubberbandListener = (SingleSelectionListener)new SingleSelectionListener<Rectangle2D>(this){
                final /* synthetic */ RubberbandDrawing this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(@NotNull SingleSelectionEvent<Rectangle2D> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    RubberbandDrawing.access$notifyIDrawingChanged(this.this$0);
                }
            };
            rubberband.addSingleSelectionListener(this.rubberbandListener);
        }

        @NotNull
        public final SingleSelectionListener<Rectangle2D> getRubberbandListener() {
            return this.rubberbandListener;
        }

        public boolean isActive() {
            return this.rubberband.isActive();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            float[] fArray = new float[]{10.0f, 2.0f, 2.0f, 2.0f};
            float[] dashPattern = fArray;
            g.setLineWidth(1.0);
            g.setLineDash(dashPattern);
            if (((ColorTheme)AbstractCartoPlotView.this.getColorTheme().getValue()).isDark()) {
                g.setColor(MkColorKt.colorOf((int)255, (int)255, (int)255, (int)220));
            } else {
                g.setColor(MkColorKt.colorOf((int)0, (int)0, (int)0, (int)220));
            }
            Rectangle2D rectangle2D = AbstractCartoPlotView.this.getRubberBandScreen();
            Intrinsics.checkNotNull((Object)rectangle2D);
            g.drawShape((Shape)rectangle2D);
        }

        public static final /* synthetic */ void access$notifyIDrawingChanged(RubberbandDrawing $this) {
            $this.notifyIDrawingChanged();
        }
    }
}

