/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot;

import com.cartoplot.GeometryCollectionIShape;
import com.cartoplot.PolygonIShape;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/cartoplot/Geometry2Shape;", "", "pointConverter", "Lcom/cartoplot/Geometry2Shape$PointConverter;", "(Lcom/cartoplot/Geometry2Shape$PointConverter;)V", "resolution", "", "(Lcom/cartoplot/Geometry2Shape$PointConverter;D)V", "decimatorResolution", "toShape", "Lorg/mkui/geom/Shape;", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "Lorg/mkui/geom/GeneralPath;", "lineString", "Lorg/locationtech/jts/geom/LineString;", "mls", "Lorg/locationtech/jts/geom/MultiLineString;", "point", "Lorg/locationtech/jts/geom/Point;", "p", "Lorg/locationtech/jts/geom/Polygon;", "toViewCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "modelCoordinates", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "toViewPoint", "Lorg/mkui/geom/Point2D;", "modelCoordinate", "Companion", "LineStringPath", "PointConverter", "cartoplot"})
public final class Geometry2Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PointConverter pointConverter;
    private double decimatorResolution;
    private static final double POINT_MARKER_SIZE = 3.0;

    public Geometry2Shape(@NotNull PointConverter pointConverter) {
        Intrinsics.checkNotNullParameter((Object)pointConverter, (String)"pointConverter");
        this.decimatorResolution = 0.5;
        this.pointConverter = pointConverter;
    }

    public Geometry2Shape(@NotNull PointConverter pointConverter, double resolution) {
        Intrinsics.checkNotNullParameter((Object)pointConverter, (String)"pointConverter");
        this.decimatorResolution = 0.5;
        this.pointConverter = pointConverter;
        this.decimatorResolution = resolution;
    }

    private final Shape toShape(Polygon p) {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        int n = p.getNumInteriorRing();
        for (int j = 0; j < n; ++j) {
            LinearRing linearRing = p.getInteriorRingN(j);
            Intrinsics.checkNotNull((Object)linearRing);
            holeVertexCollection.add(this.toViewCoordinates(linearRing.getCoordinates()));
        }
        LinearRing linearRing = p.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        linearRing.getCoordinates();
        LinearRing linearRing2 = p.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing2);
        return new PolygonIShape(this.toViewCoordinates(linearRing2.getCoordinates()), (Collection<Coordinate[]>)holeVertexCollection);
    }

    @NotNull
    public final Coordinate[] toViewCoordinates(@NotNull Coordinate[] modelCoordinates) {
        Coordinate[] coordinateArray;
        Intrinsics.checkNotNullParameter((Object)modelCoordinates, (String)"modelCoordinates");
        Object[] viewCoordinates = new Coordinate[modelCoordinates.length];
        double ps = this.decimatorResolution / this.pointConverter.getScale();
        Coordinate p0 = modelCoordinates[0];
        int npts = 0;
        int mpts = modelCoordinates.length;
        for (int i = 0; i < mpts; ++i) {
            Coordinate pi = modelCoordinates[i];
            if (this.decimatorResolution > 0.0) {
                double xd = Math.abs(p0.x - pi.x);
                double yd = Math.abs(p0.y - pi.y);
                if (!(xd >= ps) && !(yd >= ps) && npts >= 4 && i != mpts - 1) continue;
                Point2D point2D = this.pointConverter.toViewPoint(pi);
                viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY(), 0.0, 4, null);
                p0 = pi;
                continue;
            }
            Point2D point2D = this.pointConverter.toViewPoint(pi);
            viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY(), 0.0, 4, null);
        }
        if (npts != mpts) {
            int n = 0;
            int n2 = npts;
            Coordinate[] coordinateArray2 = new Coordinate[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull((Object)viewCoordinates[n3]);
            }
            Coordinate[] viewCoordinates2 = coordinateArray2;
            coordinateArray = viewCoordinates2;
        } else {
            coordinateArray = (Coordinate[])ArraysKt.requireNoNulls((Object[])viewCoordinates);
        }
        return coordinateArray;
    }

    private final Shape toShape(GeometryCollection gc) {
        GeometryCollectionIShape shape = new GeometryCollectionIShape();
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            Shape shape2 = this.toShape(g);
            Intrinsics.checkNotNull((Object)shape2);
            shape.add(shape2);
        }
        return shape;
    }

    private final GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        int n = mls.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = mls.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString lineString = (LineString)geometry;
            path.append(Shape.DefaultImpls.getPathIterator$default((Shape)((Shape)this.toShape(lineString)), null, (int)1, null), false);
        }
        return path;
    }

    private final GeneralPath toShape(LineString lineString) {
        int numPoints = lineString.getNumPoints();
        GeneralPath shape = new GeneralPath(1, numPoints);
        PathIterator pi = new LineStringPath(lineString, this);
        shape.append(pi, false);
        return shape;
    }

    private final Shape toShape(Point point) {
        Coordinate coordinate = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        double d = coordinate.x - 2.09E-6;
        Coordinate coordinate2 = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate2);
        Point2D start = this.toViewPoint(new Coordinate(d, coordinate2.y + 2.09E-6, 0.0, 4, null));
        Coordinate coordinate3 = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate3);
        double d2 = coordinate3.x + 2.09E-6;
        Coordinate coordinate4 = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate4);
        Point2D end = this.toViewPoint(new Coordinate(d2, coordinate4.y - 2.09E-6, 0.0, 4, null));
        return (Shape)new Rectangle2D.Double(start.getX(), start.getY(), end.getX() - start.getX(), end.getY() - start.getY());
    }

    private final Point2D toViewPoint(Coordinate modelCoordinate) {
        return this.pointConverter.toViewPoint(modelCoordinate);
    }

    @Nullable
    public final Shape toShape(@Nullable Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return (Shape)new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((GeometryCollection)geometry);
        }
        if (geometry instanceof LineString) {
            return (Shape)this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return (Shape)this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + Reflection.getOrCreateKotlinClass(geometry.getClass()));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cartoplot/Geometry2Shape$Companion;", "", "()V", "POINT_MARKER_SIZE", "", "cartoplot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/cartoplot/Geometry2Shape$LineStringPath;", "Lorg/mkui/geom/PathIterator;", "linestring", "Lorg/locationtech/jts/geom/LineString;", "j2D", "Lcom/cartoplot/Geometry2Shape;", "(Lcom/cartoplot/Geometry2Shape;Lorg/locationtech/jts/geom/LineString;Lcom/cartoplot/Geometry2Shape;)V", "closed", "", "isDone", "()Z", "iterate", "", "numPoints", "points", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "segType", "getSegType", "()I", "windingRule", "getWindingRule", "currentSegment", "coords", "", "", "next", "", "cartoplot"})
    public final class LineStringPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        @NotNull
        private final Coordinate[] points;
        private final boolean closed;

        public LineStringPath(@NotNull LineString linestring, Geometry2Shape j2D) {
            Intrinsics.checkNotNullParameter((Object)linestring, (String)"linestring");
            Intrinsics.checkNotNullParameter((Object)j2D, (String)"j2D");
            this.points = j2D.toViewCoordinates(linestring.getCoordinates());
            this.numPoints = this.points.length;
            this.iterate = 0;
            this.closed = this.numPoints > 1 && this.points[0].equals2D(this.points[this.numPoints - 1]);
        }

        private final int getSegType() {
            if (this.closed && this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        public int currentSegment(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            coords[0] = this.points[this.iterate].x;
            coords[1] = this.points[this.iterate].y;
            return this.getSegType();
        }

        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            coords[0] = ((Float)this.points[this.iterate].x).floatValue();
            coords[1] = ((Float)this.points[this.iterate].y).floatValue();
            return this.getSegType();
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        public void next() {
            int n = this.iterate;
            this.iterate = n + 1;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/cartoplot/Geometry2Shape$PointConverter;", "", "scale", "", "getScale", "()D", "toViewPoint", "Lorg/mkui/geom/Point2D;", "modelCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "cartoplot"})
    public static interface PointConverter {
        @NotNull
        public Point2D toViewPoint(@Nullable Coordinate var1);

        public double getScale();
    }
}

