/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot;

import com.cartoplot.IShapeCollectionPathIterator;
import com.cartoplot.ShapeCollectionPathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B)\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0002J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0086\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0018H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J&\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0019\u0010$\u001a\u00020\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010&R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/cartoplot/PolygonIShape;", "Lorg/mkui/geom/Shape;", "()V", "shellVertices", "", "Lorg/locationtech/jts/geom/Coordinate;", "holeVerticesCollection", "", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/util/Collection;)V", "bounds2D", "Lorg/mkui/geom/Rectangle2D;", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "holes", "", "Lorg/mkui/geom/GeneralPath;", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "shell", "contains", "", "x", "", "y", "w", "h", "p", "Lorg/mkui/geom/Point2D;", "r", "getFlattenPathIterator", "flatness", "at", "Lorg/mkui/geom/AffineTransform;", "intersects", "toPolygon", "coordinates", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/mkui/geom/GeneralPath;", "PolygonPath", "cartoplot"})
public final class PolygonIShape
implements Shape {
    @Nullable
    private final GeneralPath shell;
    @Nullable
    private List<GeneralPath> holes;

    public PolygonIShape() {
        this.holes = new ArrayList();
        this.shell = null;
        this.holes = null;
    }

    public PolygonIShape(@NotNull Coordinate[] shellVertices, @NotNull Collection<Coordinate[]> holeVerticesCollection) {
        Intrinsics.checkNotNullParameter((Object)shellVertices, (String)"shellVertices");
        Intrinsics.checkNotNullParameter(holeVerticesCollection, (String)"holeVerticesCollection");
        this.holes = new ArrayList();
        this.shell = this.toPolygon(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            List<GeneralPath> list = this.holes;
            Intrinsics.checkNotNull(list);
            list.add(this.toPolygon(holeVertices));
        }
    }

    @NotNull
    public final GeneralPath toPolygon(@NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        int numPoints = coordinates.length;
        GeneralPath shape = new GeneralPath(0, numPoints);
        PathIterator pi = new PolygonPath(coordinates);
        shape.append(pi, false);
        return shape;
    }

    @NotNull
    public Rectangle2D getBounds2D() {
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        return generalPath.getBounds2D();
    }

    public final boolean contains(double x, double y) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean contains(@NotNull Point2D p) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        if (generalPath.contains(p)) {
            List<GeneralPath> list = this.holes;
            Intrinsics.checkNotNull(list);
            for (GeneralPath hole : list) {
                if (!hole.contains(p)) continue;
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean intersects(double x, double y, double w, double h) {
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        return generalPath.intersects(x, y, w, h);
    }

    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        return generalPath.intersects(r);
    }

    public final boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public final boolean contains(@Nullable Rectangle2D r) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @NotNull
    public PathIterator getPathIterator() {
        List rings = new ArrayList();
        rings.add(this.shell);
        List<GeneralPath> list = this.holes;
        Intrinsics.checkNotNull(list);
        rings.addAll((Collection)list);
        return new IShapeCollectionPathIterator(rings);
    }

    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator();
    }

    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        List rings = new ArrayList();
        rings.add(this.shell);
        List<GeneralPath> list = this.holes;
        Intrinsics.checkNotNull(list);
        rings.addAll((Collection)list);
        return new ShapeCollectionPathIterator(rings, at);
    }

    @NotNull
    public Rectangle getBounds() {
        return Shape.DefaultImpls.getBounds((Shape)this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u0096\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/cartoplot/PolygonIShape$PolygonPath;", "Lorg/mkui/geom/PathIterator;", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lcom/cartoplot/PolygonIShape;[Lorg/locationtech/jts/geom/Coordinate;)V", "isDone", "", "()Z", "iterate", "", "numPoints", "points", "[Lorg/locationtech/jts/geom/Coordinate;", "segType", "getSegType", "()I", "windingRule", "getWindingRule", "currentSegment", "coords", "", "", "next", "", "cartoplot"})
    public final class PolygonPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        @NotNull
        private final Coordinate[] points;

        public PolygonPath(Coordinate[] coordinates) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            this.points = coordinates;
            this.numPoints = this.points.length;
            this.iterate = 0;
        }

        private final int getSegType() {
            if (this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        public int currentSegment(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            coords[0] = this.points[this.iterate].x;
            coords[1] = this.points[this.iterate].y;
            return this.getSegType();
        }

        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            coords[0] = (float)this.points[this.iterate].x;
            coords[1] = (float)this.points[this.iterate].y;
            return this.getSegType();
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        public void next() {
            int n = this.iterate;
            this.iterate = n + 1;
        }
    }
}

