/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.georeferencing;

import com.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.common.crossplatform.CPHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.mkui.component.CPComponent;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R*\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u0004\u0018\u00018\u00012\b\u0010\u000e\u001a\u0004\u0018\u00018\u0001@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/cartoplot/georeferencing/GeometryGeoReferencingService;", "R", "C", "Lcom/cartoplot/georeferencing/AbstractGeoReferencingService;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "(Lorg/molap/dataframe/DataFrame;)V", "getDataFrame", "()Lorg/molap/dataframe/DataFrame;", "setDataFrame", "editor", "Lorg/mkui/component/CPComponent;", "getEditor", "()Lorg/mkui/component/CPComponent;", "<set-?>", "geometryIndex", "getGeometryIndex", "()Ljava/lang/Object;", "Ljava/lang/Object;", "isPointGeometry", "", "()Z", "isValid", "getGeometry", "Lorg/locationtech/jts/geom/Geometry;", "row", "(Ljava/lang/Object;)Lorg/locationtech/jts/geom/Geometry;", "setGeometryIndex", "", "(Ljava/lang/Object;)V", "toString", "", "cartoplot"})
public final class GeometryGeoReferencingService<R, C>
extends AbstractGeoReferencingService<R> {
    @NotNull
    private DataFrame<R, C, ?> dataFrame;
    @Nullable
    private C geometryIndex;

    public GeometryGeoReferencingService(@NotNull DataFrame<R, C, ?> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.dataFrame = dataFrame;
        for (Object c : dataFrame.columns()) {
            if (!CPHelper.Companion.getInstance().isAssignableFrom(Reflection.getOrCreateKotlinClass(Geometry.class), dataFrame.getColumnClass(c))) continue;
            this.setGeometryIndex(c);
        }
    }

    @NotNull
    protected final DataFrame<R, C, ?> getDataFrame() {
        return this.dataFrame;
    }

    protected final void setDataFrame(@NotNull DataFrame<R, C, ?> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"<set-?>");
        this.dataFrame = dataFrame;
    }

    @Nullable
    public final C getGeometryIndex() {
        return this.geometryIndex;
    }

    @Override
    public boolean isValid() {
        return this.geometryIndex != null;
    }

    @Override
    @Nullable
    public CPComponent getEditor() {
        return null;
    }

    @Override
    public boolean isPointGeometry() {
        CPHelper cPHelper = CPHelper.Companion.getInstance();
        KClass kClass = Reflection.getOrCreateKotlinClass(Point.class);
        C c = this.geometryIndex;
        Intrinsics.checkNotNull(c);
        return cPHelper.isAssignableFrom(kClass, this.dataFrame.getColumnClass(c));
    }

    @Override
    @Nullable
    public Geometry getGeometry(R row) {
        Geometry geometry;
        if (this.geometryIndex != null) {
            C c = this.geometryIndex;
            Intrinsics.checkNotNull(c);
            Object object = this.dataFrame.getValueAt(row, c);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            geometry = (Geometry)object;
        } else {
            geometry = null;
        }
        return geometry;
    }

    public final void setGeometryIndex(C geometryIndex) {
        if (this.geometryIndex != geometryIndex) {
            C old = this.geometryIndex;
            this.geometryIndex = geometryIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    @NotNull
    public String toString() {
        return "Geometry";
    }
}

