/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.georeferencing;

import com.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.common.crossplatform.CPHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.mkui.component.CPComponent;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001eJ\b\u0010 \u001a\u00020!H\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR$\u0010\u0012\u001a\u0004\u0018\u00018\u00012\b\u0010\u0011\u001a\u0004\u0018\u00018\u0001@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00018\u00012\b\u0010\u0011\u001a\u0004\u0018\u00018\u0001@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/cartoplot/georeferencing/LatLonGeoReferencingService;", "R", "C", "Lcom/cartoplot/georeferencing/AbstractGeoReferencingService;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "(Lorg/molap/dataframe/DataFrame;)V", "editor", "Lorg/mkui/component/CPComponent;", "getEditor", "()Lorg/mkui/component/CPComponent;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "isPointGeometry", "", "()Z", "isValid", "<set-?>", "latIndex", "getLatIndex", "()Ljava/lang/Object;", "Ljava/lang/Object;", "lonIndex", "getLonIndex", "getGeometry", "Lorg/locationtech/jts/geom/Geometry;", "row", "(Ljava/lang/Object;)Lorg/locationtech/jts/geom/Geometry;", "setLatIndex", "", "(Ljava/lang/Object;)V", "setLonIndex", "toString", "", "cartoplot"})
public final class LatLonGeoReferencingService<R, C>
extends AbstractGeoReferencingService<R> {
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final DataFrame<R, C, ?> dataFrame;
    @Nullable
    private C latIndex;
    @Nullable
    private C lonIndex;

    public LatLonGeoReferencingService(@NotNull DataFrame<R, C, ?> dataFrame) {
        block10: {
            String name;
            Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
            this.geometryFactory = new GeometryFactory(null, 0, null, 7, null);
            this.dataFrame = dataFrame;
            for (Object c : dataFrame.columns()) {
                if (!CPHelper.Companion.getInstance().isNumericType(dataFrame.getColumnClass(c))) continue;
                Intrinsics.checkNotNull((Object)dataFrame.getColumnName(c));
                if (StringsKt.equals((String)"Longitude", (String)name, (boolean)true) || StringsKt.equals((String)"Lon", (String)name, (boolean)true)) {
                    this.lonIndex = c;
                }
                if (StringsKt.equals((String)"Latitude", (String)name, (boolean)true) || StringsKt.equals((String)"Lat", (String)name, (boolean)true)) {
                    this.latIndex = c;
                }
                if (this.latIndex == null || this.lonIndex == null) continue;
            }
            if (this.lonIndex != null && this.latIndex != null) break block10;
            for (Object c : dataFrame.columns()) {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                Intrinsics.checkNotNull((Object)dataFrame.getColumnName(c));
                                String string = name.toLowerCase();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"longitude", (boolean)false, (int)2, null)) break block11;
                                String string2 = name.toLowerCase();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                                if (!StringsKt.startsWith$default((String)string2, (String)"lon", (boolean)false, (int)2, null)) break block12;
                            }
                            this.lonIndex = c;
                        }
                        String string = name.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"latitude", (boolean)false, (int)2, null)) break block13;
                        String string3 = name.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
                        if (!StringsKt.startsWith$default((String)string3, (String)"lat", (boolean)false, (int)2, null)) break block14;
                    }
                    this.latIndex = c;
                }
                if (this.latIndex == null || this.lonIndex == null) continue;
                break;
            }
        }
    }

    @Nullable
    public final C getLatIndex() {
        return this.latIndex;
    }

    @Nullable
    public final C getLonIndex() {
        return this.lonIndex;
    }

    @Override
    public boolean isValid() {
        return this.latIndex != null && this.lonIndex != null;
    }

    @Override
    @Nullable
    public CPComponent getEditor() {
        return null;
    }

    @Override
    public boolean isPointGeometry() {
        return true;
    }

    @Override
    @Nullable
    public Geometry getGeometry(R row) {
        if (this.latIndex != null && this.lonIndex != null) {
            C c = this.lonIndex;
            Intrinsics.checkNotNull(c);
            Object lonValue = this.dataFrame.getValueAt(row, c);
            C c2 = this.latIndex;
            Intrinsics.checkNotNull(c2);
            Object latValue = this.dataFrame.getValueAt(row, c2);
            if (lonValue != null && latValue != null && lonValue instanceof Number && latValue instanceof Number) {
                return (Geometry)this.geometryFactory.createPoint(new Coordinate(((Number)lonValue).doubleValue(), ((Number)latValue).doubleValue(), 0.0, 4, null));
            }
        }
        return null;
    }

    public final void setLatIndex(C latIndex) {
        if (this.latIndex != latIndex) {
            C old = this.latIndex;
            this.latIndex = latIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public final void setLonIndex(C lonIndex) {
        if (this.lonIndex != lonIndex) {
            C old = this.lonIndex;
            this.lonIndex = lonIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    @NotNull
    public String toString() {
        return "Latitude/Longitude";
    }
}

