/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.tile;

import com.cartoplot.tile.Tile;
import com.cartoplot.tile.TileFactory;
import com.cartoplot.tile.TileFactoryInfo;
import com.cartoplot.tile.TileListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/cartoplot/tile/AbstractTileFactory;", "Lcom/cartoplot/tile/TileFactory;", "info", "Lcom/cartoplot/tile/TileFactoryInfo;", "(Lcom/cartoplot/tile/TileFactoryInfo;)V", "getInfo", "()Lcom/cartoplot/tile/TileFactoryInfo;", "setInfo", "tileListeners", "", "Lcom/cartoplot/tile/TileListener;", "addTileListener", "", "listener", "fireTileLoadedEvent", "tile", "Lcom/cartoplot/tile/Tile;", "getMapWidth", "", "zoom", "removeTileListener", "cartoplot"})
public abstract class AbstractTileFactory
implements TileFactory {
    @NotNull
    private TileFactoryInfo info;
    @NotNull
    private final List<TileListener> tileListeners;

    public AbstractTileFactory(@NotNull TileFactoryInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        this.tileListeners = new ArrayList();
    }

    @Override
    @NotNull
    public TileFactoryInfo getInfo() {
        return this.info;
    }

    public void setInfo(@NotNull TileFactoryInfo tileFactoryInfo) {
        Intrinsics.checkNotNullParameter((Object)tileFactoryInfo, (String)"<set-?>");
        this.info = tileFactoryInfo;
    }

    @Override
    public int getMapWidth(int zoom) {
        return this.getInfo().getMapWidth(zoom);
    }

    @Override
    public void addTileListener(@NotNull TileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.tileListeners.add(listener2);
    }

    @Override
    public void removeTileListener(@NotNull TileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.tileListeners.remove(listener2);
    }

    public final void fireTileLoadedEvent(@Nullable Tile tile) {
        for (TileListener listener2 : this.tileListeners) {
            listener2.tileLoaded(tile);
        }
    }
}

