/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.tile;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Point2D;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001BW\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fBa\b\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J \u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J\u001e\u0010,\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/cartoplot/tile/TileFactoryInfo;", "", "minimumZoomLevel", "", "maximumZoomLevel", "totalMapZoom", "tileSize", "xr2l", "", "yt2b", "baseURL", "", "xparam", "yparam", "zparam", "(IIIIZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "name", "(Ljava/lang/String;IIIIZZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBaseURL", "()Ljava/lang/String;", "longitudeDegreeWidthInPixels", "", "longitudeRadianWidthInPixels", "mapCenterInPixelsAtZoom", "", "Lorg/mkui/geom/Point2D;", "[Lorg/mkui/geom/Point2D;", "mapWidthInTilesAtZoom", "", "getMaximumZoomLevel", "()I", "getMinimumZoomLevel", "getName", "getTileSize", "getXr2l", "()Z", "getYt2b", "getMapCenterInPixelsAtZoom", "zoom", "getMapWidth", "getMapWidthInTilesAtZoom", "getTileUrl", "x", "y", "isValidTile", "zoomLevel", "cartoplot"})
public class TileFactoryInfo {
    @NotNull
    private final String name;
    private final int minimumZoomLevel;
    private final int maximumZoomLevel;
    private final int tileSize;
    private final boolean xr2l;
    private final boolean yt2b;
    @NotNull
    private final String baseURL;
    @NotNull
    private final String xparam;
    @NotNull
    private final String yparam;
    @NotNull
    private final String zparam;
    @NotNull
    private final int[] mapWidthInTilesAtZoom;
    @NotNull
    private final Point2D[] mapCenterInPixelsAtZoom;
    @NotNull
    private final double[] longitudeDegreeWidthInPixels;
    @NotNull
    private final double[] longitudeRadianWidthInPixels;

    protected TileFactoryInfo(@NotNull String name, int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, @NotNull String baseURL, @NotNull String xparam, @NotNull String yparam, @NotNull String zparam) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)baseURL, (String)"baseURL");
        Intrinsics.checkNotNullParameter((Object)xparam, (String)"xparam");
        Intrinsics.checkNotNullParameter((Object)yparam, (String)"yparam");
        Intrinsics.checkNotNullParameter((Object)zparam, (String)"zparam");
        this.name = name;
        this.minimumZoomLevel = minimumZoomLevel;
        this.maximumZoomLevel = maximumZoomLevel;
        this.tileSize = tileSize;
        this.xr2l = xr2l;
        this.yt2b = yt2b;
        this.baseURL = baseURL;
        this.xparam = xparam;
        this.yparam = yparam;
        this.zparam = zparam;
        int tilesize = this.tileSize;
        this.longitudeDegreeWidthInPixels = new double[totalMapZoom + 1];
        this.longitudeRadianWidthInPixels = new double[totalMapZoom + 1];
        this.mapCenterInPixelsAtZoom = new Point2D[totalMapZoom + 1];
        this.mapWidthInTilesAtZoom = new int[totalMapZoom + 1];
        int z = 0;
        if (z <= totalMapZoom) {
            while (true) {
                this.longitudeDegreeWidthInPixels[z] = (double)tilesize / 360.0;
                this.longitudeRadianWidthInPixels[z] = (double)tilesize / (Math.PI * 2);
                double t2 = (double)tilesize / 2.0;
                this.mapCenterInPixelsAtZoom[z] = new Point2D.Double(t2, t2);
                this.mapWidthInTilesAtZoom[z] = tilesize / this.tileSize;
                tilesize *= 2;
                if (z == totalMapZoom) break;
                ++z;
            }
        }
    }

    public /* synthetic */ TileFactoryInfo(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, String string2, String string3, String string4, String string5, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            n4 = 256;
        }
        this(string, n, n2, n3, n4, bl, bl2, string2, string3, string4, string5);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getMinimumZoomLevel() {
        return this.minimumZoomLevel;
    }

    public final int getMaximumZoomLevel() {
        return this.maximumZoomLevel;
    }

    public final int getTileSize() {
        return this.tileSize;
    }

    public final boolean getXr2l() {
        return this.xr2l;
    }

    public final boolean getYt2b() {
        return this.yt2b;
    }

    @NotNull
    protected final String getBaseURL() {
        return this.baseURL;
    }

    public TileFactoryInfo(int minimumZoomLevel, int maximumZoomLevel, int totalMapZoom, int tileSize, boolean xr2l, boolean yt2b, @NotNull String baseURL, @NotNull String xparam, @NotNull String yparam, @NotNull String zparam) {
        Intrinsics.checkNotNullParameter((Object)baseURL, (String)"baseURL");
        Intrinsics.checkNotNullParameter((Object)xparam, (String)"xparam");
        Intrinsics.checkNotNullParameter((Object)yparam, (String)"yparam");
        Intrinsics.checkNotNullParameter((Object)zparam, (String)"zparam");
        this("name not provided", minimumZoomLevel, maximumZoomLevel, totalMapZoom, tileSize, xr2l, yt2b, baseURL, xparam, yparam, zparam);
    }

    public final int getMapWidthInTilesAtZoom(int zoom) {
        return this.mapWidthInTilesAtZoom[zoom];
    }

    @NotNull
    public final Point2D getMapCenterInPixelsAtZoom(int zoom) {
        Point2D point2D = this.mapCenterInPixelsAtZoom[zoom];
        Intrinsics.checkNotNull((Object)point2D);
        return point2D;
    }

    @NotNull
    public String getTileUrl(int x, int y, int zoom) {
        String ypart = "&" + this.yparam + "=" + y;
        if (!this.yt2b) {
            int tilemax = this.getMapWidthInTilesAtZoom(zoom);
            ypart = "&" + this.yparam + "=" + (tilemax / 2 - y - 1);
        }
        return this.baseURL + "&" + this.xparam + "=" + x + ypart + "&" + this.zparam + "=" + zoom;
    }

    public final int getMapWidth(int zoom) {
        return this.getMapWidthInTilesAtZoom(zoom);
    }

    public final boolean isValidTile(int x, int y, int zoomLevel) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (this.getMapCenterInPixelsAtZoom(zoomLevel).getX() * (double)2 <= (double)(x * this.tileSize)) {
            return false;
        }
        return this.getMapCenterInPixelsAtZoom(zoomLevel).getY() * (double)2 <= (double)(y * this.tileSize) ? false : zoomLevel >= this.minimumZoomLevel && zoomLevel <= this.maximumZoomLevel;
    }
}

