/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.tile;

import com.cartoplot.tile.TileFactoryInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo;", "Lcom/cartoplot/tile/TileFactoryInfo;", "mode", "Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo$MVEMode;", "(Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo$MVEMode;)V", "getTileUrl", "", "x", "", "y", "zoom", "tileToQuadKey", "tx", "ty", "zl", "Companion", "MVEMode", "cartoplot"})
public final class VirtualEarthTileFactoryInfo
extends TileFactoryInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MVEMode mode;
    @NotNull
    private static final MVEMode MAP = new MVEMode("map", "map", "r", ".png");
    @NotNull
    private static final MVEMode SATELLITE = new MVEMode("satellite", "satellite", "a", ".jpeg");
    @NotNull
    private static final MVEMode HYBRID = new MVEMode("hybrid", "hybrid", "h", ".jpeg");
    private static final int TOP_ZOOM_LEVEL = 19;
    private static final int MAX_ZOOM_LEVEL = 17;
    private static final int MIN_ZOOM_LEVEL = 2;
    private static final int TILE_SIZE = 256;

    public VirtualEarthTileFactoryInfo(@NotNull MVEMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        super("Virtual Earth", 2, 17, 19, 256, false, false, "", "", "", "");
        this.mode = mode;
    }

    @Override
    @NotNull
    public String getTileUrl(int x, int y, int zoom) {
        String quad = this.tileToQuadKey(x, y, zoom);
        return "http://" + this.mode.getType() + quad.charAt(quad.length() - 1) + ".ortho.tiles.virtualearth.net/tiles/" + this.mode.getType() + quad + this.mode.getExt() + "?g=1";
    }

    private final String tileToQuadKey(int tx, int ty, int zl) {
        Object quad = "";
        for (int i = zl; 0 < i; --i) {
            int mask = 1 << i - 1;
            int cell = 0;
            if ((tx & mask) != 0) {
                ++cell;
            }
            if ((ty & mask) != 0) {
                cell += 2;
            }
            quad = (String)quad + cell;
        }
        return quad;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo$Companion;", "", "()V", "HYBRID", "Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo$MVEMode;", "getHYBRID", "()Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo$MVEMode;", "MAP", "getMAP", "MAX_ZOOM_LEVEL", "", "MIN_ZOOM_LEVEL", "SATELLITE", "getSATELLITE", "TILE_SIZE", "TOP_ZOOM_LEVEL", "cartoplot"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MVEMode getMAP() {
            return MAP;
        }

        @NotNull
        public final MVEMode getSATELLITE() {
            return SATELLITE;
        }

        @NotNull
        public final MVEMode getHYBRID() {
            return HYBRID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/cartoplot/tile/VirtualEarthTileFactoryInfo$MVEMode;", "", "name", "", "label", "type", "ext", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExt", "()Ljava/lang/String;", "getType", "cartoplot"})
    public static final class MVEMode {
        @NotNull
        private final String name;
        @NotNull
        private final String label;
        @NotNull
        private final String type;
        @NotNull
        private final String ext;

        public MVEMode(@NotNull String name, @NotNull String label, @NotNull String type, @NotNull String ext) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
            this.name = name;
            this.label = label;
            this.type = type;
            this.ext = ext;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getExt() {
            return this.ext;
        }
    }
}

