/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.tooltip;

import com.cartoplot.CartoPlotModel;
import com.cartoplot.tooltip.TooltipLine;
import com.macrofocus.common.geom.Dimension;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.Insets;
import org.mkui.labeling.EnhancedLabel;
import org.mkui.tooltip.Tooltip;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020,2\u0006\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u0002012\u0006\u0010+\u001a\u00020,R\u0015\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR#\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b(\u0010)R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00066"}, d2={"Lcom/cartoplot/tooltip/CartoPlotTooltip;", "Row", "Column", "Lorg/mkui/tooltip/Tooltip;", "model", "Lcom/cartoplot/CartoPlotModel;", "row", "desiredLocation", "Lorg/mkui/geom/Point;", "(Lcom/cartoplot/CartoPlotModel;Ljava/lang/Object;Lorg/mkui/geom/Point;)V", "backgroundColor", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "getBackgroundColor", "()Ljava/awt/Color;", "borderColor", "getBorderColor", "borderThickness", "", "getBorderThickness", "()D", "getDesiredLocation", "()Lorg/mkui/geom/Point;", "insets", "Lorg/mkui/graphics/Insets;", "getInsets", "()Lorg/mkui/graphics/Insets;", "lines", "", "Lcom/cartoplot/tooltip/TooltipLine;", "getLines", "()Ljava/util/List;", "minimumHeight", "", "getMinimumHeight", "()I", "getModel", "()Lcom/cartoplot/CartoPlotModel;", "preferredWidth", "getPreferredWidth", "getRow", "()Ljava/lang/Object;", "Ljava/lang/Object;", "size", "Lcom/macrofocus/common/geom/Dimension;", "getSize", "()Lcom/macrofocus/common/geom/Dimension;", "computePreferredSize", "graphics", "Lorg/mkui/graphics/IGraphics;", "paint", "paintBackground", "", "g", "cartoplot"})
public final class CartoPlotTooltip<Row, Column>
implements Tooltip<Row> {
    @NotNull
    private final CartoPlotModel<Row, Column> model;
    private final Row row;
    @Nullable
    private final Point desiredLocation;
    @NotNull
    private final Dimension size;
    @NotNull
    private final Insets insets;
    private final int preferredWidth;
    private final int minimumHeight;
    @NotNull
    private final Color backgroundColor;
    @NotNull
    private final Color borderColor;
    private final double borderThickness;
    @NotNull
    private final List<TooltipLine<Row, Column>> lines;

    public CartoPlotTooltip(@NotNull CartoPlotModel<Row, Column> model, Row row, @Nullable Point desiredLocation) {
        List list;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.model = model;
        this.row = row;
        this.desiredLocation = desiredLocation;
        this.size = new Dimension(0, 0);
        this.insets = new Insets(2, 2, 2, 2);
        this.preferredWidth = 230;
        this.minimumHeight = 40;
        this.backgroundColor = MkColorKt.colorOf-bW95L_I((byte)-24, (byte)-24, (byte)-24, (byte)-56);
        this.borderColor = MkColorKt.colorOf-bW95L_I((byte)0, (byte)0, (byte)0, (byte)-16);
        this.borderThickness = 0.5;
        DataFrame<Row, Column, ?> dataFrame = this.model.getDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        if (Intrinsics.areEqual((Object)"independent", (Object)dataFrame.getValueAt(this.row, (Object)"Status"))) {
            Object[] objectArray = new TooltipLine[]{new TooltipLine<Row, Object>(this.model, "country_name", false), new TooltipLine<Row, Object>(this.model, "Status", true), new TooltipLine<Row, Object>(this.model, "Capital", true)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new TooltipLine[]{new TooltipLine<Row, Object>(this.model, "country_name", false), new TooltipLine<Row, Object>(this.model, "Status", true), new TooltipLine<Row, Object>(this.model, "Owned by", true), new TooltipLine<Row, Object>(this.model, "Capital", true)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        this.lines = list;
    }

    @NotNull
    public final CartoPlotModel<Row, Column> getModel() {
        return this.model;
    }

    public final Row getRow() {
        return this.row;
    }

    @Nullable
    public Point getDesiredLocation() {
        return this.desiredLocation;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    @NotNull
    public final Insets getInsets() {
        return this.insets;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final int getMinimumHeight() {
        return this.minimumHeight;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public final Color getBorderColor() {
        return this.borderColor;
    }

    public final double getBorderThickness() {
        return this.borderThickness;
    }

    @NotNull
    public final List<TooltipLine<Row, Column>> getLines() {
        return this.lines;
    }

    @NotNull
    public Dimension computePreferredSize(@NotNull IGraphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        int preferredWidth = this.preferredWidth - this.insets.getLeft() - this.insets.getRight();
        Dimension linesSize = null;
        for (TooltipLine<Row, Column> line : this.lines) {
            EnhancedLabel value = line.getValue(this.row);
            float height = (float)graphics.sizeLabel(value, preferredWidth, 1000).getPreferredHeight();
            Dimension size = new Dimension(preferredWidth, (int)height);
            if (linesSize == null) {
                linesSize = size;
                continue;
            }
            linesSize = new Dimension(size.getIwidth(), linesSize.getIheight() + size.getIheight());
        }
        if (linesSize != null) {
            Dimension drawableSize = new Dimension(linesSize.getIwidth() + this.insets.getLeft() + this.insets.getRight(), linesSize.getIheight() + this.insets.getTop() + this.insets.getBottom());
            return drawableSize;
        }
        return new Dimension(0, 0);
    }

    @NotNull
    public Dimension paint(@NotNull IGraphics graphics, @NotNull Dimension size) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.paintBackground(graphics, size);
        int x = this.insets.getLeft();
        int y = this.insets.getTop();
        graphics.translate(x, y);
        Dimension drawableSize = new Dimension(size.getIwidth() - this.insets.getLeft() - this.insets.getRight(), size.getIheight() - this.insets.getTop() - this.insets.getBottom());
        float ty = 0.0f;
        for (TooltipLine<Row, Column> line : this.lines) {
            float tx = 0.0f;
            double valueWidth = drawableSize.getWidth();
            EnhancedLabel value = line.getValue(this.row);
            Dimension valueSize = graphics.sizeLabel(value, drawableSize.getIwidth(), drawableSize.getIheight()).getPreferredSize();
            EnhancedLabel label = line.getLabel();
            if (label != null) {
                Dimension labelSize = graphics.sizeLabel(label, drawableSize.getIwidth(), drawableSize.getIheight()).getPreferredSize();
                Rectangle rect = new Rectangle(x, (int)ty, labelSize.getIwidth(), labelSize.getIheight());
                graphics.paintLabel(label, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
                tx += (float)labelSize.getIwidth();
                valueWidth -= (double)labelSize.getIwidth();
            }
            graphics.paintLabel(value, (int)tx, (int)ty, (int)valueWidth, drawableSize.getIheight());
            ty += (float)valueSize.getIheight();
        }
        graphics.translate(-x, -y);
        return size;
    }

    public final void paintBackground(@NotNull IGraphics g, @NotNull Dimension size) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        g.setColor(this.backgroundColor);
        g.fillRoundRect(0.0, 0.0, size.getWidth(), size.getHeight(), 10.0, 10.0);
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            g.setLineWidth(this.borderThickness);
            double halfThickness = this.borderThickness / (double)2;
            g.strokeRoundRect(halfThickness, halfThickness, (double)size.getIwidth() - this.borderThickness, (double)size.getIheight() - this.borderThickness, 10.0, 10.0);
        }
    }
}

