/*
 * Decompiled with CFR 0.152.
 */
package com.cartoplot.tooltip;

import com.cartoplot.CartoPlotModel;
import com.macrofocus.common.crossplatform.CPHelper;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFontKt;
import org.mkui.font.Weight;
import org.mkui.labeling.EnhancedLabel;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B)\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0013\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cartoplot/tooltip/TooltipLine;", "Row", "Column", "", "model", "Lcom/cartoplot/CartoPlotModel;", "column", "showLabel", "", "(Lcom/cartoplot/CartoPlotModel;Ljava/lang/Object;Z)V", "getColumn", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getModel", "()Lcom/cartoplot/CartoPlotModel;", "getLabel", "Lorg/mkui/labeling/EnhancedLabel;", "getValue", "row", "(Ljava/lang/Object;)Lorg/mkui/labeling/EnhancedLabel;", "cartoplot"})
public final class TooltipLine<Row, Column> {
    @NotNull
    private final CartoPlotModel<Row, Column> model;
    private final Column column;
    private final boolean showLabel;

    public TooltipLine(@NotNull CartoPlotModel<Row, Column> model, Column column, boolean showLabel) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.model = model;
        this.column = column;
        this.showLabel = showLabel;
    }

    @NotNull
    public final CartoPlotModel<Row, Column> getModel() {
        return this.model;
    }

    public final Column getColumn() {
        return this.column;
    }

    @Nullable
    public final EnhancedLabel getLabel() {
        if (this.showLabel) {
            DataFrame<Row, Column, ?> dataFrame = this.model.getDataFrame();
            Intrinsics.checkNotNull(dataFrame);
            return new EnhancedLabel(dataFrame.getColumnName(this.column) + ": ");
        }
        return null;
    }

    @NotNull
    public final EnhancedLabel getValue(Row row) {
        DataFrame<Row, Column, ?> dataFrame = this.model.getDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        DataFrame<Row, Column, ?> dataFrame2 = dataFrame;
        EnhancedLabel enhancedLabel = new EnhancedLabel(String.valueOf(dataFrame2.getValueAt(row, this.column)));
        Font font = enhancedLabel.getFont();
        Intrinsics.checkNotNull((Object)font);
        enhancedLabel.setFont(MkFontKt.deriveFontWeight((Font)font, (Weight)Weight.BOLD));
        if (!this.showLabel) {
            enhancedLabel.setHorizontalAlignment(0);
        } else if (CPHelper.Companion.getInstance().isNumericType(dataFrame2.getColumnClass(this.column))) {
            enhancedLabel.setHorizontalAlignment(4);
        } else {
            enhancedLabel.setHorizontalAlignment(2);
        }
        return enhancedLabel;
    }
}

