/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.swing.GeometryCollectionShape;
import com.macrofocus.cartoplot.swing.PolygonShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J#\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/macrofocus/cartoplot/swing/Java2DConverter;", "", "pointConverter", "Lcom/macrofocus/cartoplot/swing/Java2DConverter$PointConverter;", "(Lcom/macrofocus/cartoplot/swing/Java2DConverter$PointConverter;)V", "resolution", "", "(Lcom/macrofocus/cartoplot/swing/Java2DConverter$PointConverter;D)V", "decimatorResolution", "toShape", "Ljava/awt/Shape;", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "Ljava/awt/geom/GeneralPath;", "lineString", "Lorg/locationtech/jts/geom/LineString;", "mls", "Lorg/locationtech/jts/geom/MultiLineString;", "point", "Lorg/locationtech/jts/geom/Point;", "p", "Lorg/locationtech/jts/geom/Polygon;", "toViewCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "modelCoordinates", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "toViewPoint", "Ljava/awt/geom/Point2D;", "modelCoordinate", "Companion", "LineStringPath", "PointConverter", "cartoplot"})
public final class Java2DConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PointConverter pointConverter;
    private double decimatorResolution;
    private static final double POINT_MARKER_SIZE = 3.0;

    public Java2DConverter(@NotNull PointConverter pointConverter) {
        Intrinsics.checkNotNullParameter((Object)pointConverter, (String)"pointConverter");
        this.decimatorResolution = 0.5;
        this.pointConverter = pointConverter;
    }

    public Java2DConverter(@NotNull PointConverter pointConverter, double resolution) {
        Intrinsics.checkNotNullParameter((Object)pointConverter, (String)"pointConverter");
        this.decimatorResolution = 0.5;
        this.pointConverter = pointConverter;
        this.decimatorResolution = resolution;
    }

    private final Shape toShape(Polygon p) {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        int n = p.getNumInteriorRing();
        for (int j = 0; j < n; ++j) {
            LinearRing linearRing = p.getInteriorRingN(j);
            Intrinsics.checkNotNull((Object)linearRing);
            holeVertexCollection.add(this.toViewCoordinates(linearRing.getCoordinates()));
        }
        LinearRing linearRing = p.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        return new PolygonShape(this.toViewCoordinates(linearRing.getCoordinates()), (Collection<Coordinate[]>)holeVertexCollection);
    }

    @NotNull
    public final Coordinate[] toViewCoordinates(@NotNull Coordinate[] modelCoordinates) {
        Coordinate[] coordinateArray;
        Intrinsics.checkNotNullParameter((Object)modelCoordinates, (String)"modelCoordinates");
        Coordinate[] viewCoordinates = new Coordinate[modelCoordinates.length];
        double ps = this.decimatorResolution / this.pointConverter.getScale();
        Coordinate coordinate = modelCoordinates[0];
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate p0 = coordinate;
        int npts = 0;
        int mpts = modelCoordinates.length;
        for (int i = 0; i < mpts; ++i) {
            Coordinate pi;
            Intrinsics.checkNotNull((Object)modelCoordinates[i]);
            if (this.decimatorResolution > 0.0) {
                double xd = Math.abs(p0.x - pi.x);
                double yd = Math.abs(p0.y - pi.y);
                if (!(xd >= ps) && !(yd >= ps) && npts >= 4 && i != mpts - 1) continue;
                Point2D point2D = this.pointConverter.toViewPoint(pi);
                viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY(), 0.0, 4, null);
                p0 = pi;
                continue;
            }
            Point2D point2D = this.pointConverter.toViewPoint(pi);
            viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY(), 0.0, 4, null);
        }
        if (npts != mpts) {
            Coordinate[] viewCoordinates2 = new Coordinate[npts];
            int n = npts;
            for (int i = 0; i < n; ++i) {
                viewCoordinates2[i] = viewCoordinates[i];
            }
            coordinateArray = viewCoordinates2;
        } else {
            coordinateArray = viewCoordinates;
        }
        return coordinateArray;
    }

    private final Shape toShape(GeometryCollection gc) {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            Shape shape2 = this.toShape(g);
            Intrinsics.checkNotNull((Object)shape2);
            shape.add(shape2);
        }
        return shape;
    }

    private final GeneralPath toShape(MultiLineString mls) {
        GeneralPath path = new GeneralPath();
        int n = mls.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = mls.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString lineString = (LineString)geometry;
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private final GeneralPath toShape(LineString lineString) {
        int numPoints = lineString.getNumPoints();
        GeneralPath shape = new GeneralPath(1, numPoints);
        PathIterator pi = new LineStringPath(this, lineString, this);
        shape.append(pi, false);
        return shape;
    }

    private final Shape toShape(Point point) {
        Coordinate coordinate = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        double d = coordinate.x - 2.09E-6;
        Coordinate coordinate2 = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate2);
        Point2D start = this.toViewPoint(new Coordinate(d, coordinate2.y + 2.09E-6, 0.0, 4, null));
        Coordinate coordinate3 = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate3);
        double d2 = coordinate3.x + 2.09E-6;
        Coordinate coordinate4 = point.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate4);
        Point2D end = this.toViewPoint(new Coordinate(d2, coordinate4.y - 2.09E-6, 0.0, 4, null));
        return new Rectangle2D.Double(start.getX(), start.getY(), end.getX() - start.getX(), end.getY() - start.getY());
    }

    private final Point2D toViewPoint(Coordinate modelCoordinate) {
        return this.pointConverter.toViewPoint(modelCoordinate);
    }

    @Nullable
    public final Shape toShape(@Nullable Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((GeometryCollection)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + Reflection.getOrCreateKotlinClass(geometry.getClass()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/macrofocus/cartoplot/swing/Java2DConverter$Companion;", "", "()V", "POINT_MARKER_SIZE", "", "cartoplot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/macrofocus/cartoplot/swing/Java2DConverter$LineStringPath;", "Ljava/awt/geom/PathIterator;", "linestring", "Lorg/locationtech/jts/geom/LineString;", "j2D", "Lcom/macrofocus/cartoplot/swing/Java2DConverter;", "(Lcom/macrofocus/cartoplot/swing/Java2DConverter;Lorg/locationtech/jts/geom/LineString;Lcom/macrofocus/cartoplot/swing/Java2DConverter;)V", "closed", "", "iterate", "", "numPoints", "points", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "segType", "getSegType", "()I", "currentSegment", "coords", "", "", "getWindingRule", "isDone", "next", "", "cartoplot"})
    public final class LineStringPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        @NotNull
        private final Coordinate[] points;
        private final boolean closed;
        final /* synthetic */ Java2DConverter this$0;

        /*
         * Unable to fully structure code
         */
        public LineStringPath(@NotNull Java2DConverter this$0, @NotNull LineString linestring, Java2DConverter j2D) {
            Intrinsics.checkNotNullParameter((Object)linestring, (String)"linestring");
            Intrinsics.checkNotNullParameter((Object)j2D, (String)"j2D");
            this.this$0 = this$0;
            super();
            this.points = j2D.toViewCoordinates(linestring.getCoordinates());
            this.numPoints = this.points.length;
            this.iterate = 0;
            if (this.numPoints <= 1) ** GOTO lbl-1000
            v0 = this.points[0];
            Intrinsics.checkNotNull((Object)v0);
            v1 = this.points[this.numPoints - 1];
            Intrinsics.checkNotNull((Object)v1);
            if (v0.equals2D(v1)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            this.closed = v2;
        }

        private final int getSegType() {
            if (this.closed && this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            Coordinate coordinate = this.points[this.iterate];
            Intrinsics.checkNotNull((Object)coordinate);
            coords[0] = coordinate.x;
            Coordinate coordinate2 = this.points[this.iterate];
            Intrinsics.checkNotNull((Object)coordinate2);
            coords[1] = coordinate2.y;
            return this.getSegType();
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            Coordinate coordinate = this.points[this.iterate];
            Intrinsics.checkNotNull((Object)coordinate);
            coords[0] = (float)coordinate.x;
            Coordinate coordinate2 = this.points[this.iterate];
            Intrinsics.checkNotNull((Object)coordinate2);
            coords[1] = (float)coordinate2.y;
            return this.getSegType();
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        @Override
        public void next() {
            int n = this.iterate;
            this.iterate = n + 1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/macrofocus/cartoplot/swing/Java2DConverter$PointConverter;", "", "scale", "", "getScale", "()D", "toViewPoint", "Ljava/awt/geom/Point2D;", "modelCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "cartoplot"})
    public static interface PointConverter {
        @NotNull
        public Point2D toViewPoint(@Nullable Coordinate var1);

        public double getScale();
    }
}

