/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.swing.ShapeCollectionPathIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B)\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0019\u0010!\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010#R\u0018\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/macrofocus/cartoplot/swing/PolygonShape;", "Ljava/awt/Shape;", "()V", "shellVertices", "", "Lorg/locationtech/jts/geom/Coordinate;", "holeVerticesCollection", "", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/util/Collection;)V", "holes", "", "Ljava/awt/geom/GeneralPath;", "shell", "contains", "", "p", "Ljava/awt/geom/Point2D;", "r", "Ljava/awt/geom/Rectangle2D;", "x", "", "y", "w", "h", "getBounds", "Ljava/awt/Rectangle;", "getBounds2D", "getPathIterator", "Ljava/awt/geom/PathIterator;", "at", "Ljava/awt/geom/AffineTransform;", "flatness", "intersects", "toPolygon", "coordinates", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/awt/geom/GeneralPath;", "PolygonPath", "cartoplot"})
public final class PolygonShape
implements Shape {
    @Nullable
    private final GeneralPath shell;
    @Nullable
    private List<GeneralPath> holes;

    public PolygonShape() {
        this.holes = new ArrayList();
        this.shell = null;
        this.holes = null;
    }

    public PolygonShape(@NotNull Coordinate[] shellVertices, @NotNull Collection<Coordinate[]> holeVerticesCollection) {
        Intrinsics.checkNotNullParameter((Object)shellVertices, (String)"shellVertices");
        Intrinsics.checkNotNullParameter(holeVerticesCollection, (String)"holeVerticesCollection");
        this.holes = new ArrayList();
        this.shell = this.toPolygon(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            List<GeneralPath> list = this.holes;
            Intrinsics.checkNotNull(list);
            list.add(this.toPolygon(holeVertices));
        }
    }

    @NotNull
    public final GeneralPath toPolygon(@NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        int numPoints = coordinates.length;
        GeneralPath shape = new GeneralPath(0, numPoints);
        PathIterator pi = new PolygonPath(coordinates);
        shape.append(pi, false);
        return shape;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        Rectangle rectangle = generalPath.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        return rectangle;
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"getBounds2D(...)");
        return rectangle2D;
    }

    @Override
    public boolean contains(double x, double y) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        if (generalPath.contains(p)) {
            List<GeneralPath> list = this.holes;
            Intrinsics.checkNotNull(list);
            Iterator<GeneralPath> iterator = list.iterator();
            while (iterator.hasNext()) {
                GeneralPath hole;
                GeneralPath generalPath2 = hole = iterator.next();
                Intrinsics.checkNotNull((Object)generalPath2);
                if (!generalPath2.contains(p)) continue;
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        GeneralPath generalPath = this.shell;
        Intrinsics.checkNotNull((Object)generalPath);
        return generalPath.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        throw new UnsupportedOperationException("Method intersects() not yet implemented.");
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @Override
    public boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@NotNull AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        List rings = new ArrayList();
        rings.add(this.shell);
        List<GeneralPath> list = this.holes;
        Intrinsics.checkNotNull(list);
        rings.addAll((Collection)list);
        return new ShapeCollectionPathIterator(rings, at);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@NotNull AffineTransform at, double flatness) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.getPathIterator(at);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/macrofocus/cartoplot/swing/PolygonShape$PolygonPath;", "Ljava/awt/geom/PathIterator;", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lcom/macrofocus/cartoplot/swing/PolygonShape;[Lorg/locationtech/jts/geom/Coordinate;)V", "iterate", "", "numPoints", "points", "[Lorg/locationtech/jts/geom/Coordinate;", "segType", "getSegType", "()I", "currentSegment", "coords", "", "", "getWindingRule", "isDone", "", "next", "", "cartoplot"})
    public final class PolygonPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        @NotNull
        private final Coordinate[] points;

        public PolygonPath(Coordinate[] coordinates) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            this.points = coordinates;
            this.numPoints = this.points.length;
            this.iterate = 0;
        }

        private final int getSegType() {
            if (this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            coords[0] = this.points[this.iterate].x;
            coords[1] = this.points[this.iterate].y;
            return this.getSegType();
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            coords[0] = (float)this.points[this.iterate].x;
            coords[1] = (float)this.points[this.iterate].y;
            return this.getSegType();
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        @Override
        public void next() {
            int n = this.iterate;
            this.iterate = n + 1;
        }
    }
}

