/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.cartoplot.CartoPlotController;
import com.cartoplot.CartoPlotModel;
import com.cartoplot.CartoPlotView;
import com.macrofocus.common.selection.MutableSingleSelection;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.swing.SwingHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0003\u001d\u001e\u001fB\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00120\u000eR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R@\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00052\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController;", "R", "C", "Lcom/cartoplot/CartoPlotController;", "view", "Lcom/cartoplot/CartoPlotView;", "(Lcom/cartoplot/CartoPlotView;)V", "improvedBorderZooming", "", "keyListener", "Ljava/awt/event/KeyListener;", "mode", "Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController$Mode;", "mouseListener", "Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController$DefaultMouseListener;", "multipleSelectionEnabled", "selectOnPopupTrigger", "getView", "()Lcom/cartoplot/CartoPlotView;", "setView", "getViewport", "Ljava/awt/geom/Rectangle2D;", "getWorld", "zoom", "", "amount", "", "xCenter", "yCenter", "DefaultMouseListener", "Mode", "Range", "cartoplot"})
public final class SwingCartoPlotController<R, C>
implements CartoPlotController<R, C> {
    @Nullable
    private CartoPlotView<R, C> view;
    @NotNull
    private Mode mode;
    @NotNull
    private final DefaultMouseListener mouseListener;
    private final boolean multipleSelectionEnabled;
    private final boolean selectOnPopupTrigger;
    private final boolean improvedBorderZooming;
    @NotNull
    private final KeyListener keyListener;

    public SwingCartoPlotController(@NotNull CartoPlotView<R, C> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.mode = Mode.Selection;
        this.mouseListener = new DefaultMouseListener();
        this.multipleSelectionEnabled = true;
        this.keyListener = new KeyAdapter(this){
            @Nullable
            private Mode oldMode;
            final /* synthetic */ SwingCartoPlotController<R, C> this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final Mode getOldMode() {
                return this.oldMode;
            }

            public final void setOldMode(@Nullable Mode mode) {
                this.oldMode = mode;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 83) {
                    if (this.oldMode == null) {
                        this.oldMode = SwingCartoPlotController.access$getMode$p(this.this$0);
                    }
                    SwingCartoPlotController.access$setMode$p(this.this$0, Mode.Selection);
                }
                if (e.getKeyCode() == 90) {
                    if (this.oldMode == null) {
                        this.oldMode = SwingCartoPlotController.access$getMode$p(this.this$0);
                    }
                    SwingCartoPlotController.access$setMode$p(this.this$0, Mode.Zooming);
                }
                if (e.getKeyCode() == 80 || e.getKeyCode() == 32) {
                    if (this.oldMode == null) {
                        this.oldMode = SwingCartoPlotController.access$getMode$p(this.this$0);
                    }
                    SwingCartoPlotController.access$setMode$p(this.this$0, Mode.Panning);
                }
            }

            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.oldMode != null) {
                    Mode mode = this.oldMode;
                    Intrinsics.checkNotNull((Object)((Object)mode));
                    SwingCartoPlotController.access$setMode$p(this.this$0, mode);
                    this.oldMode = null;
                }
            }
        };
        this.setView(view);
    }

    @Override
    @Nullable
    public CartoPlotView<R, C> getView() {
        return this.view;
    }

    @Override
    public void setView(@Nullable CartoPlotView<R, C> view) {
        if (this.view != null) {
            CartoPlotView<R, C> cartoPlotView = this.view;
            Intrinsics.checkNotNull(cartoPlotView);
            cartoPlotView.getNativeComponent().removeKeyListener(this.keyListener);
            CartoPlotView<R, C> cartoPlotView2 = this.view;
            Intrinsics.checkNotNull(cartoPlotView2);
            cartoPlotView2.getNativeComponent().removeMouseListener(this.mouseListener);
            CartoPlotView<R, C> cartoPlotView3 = this.view;
            Intrinsics.checkNotNull(cartoPlotView3);
            cartoPlotView3.getNativeComponent().removeMouseMotionListener(this.mouseListener);
            CartoPlotView<R, C> cartoPlotView4 = this.view;
            Intrinsics.checkNotNull(cartoPlotView4);
            cartoPlotView4.getNativeComponent().removeMouseWheelListener(this.mouseListener);
        }
        this.view = view;
        if (view != null) {
            view.getNativeComponent().setFocusable(true);
            view.getNativeComponent().addKeyListener(this.keyListener);
            view.getNativeComponent().addMouseListener(this.mouseListener);
            view.getNativeComponent().addMouseMotionListener(this.mouseListener);
            view.getNativeComponent().addMouseWheelListener(this.mouseListener);
        }
    }

    private final void zoom(double amount, double xCenter, double yCenter) {
        java.awt.geom.Rectangle2D viewport = this.getViewport();
        java.awt.geom.Rectangle2D world = this.getWorld();
        Double d = xCenter;
        double d2 = viewport.getMinX();
        double d3 = viewport.getWidth();
        double d4 = world.getMinX();
        double d5 = world.getMaxX();
        CartoPlotView<R, C> cartoPlotView = this.getView();
        Intrinsics.checkNotNull(cartoPlotView);
        Range xRange = new Range(amount, d, d2, d3, d4, d5, cartoPlotView.getXRangeModel().getMaximumExtent()).invoke();
        double xMin = xRange.getMin();
        double xMax = xRange.getMax();
        Double d6 = yCenter;
        double d7 = viewport.getMinY();
        double d8 = viewport.getHeight();
        double d9 = world.getMinY();
        double d10 = world.getMaxY();
        CartoPlotView<R, C> cartoPlotView2 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView2);
        Range yRange = new Range(amount, d6, d7, d8, d9, d10, cartoPlotView2.getYRangeModel().getMaximumExtent()).invoke();
        double yMin = yRange.getMin();
        double yMax = yRange.getMax();
        if (xMin < xMax && yMin < yMax) {
            CartoPlotView<R, C> cartoPlotView3 = this.getView();
            Intrinsics.checkNotNull(cartoPlotView3);
            cartoPlotView3.zoom(false, xMin, xMax, yMin, yMax);
        }
    }

    @NotNull
    public final java.awt.geom.Rectangle2D getViewport() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        CartoPlotView<R, C> cartoPlotView = this.getView();
        Intrinsics.checkNotNull(cartoPlotView);
        double d = cartoPlotView.getXRangeModel().getStart();
        CartoPlotView<R, C> cartoPlotView2 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView2);
        double d2 = cartoPlotView2.getYRangeModel().getStart();
        CartoPlotView<R, C> cartoPlotView3 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView3);
        double d3 = cartoPlotView3.getXRangeModel().getStart();
        CartoPlotView<R, C> cartoPlotView4 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView4);
        double d4 = d3 + cartoPlotView4.getXRangeModel().getExtent();
        CartoPlotView<R, C> cartoPlotView5 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView5);
        double d5 = cartoPlotView5.getYRangeModel().getStart();
        CartoPlotView<R, C> cartoPlotView6 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView6);
        r.setFrameFromDiagonal(d, d2, d4, d5 + cartoPlotView6.getYRangeModel().getExtent());
        return r;
    }

    @NotNull
    public final java.awt.geom.Rectangle2D getWorld() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        CartoPlotView<R, C> cartoPlotView = this.getView();
        Intrinsics.checkNotNull(cartoPlotView);
        double d = cartoPlotView.getXRangeModel().getMinimum();
        CartoPlotView<R, C> cartoPlotView2 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView2);
        double d2 = cartoPlotView2.getYRangeModel().getMinimum();
        CartoPlotView<R, C> cartoPlotView3 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView3);
        double d3 = cartoPlotView3.getXRangeModel().getMaximum();
        CartoPlotView<R, C> cartoPlotView4 = this.getView();
        Intrinsics.checkNotNull(cartoPlotView4);
        r.setFrameFromDiagonal(d, d2, d3, cartoPlotView4.getYRangeModel().getMaximum());
        return r;
    }

    public static final /* synthetic */ Mode access$getMode$p(SwingCartoPlotController $this) {
        return $this.mode;
    }

    public static final /* synthetic */ void access$setMode$p(SwingCartoPlotController $this, Mode mode) {
        $this.mode = mode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u001f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController$DefaultMouseListener;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "Ljava/awt/event/MouseWheelListener;", "(Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController;)V", "last", "Ljava/awt/Point;", "pressedPoint", "selectOnRelease", "Ljava/lang/Object;", "zoomOnRelease", "zoomingPoint", "addToSelection", "", "observation", "(Ljava/lang/Object;)V", "newSelection", "", "mouseClicked", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "event", "mousePressed", "mouseReleased", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "removeFromSelection", "setSelection", "cartoplot"})
    private final class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Nullable
        private Point last;
        @Nullable
        private R selectOnRelease;
        @Nullable
        private Point zoomOnRelease;
        @Nullable
        private final Point zoomingPoint;
        @Nullable
        private Point pressedPoint;

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SwingCartoPlotController.this.getView() != null) {
                CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView);
                cartoPlotView.getNativeComponent().requestFocusInWindow();
                CartoPlotView cartoPlotView2 = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView2);
                if (cartoPlotView2.getModel() != null) {
                    Point point = e.getPoint();
                    CartoPlotView cartoPlotView3 = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView3);
                    CartoPlotModel cartoPlotModel = cartoPlotView3.getModel();
                    Intrinsics.checkNotNull(cartoPlotModel);
                    MutableSingleSelection mutableSingleSelection = cartoPlotModel.getProbing();
                    CartoPlotView cartoPlotView4 = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView4);
                    mutableSingleSelection.setSelected(cartoPlotView4.getClosestRow(point.x, point.y));
                }
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SwingCartoPlotController.this.getView() != null) {
                CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView);
                if (cartoPlotView.getModel() != null) {
                    CartoPlotView cartoPlotView2 = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView2);
                    CartoPlotModel cartoPlotModel = cartoPlotView2.getModel();
                    Intrinsics.checkNotNull(cartoPlotModel);
                    cartoPlotModel.getProbing().clearSelection();
                }
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            block4: {
                block5: {
                    Object bestrow;
                    block6: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            if (SwingCartoPlotController.this.getView() == null) break block4;
                            this.pressedPoint = e.getPoint();
                            CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(cartoPlotView);
                            cartoPlotView.getNativeComponent().requestFocus();
                            CartoPlotView cartoPlotView2 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(cartoPlotView2);
                            bestrow = cartoPlotView2.getClosestRow(e.getX(), e.getY());
                            if (bestrow == null) break block5;
                            if (SwingHelper.INSTANCE.isMultipleSelectionKey((InputEvent)e)) break block6;
                            CartoPlotView cartoPlotView3 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(cartoPlotView3);
                            CartoPlotModel cartoPlotModel = cartoPlotView3.getModel();
                            Intrinsics.checkNotNull(cartoPlotModel);
                            if (!cartoPlotModel.getSelection().isSelected(bestrow)) break block7;
                            CartoPlotView cartoPlotView4 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(cartoPlotView4);
                            CartoPlotModel cartoPlotModel2 = cartoPlotView4.getModel();
                            Intrinsics.checkNotNull(cartoPlotModel2);
                            if (cartoPlotModel2.getSelection().getSelectedCount() <= 1) break block4;
                        }
                        CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView);
                        CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel);
                        cartoPlotModel.getSelection().clearSelection();
                        CartoPlotView cartoPlotView5 = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView5);
                        CartoPlotModel cartoPlotModel3 = cartoPlotView5.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel3);
                        cartoPlotModel3.getSelection().setSelectedElement(bestrow);
                        CartoPlotView cartoPlotView6 = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView6);
                        CartoPlotView cartoPlotView7 = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView7);
                        CartoPlotModel cartoPlotModel4 = cartoPlotView7.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel4);
                        cartoPlotView6.setSelectionMode(cartoPlotModel4.getSelection().isSelected(bestrow));
                        break block4;
                    }
                    CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView);
                    CartoPlotView cartoPlotView8 = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView8);
                    CartoPlotModel cartoPlotModel = cartoPlotView8.getModel();
                    Intrinsics.checkNotNull(cartoPlotModel);
                    cartoPlotView.setSelectionMode(!cartoPlotModel.getSelection().isSelected(bestrow));
                    CartoPlotView cartoPlotView9 = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView9);
                    if (cartoPlotView9.isSelectionMode()) {
                        CartoPlotView cartoPlotView10 = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView10);
                        CartoPlotModel cartoPlotModel5 = cartoPlotView10.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel5);
                        cartoPlotModel5.getSelection().setSelectedState(bestrow, true);
                    } else {
                        CartoPlotView cartoPlotView11 = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView11);
                        CartoPlotModel cartoPlotModel6 = cartoPlotView11.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel6);
                        cartoPlotModel6.getSelection().setSelectedState(bestrow, false);
                    }
                    break block4;
                }
                CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView);
                CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                cartoPlotModel.getSelection().clearSelection();
            }
        }

        private final void removeFromSelection(R observation) {
            CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
            Intrinsics.checkNotNull(cartoPlotView);
            CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
            Intrinsics.checkNotNull(cartoPlotModel);
            cartoPlotModel.getSelection().setSelectedState(observation, false);
        }

        private final void setSelection(R observation) {
            if (observation != null) {
                CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView);
                CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                Object[] objectArray = new Object[]{observation};
                cartoPlotModel.getSelection().setSelectedElements(objectArray);
            } else {
                CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView);
                CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
                Intrinsics.checkNotNull(cartoPlotModel);
                cartoPlotModel.getSelection().clearSelection();
            }
        }

        private final void addToSelection(R observation) {
            CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
            Intrinsics.checkNotNull(cartoPlotView);
            CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
            Intrinsics.checkNotNull(cartoPlotModel);
            cartoPlotModel.getSelection().setSelectedState(observation, true);
        }

        private final void addToSelection(List<? extends R> newSelection) {
            CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
            Intrinsics.checkNotNull(cartoPlotView);
            CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
            Intrinsics.checkNotNull(cartoPlotModel);
            cartoPlotModel.getSelection().setSelectedIterable((Iterable)newSelection);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SwingCartoPlotController.this.getView() != null) {
                if (!e.isPopupTrigger()) {
                    if (this.selectOnRelease != null && SwingUtilities.isLeftMouseButton(e)) {
                        CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                        Intrinsics.checkNotNull(cartoPlotView);
                        CartoPlotModel cartoPlotModel = cartoPlotView.getModel();
                        Intrinsics.checkNotNull(cartoPlotModel);
                        cartoPlotModel.getSelection().clearSelection();
                        if (SwingCartoPlotController.this.multipleSelectionEnabled) {
                            Object r = this.selectOnRelease;
                            Intrinsics.checkNotNull(r);
                            this.addToSelection(r);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView);
                    cartoPlotView.stopRubberBand();
                } else if (SwingCartoPlotController.this.selectOnPopupTrigger) {
                    CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(cartoPlotView);
                    Object node = cartoPlotView.getClosestRow(e.getPoint().x, e.getPoint().y);
                    this.setSelection(node);
                }
                this.last = null;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            block20: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingCartoPlotController.this.getView() == null) break block20;
                    v0 = SwingCartoPlotController.this.getView();
                    Intrinsics.checkNotNull(v0);
                    if (v0.getModel() == null) break block20;
                    point = e.getPoint();
                    if (this.last == null) break block21;
                    switch (WhenMappings.$EnumSwitchMapping$0[SwingCartoPlotController.access$getMode$p(SwingCartoPlotController.this).ordinal()]) {
                        case 1: {
                            if (!SwingUtilities.isLeftMouseButton(e)) break;
                            if (e.isAltDown() || e.isShiftDown()) {
                                v1 = SwingCartoPlotController.this.getView();
                                Intrinsics.checkNotNull(v1);
                                v2 = v1.getModel();
                                Intrinsics.checkNotNull(v2);
                                v2.getProbing().clearSelection();
                                if (!SwingCartoPlotController.access$getMultipleSelectionEnabled$p(SwingCartoPlotController.this)) break;
                                v3 = SwingCartoPlotController.this.getView();
                                Intrinsics.checkNotNull(v3);
                                if (!v3.getRubberBand().isActive()) {
                                    v4 = SwingCartoPlotController.this.getView();
                                    Intrinsics.checkNotNull(v4);
                                    v5 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v5);
                                    v6 = v5.x;
                                    v7 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v7);
                                    v4.startRubberBand(v6, v7.y);
                                }
                                v8 = SwingCartoPlotController.this.getView();
                                Intrinsics.checkNotNull(v8);
                                v8.stretchRubberBand(e.getPoint().x, e.getPoint().y);
                                v9 = SwingCartoPlotController.this.getView();
                                Intrinsics.checkNotNull(v9);
                                rect = v9.getRubberBandScreen();
                                if (rect == null) break;
                                v10 = SwingCartoPlotController.this.getView();
                                Intrinsics.checkNotNull(v10);
                                toSelect = v10.getRows((Rectangle2D)new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()));
                                if (e.isControlDown()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    v11 = SwingCartoPlotController.this.getView();
                                    Intrinsics.checkNotNull(v11);
                                    v12 = v11.getModel();
                                    Intrinsics.checkNotNull(v12);
                                    v12.getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            v13 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v13);
                            observation = v13.getClosestRow(point.x, point.y);
                            v14 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v14);
                            v15 = v14.getModel();
                            Intrinsics.checkNotNull(v15);
                            v15.getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            v16 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v16);
                            v17 = v16.getModel();
                            Intrinsics.checkNotNull(v17);
                            if (v17.getSelection() == null) ** GOTO lbl-1000
                            v18 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v18);
                            v19 = v18.getModel();
                            Intrinsics.checkNotNull(v19);
                            if (v19.getSelection().isSelected(observation)) {
                                v20 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v20 = isAlreadySelected = false;
                            }
                            if (!isAlreadySelected && !SwingHelper.INSTANCE.isMenuShortcutKeyDown((InputEvent)e)) {
                                v21 = SwingCartoPlotController.this.getView();
                                Intrinsics.checkNotNull(v21);
                                v22 = v21.getModel();
                                Intrinsics.checkNotNull(v22);
                                v22.getSelection().clearSelection();
                            }
                            if (SwingHelper.INSTANCE.isMenuShortcutKeyDown((InputEvent)e)) {
                                if (SwingCartoPlotController.access$getMultipleSelectionEnabled$p(SwingCartoPlotController.this)) {
                                    v23 = observation;
                                    Intrinsics.checkNotNull(v23);
                                    this.addToSelection(v23);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (SwingCartoPlotController.access$getMultipleSelectionEnabled$p(SwingCartoPlotController.this)) {
                                v24 = observation;
                                Intrinsics.checkNotNull(v24);
                                this.addToSelection(v24);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!SwingUtilities.isLeftMouseButton(e)) break;
                            viewport = SwingCartoPlotController.this.getViewport();
                            world = SwingCartoPlotController.this.getWorld();
                            v25 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v25);
                            v26 = v25.getScreenTransform().getX();
                            v27 = this.last;
                            Intrinsics.checkNotNull((Object)v27);
                            x1 = v26.screenToWorld(v27.x);
                            v28 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v28);
                            x2 = v28.getScreenTransform().getX().screenToWorld(e.getPoint().x);
                            worldDiffX = x1 - x2;
                            xMin = viewport.getMinX() + worldDiffX;
                            xMax = viewport.getMaxX() + worldDiffX;
                            v29 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v29);
                            v30 = v29.getScreenTransform().getY();
                            v31 = this.last;
                            Intrinsics.checkNotNull((Object)v31);
                            y1 = v30.screenToWorld(v31.y);
                            v32 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v32);
                            y2 = v32.getScreenTransform().getY().screenToWorld(e.getPoint().y);
                            worldDiffY = y1 - y2;
                            yMin = viewport.getMinY() + worldDiffY;
                            yMax = viewport.getMaxY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            xMin = Math.max(world.getMinX(), xMin);
                            xMax = Math.min(world.getMaxX(), xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            yMin = Math.max(world.getMinY(), yMin);
                            yMax = Math.min(world.getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            v33 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v33);
                            v33.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 3: {
                            if (!SwingUtilities.isMiddleMouseButton(e)) break;
                            p = e.getPoint();
                            v34 = e.getPoint().y;
                            v35 = this.last;
                            Intrinsics.checkNotNull((Object)v35);
                            v36 = v34 - (double)v35.y / 100.0;
                            v37 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v37);
                            v38 = v37.getScreenTransform().getX().screenToWorld(p.x);
                            v39 = SwingCartoPlotController.this.getView();
                            Intrinsics.checkNotNull(v39);
                            SwingCartoPlotController.access$zoom(SwingCartoPlotController.this, v36, v38, v39.getScreenTransform().getY().screenToWorld(p.y));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = e.getPoint();
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
            Intrinsics.checkNotNull(cartoPlotView);
            Object closest = cartoPlotView.getClosestRow(event.getX(), event.getY());
            CartoPlotView cartoPlotView2 = SwingCartoPlotController.this.getView();
            Intrinsics.checkNotNull(cartoPlotView2);
            CartoPlotModel cartoPlotModel = cartoPlotView2.getModel();
            Intrinsics.checkNotNull(cartoPlotModel);
            cartoPlotModel.getProbing().setSelected(closest);
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SwingCartoPlotController.this.getView() != null) {
                int amount = e.getWheelRotation();
                Point p = e.getPoint();
                double d = (double)amount / 20.0;
                CartoPlotView cartoPlotView = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView);
                double d2 = cartoPlotView.getScreenTransform().getX().screenToWorld(p.x);
                CartoPlotView cartoPlotView2 = SwingCartoPlotController.this.getView();
                Intrinsics.checkNotNull(cartoPlotView2);
                SwingCartoPlotController.this.zoom(d, d2, cartoPlotView2.getScreenTransform().getY().screenToWorld(p.y));
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.Selection.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.Panning.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.Zooming.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController$Mode;", "", "(Ljava/lang/String;I)V", "Selection", "Zooming", "Panning", "cartoplot"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Selection = new Mode();
        public static final /* enum */ Mode Zooming = new Mode();
        public static final /* enum */ Mode Panning = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Selection, Mode.Zooming, Mode.Panning};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0019\u0010\u0010\u001a\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController$Range;", "", "_amount", "", "_center", "_start", "_extent", "_minRange", "_maxRange", "_maxExtent", "(Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController;DLjava/lang/Double;DDDDD)V", "Ljava/lang/Double;", "_max", "_min", "getMax", "getMin", "invoke", "Lcom/macrofocus/cartoplot/swing/SwingCartoPlotController;", "cartoplot"})
    private final class Range {
        private final double _amount;
        @Nullable
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private final double _maxExtent;
        private double _min;
        private double _max;

        public Range(@Nullable double _amount, Double _center, double _start, double _extent, double _minRange, double _maxRange, double _maxExtent) {
            this._amount = _amount;
            this._center = _center;
            this._start = _start;
            this._extent = _extent;
            this._minRange = _minRange;
            this._maxRange = _maxRange;
            this._maxExtent = _maxExtent;
        }

        public final double getMin() {
            return this._min;
        }

        public final double getMax() {
            return this._max;
        }

        @NotNull
        public final Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            this._min = Math.max(this._minRange, this._min);
            this._max = Math.min(this._maxRange, this._max);
            return this;
        }
    }
}

