/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.cartoplot.CartoPlotView;
import com.cartoplot.tile.CartoDBDarkTileFactoryInfo;
import com.cartoplot.tile.CartoDBLightTileFactoryInfo;
import com.cartoplot.tile.OSMTileFactoryInfo;
import com.cartoplot.tile.Tile;
import com.cartoplot.tile.TileFactoryInfo;
import com.cartoplot.tile.TileListener;
import com.macrofocus.cartoplot.swing.AbstractCartoPlotView;
import com.macrofocus.cartoplot.swing.tile.SwingTile;
import com.macrofocus.cartoplot.swing.tile.SwingTileFactory;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.transform.OneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.SwingXNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.SwingYNumberOneDScreenTransformAxisGuide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.SwingIGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.labeling.EnhancedJLabel;
import org.mkui.labeling.EnhancedLabel;
import org.mkui.swing.SwingHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020&H\u0014J\b\u0010)\u001a\u00020&H\u0014J\u0012\u0010*\u001a\u00020&2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010+\u001a\u00020&2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010,\u001a\u00020&H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"\u00a8\u0006."}, d2={"Lcom/macrofocus/cartoplot/swing/SwingCartoPlotView;", "Row", "C", "Column", "Lcom/macrofocus/cartoplot/swing/AbstractCartoPlotView;", "()V", "backgroundAlpha", "", "info", "Lcom/cartoplot/tile/TileFactoryInfo;", "getInfo", "()Lcom/cartoplot/tile/TileFactoryInfo;", "setInfo", "(Lcom/cartoplot/tile/TileFactoryInfo;)V", "licenseModel", "Lcom/macrofocus/license/LicenseModel;", "nativeComponent", "Ljavax/swing/JComponent;", "getNativeComponent", "()Ljavax/swing/JComponent;", "propertiesListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "Lcom/cartoplot/CartoPlotView$PropertyType;", "tileFactory", "Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory;", "tileLoadListener", "Lcom/cartoplot/tile/TileListener;", "unregisteredPanel", "Ljavax/swing/JPanel;", "unregisteredPanelListener", "Ljava/awt/event/ComponentAdapter;", "xGuide", "Lcom/macrofocus/plot/guide/Guide;", "getXGuide", "()Lcom/macrofocus/plot/guide/Guide;", "yGuide", "getYGuide", "populateOverplots", "", "refresh", "repaint", "scheduleUpdate", "setLicenseModel", "setTileFactory", "updateTileFactory", "SwingMapIDrawing", "cartoplot"})
public final class SwingCartoPlotView<Row, C, Column>
extends AbstractCartoPlotView<Row, Column> {
    @NotNull
    private final JComponent nativeComponent;
    @NotNull
    private final Guide xGuide;
    @NotNull
    private final Guide yGuide;
    @Nullable
    private final LicenseModel licenseModel;
    @Nullable
    private JPanel unregisteredPanel;
    @Nullable
    private ComponentAdapter unregisteredPanelListener;
    @NotNull
    private TileFactoryInfo info = new OSMTileFactoryInfo();
    @NotNull
    private final PropertiesListener<CartoPlotView.PropertyType> propertiesListener;
    @NotNull
    private final TileListener tileLoadListener;
    @Nullable
    private SwingTileFactory tileFactory;
    private final float backgroundAlpha;

    public SwingCartoPlotView() {
        this.nativeComponent = new JLayeredPane(){

            @Override
            public void updateUI() {
                block1: {
                    this.setBackground(null);
                    ColorTheme colorTheme = (ColorTheme)this.getColorTheme().getValue();
                    if (colorTheme != null) {
                        Color color = this.getBackground();
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
                        Color background = color;
                        colorTheme.setBackground(MkColorKt.colorOf((int)background.getRed(), (int)background.getGreen(), (int)background.getBlue(), (int)background.getAlpha()));
                        this.setBackground(colorTheme.getBackground());
                        this.setForeground(colorTheme.getForeground());
                    }
                    SwingTileFactory swingTileFactory = tileFactory;
                    if (swingTileFactory == null) break block1;
                    swingTileFactory.clearCache();
                }
            }
        };
        this.getNativeComponent().setLayout(new OverlayLayout(this.getNativeComponent()));
        JComponent jComponent = this.getNativeComponent();
        Component component = this.getCanvas().getNativeComponent();
        Integer n = JLayeredPane.MODAL_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"MODAL_LAYER");
        jComponent.add(component, ((Number)n).intValue());
        this.propertiesListener = (PropertiesListener)new PropertiesListener<CartoPlotView.PropertyType>(){

            public void propertyChanged(@NotNull CartoPlotView.PropertyType name, @NotNull PropertyEvent<Object> event) {
                Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.updateTileFactory();
                this.createOverplots();
                this.scheduleUpdate();
                if (name == CartoPlotView.PropertyType.ColorTheme) {
                    this.getNativeComponent().updateUI();
                    this.getNativeComponent().repaint();
                }
            }
        };
        this.getProperties().addPropertiesListener(this.propertiesListener);
        this.getNativeComponent().setOpaque(true);
        this.getNativeComponent().addHierarchyListener(arg_0 -> SwingCartoPlotView._init_$lambda$0(this, arg_0));
        this.tileLoadListener = new TileListener(){

            @Override
            public void tileLoaded(@Nullable Tile tile) {
                this.getNativeComponent().repaint();
            }
        };
        this.updateTileFactory();
        this.xGuide = (Guide)new SwingXNumberOneDScreenTransformAxisGuide((OneDScreenTransform)this.getScreenTransform().getX());
        this.yGuide = (Guide)new SwingYNumberOneDScreenTransformAxisGuide(Guide.Type.Left, (OneDScreenTransform)this.getScreenTransform().getY());
        this.getScreenTransform().addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(@NotNull ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getTimer().restart();
                this.getNativeComponent().repaint();
            }
        });
        this.getNativeComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.scheduleUpdate();
            }

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.scheduleUpdate();
            }
        });
        this.backgroundAlpha = 0.3f;
    }

    @NotNull
    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    @Override
    @NotNull
    public Guide getXGuide() {
        return this.xGuide;
    }

    @Override
    @NotNull
    public Guide getYGuide() {
        return this.yGuide;
    }

    @NotNull
    public final TileFactoryInfo getInfo() {
        return this.info;
    }

    public final void setInfo(@NotNull TileFactoryInfo tileFactoryInfo) {
        Intrinsics.checkNotNullParameter((Object)tileFactoryInfo, (String)"<set-?>");
        this.info = tileFactoryInfo;
    }

    @Override
    protected void scheduleUpdate() {
        if (this.getNativeComponent().isShowing()) {
            this.getTimer().restart();
            this.getNativeComponent().repaint();
        }
    }

    @Override
    protected void repaint() {
        this.getNativeComponent().repaint();
    }

    private final void updateTileFactory() {
        TileFactoryInfo info = ((ColorTheme)this.getColorTheme().getValue()).isDark() ? (TileFactoryInfo)new CartoDBDarkTileFactoryInfo() : (TileFactoryInfo)new CartoDBLightTileFactoryInfo();
        this.setTileFactory(new SwingTileFactory(info, this){
            final /* synthetic */ SwingCartoPlotView<Row, C, Column> this$0;
            {
                this.this$0 = $receiver;
                super($info);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public BufferedImage createImage(@Nullable byte[] bimg) throws IOException {
                BufferedImage bufferedImage;
                BufferedImage image = super.createImage(bimg);
                if (this.this$0.getTileEffect().getValue() == CartoPlotView.TileEffect.BlackWhite) {
                    if (image != null) {
                        void var3_3;
                        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                        copy.getGraphics().drawImage(image, 0, 0, null);
                        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                        BufferedImage bufferedImage2 = op.filter(copy, copy);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"filter(...)");
                        copy = bufferedImage2;
                        if (((ColorTheme)this.this$0.getColorTheme().getValue()).isDark()) {
                            var7_5 = new float[]{-0.5f, -0.5f, -0.5f, 1.0f};
                            float[] fArray = var7_5;
                            var7_5 = new float[]{127.0f, 127.0f, 127.0f, 0.0f};
                            rescaleOp = new RescaleOp(fArray, var7_5, null);
                            var5_7 = rescaleOp.filter(copy, copy);
                            Intrinsics.checkNotNull((Object)var5_7);
                            v2 = var5_7;
                        } else {
                            var7_5 = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
                            float[] fArray = var7_5;
                            var7_5 = new float[]{127.0f, 127.0f, 127.0f, 0.0f};
                            rescaleOp = new RescaleOp(fArray, var7_5, null);
                            var5_7 = rescaleOp.filter(copy, copy);
                            Intrinsics.checkNotNull((Object)var5_7);
                            v2 = copy = var5_7;
                        }
                        if (!((ColorTheme)this.this$0.getColorTheme().getValue()).isDark()) {
                            // empty if block
                        }
                        bufferedImage = var3_3;
                    } else {
                        bufferedImage = null;
                    }
                } else {
                    bufferedImage = image;
                }
                return bufferedImage;
            }

            private final BufferedImage invert(BufferedImage copy) {
                BufferedImage copy2 = copy;
                short[] red = new short[256];
                short[] green = new short[256];
                short[] blue = new short[256];
                short[] alpha = new short[256];
                for (int i = 0; i < 256; ++i) {
                    red[i] = (short)(255 - i);
                    blue[i] = red[i];
                    green[i] = blue[i];
                    alpha[i] = (short)i;
                }
                short[][] sArrayArray = new short[][]{red, green, blue, alpha};
                short[][] data = sArrayArray;
                LookupTable lookupTable = new ShortLookupTable(0, data);
                LookupOp lookupOp = new LookupOp(lookupTable, null);
                BufferedImage bufferedImage = lookupOp.filter(copy2, copy2);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"filter(...)");
                copy2 = bufferedImage;
                return copy2;
            }
        });
    }

    @Override
    protected void populateOverplots() {
        this.getCanvas().addLayer((IDrawing)new SwingMapIDrawing());
        super.populateOverplots();
    }

    @Override
    public void setLicenseModel(@Nullable LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            this.getNativeComponent().removeComponentListener(this.unregisteredPanelListener);
            this.getNativeComponent().remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect((EnhancedLabel.Effect)EnhancedLabel.Effect.Outline.INSTANCE);
            Object object = licenseModel;
            if (object == null || (object = object.verify()) == null || (object = object.toString()) == null) {
                object = "Unregistered version";
            }
            Object message = object;
            unregisteredLabel.setText((String)message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            JPanel jPanel = this.unregisteredPanel = (JPanel)new JPanel(){

                public void paint(@NotNull Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            Intrinsics.checkNotNull((Object)jPanel, (String)"null cannot be cast to non-null type javax.swing.JPanel");
            jPanel.setOpaque(false);
            JPanel jPanel2 = this.unregisteredPanel;
            Intrinsics.checkNotNull((Object)jPanel2, (String)"null cannot be cast to non-null type javax.swing.JPanel");
            jPanel2.setLayout(new OverlayLayout(this.unregisteredPanel));
            JPanel jPanel3 = this.unregisteredPanel;
            Intrinsics.checkNotNull((Object)jPanel3, (String)"null cannot be cast to non-null type javax.swing.JPanel");
            jPanel3.add((Component)unregisteredLabel);
            Font font = unregisteredLabel.getFont();
            unregisteredLabel.setFont(font != null ? font.deriveFont(1, 32.0f) : null);
            JComponent jComponent = this.getNativeComponent();
            Component component = this.unregisteredPanel;
            Integer n = JLayeredPane.MODAL_LAYER;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"MODAL_LAYER");
            jComponent.add(component, ((Number)n).intValue());
            this.unregisteredPanelListener = new ComponentAdapter(this){
                final /* synthetic */ SwingCartoPlotView<Row, C, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(@NotNull ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingHelper.INSTANCE.centerBottom((Container)this.this$0.getNativeComponent(), (Component)SwingCartoPlotView.access$getUnregisteredPanel$p(this.this$0));
                }
            };
            this.getNativeComponent().addComponentListener(this.unregisteredPanelListener);
        }
    }

    private final void refresh() {
        this.getCanvas().refresh();
    }

    @Override
    public void setTileFactory(@Nullable SwingTileFactory tileFactory) {
        if (this.tileFactory != tileFactory) {
            if (this.tileFactory != null) {
                SwingTileFactory swingTileFactory = this.tileFactory;
                Intrinsics.checkNotNull((Object)swingTileFactory);
                swingTileFactory.clearCache();
                SwingTileFactory swingTileFactory2 = this.tileFactory;
                Intrinsics.checkNotNull((Object)swingTileFactory2);
                swingTileFactory2.removeTileListener(this.tileLoadListener);
            }
            this.tileFactory = tileFactory;
            if (tileFactory != null) {
                tileFactory.clearCache();
                tileFactory.addTileListener(this.tileLoadListener);
                tileFactory.setThreadPoolSize(6);
            }
        }
    }

    private static final void _init_$lambda$0(SwingCartoPlotView this$0, HierarchyEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ((e.getChangeFlags() & 4L) != 0L) {
            this$0.refresh();
        }
    }

    public static final /* synthetic */ JPanel access$getUnregisteredPanel$p(SwingCartoPlotView $this) {
        return $this.unregisteredPanel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/cartoplot/swing/SwingCartoPlotView$SwingMapIDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "(Lcom/macrofocus/cartoplot/swing/SwingCartoPlotView;)V", "isActive", "", "()Z", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "cartoplot"})
    private final class SwingMapIDrawing
    extends AbstractIDrawing {
        public boolean isActive() {
            return (Boolean)SwingCartoPlotView.this.getDrawTiles().getValue();
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            if (SwingCartoPlotView.this.tileFactory != null) {
                Graphics2D context = ((SwingIGraphics)g).getContext();
                SwingTileFactory swingTileFactory = SwingCartoPlotView.this.tileFactory;
                Intrinsics.checkNotNull((Object)swingTileFactory);
                int tileSize = swingTileFactory.getInfo().getTileSize();
                Rectangle2D worldBounds = SwingCartoPlotView.this.getScreenTransform().screenToWorld(new Rectangle(0, 0, (int)width, (int)height));
                SwingTileFactory swingTileFactory2 = SwingCartoPlotView.this.tileFactory;
                Intrinsics.checkNotNull((Object)swingTileFactory2);
                int n = swingTileFactory2.getInfo().getMaximumZoomLevel();
                SwingTileFactory swingTileFactory3 = SwingCartoPlotView.this.tileFactory;
                Intrinsics.checkNotNull((Object)swingTileFactory3);
                int zoom = Math.min(n, Math.max(swingTileFactory3.getInfo().getMinimumZoomLevel(), (int)MathKt.roundToLong((double)(Math.log(width * (double)360 / worldBounds.getWidth() / (double)tileSize) / Math.log(2.0)))));
                int startX = com.cartoplot.AbstractCartoPlotView.Companion.getTileX(Math.max(-180.0, worldBounds.getMinX()), zoom) - 1;
                int startY = com.cartoplot.AbstractCartoPlotView.Companion.getTileY(Math.max(-90.0, com.cartoplot.AbstractCartoPlotView.Companion.y2lat(worldBounds.getMinY())), zoom) - 1;
                int endX = com.cartoplot.AbstractCartoPlotView.Companion.getTileX(Math.min(180.0, worldBounds.getMaxX()), zoom) + 1;
                int endY = com.cartoplot.AbstractCartoPlotView.Companion.getTileY(Math.min(90.0, com.cartoplot.AbstractCartoPlotView.Companion.y2lat(worldBounds.getMaxY())), zoom) + 1;
                Object antialias = context.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Object object = antialias;
                if (object == null) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                }
                context.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                context.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                context.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                context.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int x = startX;
                if (x <= endX) {
                    while (true) {
                        int y;
                        if ((y = startY) <= endY) {
                            while (true) {
                                SwingTileFactory swingTileFactory4 = SwingCartoPlotView.this.tileFactory;
                                Intrinsics.checkNotNull((Object)swingTileFactory4);
                                SwingTile tile = swingTileFactory4.getTile(x, y, zoom, (Boolean)SwingCartoPlotView.this.getWrap().getValue());
                                if (tile != null && tile.isLoaded()) {
                                    Rectangle2D bounds = SwingCartoPlotView.this.tile2boundingBox(x, y, zoom);
                                    Rectangle p = SwingCartoPlotView.this.getScreenTransform().worldToScreen(bounds);
                                    BufferedImage image = tile.getImage();
                                    if (image != null) {
                                        context.drawImage(image, p.getIx(), p.getIy(), p.getIx() + p.getIwidth(), p.getIy() + p.getIheight(), 0, 0, image.getWidth(), image.getHeight(), null);
                                    }
                                }
                                if (y == endY) break;
                                ++y;
                            }
                        }
                        if (x == endX) break;
                        ++x;
                    }
                }
                if (((Boolean)SwingCartoPlotView.this.getDrawTileGrid().getValue()).booleanValue()) {
                    Color black = MkColorKt.colorOf((int)0, (int)0, (int)0, (int)40);
                    Color white = MkColorKt.colorOf((int)255, (int)255, (int)255, (int)40);
                    int x2 = startX;
                    if (x2 <= endX) {
                        while (true) {
                            int y;
                            if ((y = startY) <= endY) {
                                while (true) {
                                    Rectangle2D bounds = SwingCartoPlotView.this.tile2boundingBox(x2, y, zoom);
                                    Rectangle p = SwingCartoPlotView.this.getScreenTransform().worldToScreen(bounds);
                                    int ox = p.getIx();
                                    int oy = p.getIy();
                                    g.setColor(black);
                                    g.drawRectange(ox, oy, p.getIwidth(), p.getIheight());
                                    g.setColor(white);
                                    g.drawRectange(ox + 1, oy + 1, p.getIwidth(), p.getIheight());
                                    String text = x2 + ", " + y + ", " + zoom;
                                    context.setColor(black);
                                    context.drawString(text, ox + 10, oy + 20);
                                    context.drawString(text, ox + 10 + 2, oy + 20 + 2);
                                    context.setColor(white);
                                    context.drawString(text, ox + 10 + 1, oy + 20 + 1);
                                    if (y == endY) break;
                                    ++y;
                                }
                            }
                            if (x2 == endX) break;
                            ++x2;
                        }
                    }
                }
            }
        }
    }
}

