/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.tile;

import com.macrofocus.cartoplot.swing.tile.SwingTileFactory;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0012J\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0086\u0002J\u0006\u0010\u0017\u001a\u00020\u0012J\"\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fR\u001c\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/macrofocus/cartoplot/swing/tile/SwingTileCache;", "", "tileFactory", "Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory;", "(Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory;)V", "bytemap", "", "Ljava/net/URI;", "", "bytemapAccessQueue", "Ljava/util/LinkedList;", "bytesize", "", "imagesize", "imgmap", "Ljava/awt/image/BufferedImage;", "imgmapAccessQueue", "addToImageCache", "", "uri", "img", "clear", "get", "needMoreMemory", "put", "bimg", "cartoplot"})
@SourceDebugExtension(value={"SMAP\nSwingTileCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingTileCache.kt\ncom/macrofocus/cartoplot/swing/tile/SwingTileCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class SwingTileCache {
    @NotNull
    private final SwingTileFactory tileFactory;
    @NotNull
    private final Map<URI, BufferedImage> imgmap;
    @NotNull
    private final LinkedList<URI> imgmapAccessQueue;
    private int imagesize;
    @NotNull
    private final Map<URI, byte[]> bytemap;
    @NotNull
    private final LinkedList<URI> bytemapAccessQueue;
    private int bytesize;

    public SwingTileCache(@NotNull SwingTileFactory tileFactory) {
        Intrinsics.checkNotNullParameter((Object)tileFactory, (String)"tileFactory");
        this.tileFactory = tileFactory;
        this.imgmap = new WeakHashMap();
        this.imgmapAccessQueue = new LinkedList();
        this.bytemap = new HashMap();
        this.bytemapAccessQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@Nullable URI uri, @NotNull byte[] bimg, @Nullable BufferedImage img) {
        Intrinsics.checkNotNullParameter((Object)bimg, (String)"bimg");
        Map<URI, byte[]> map = this.bytemap;
        synchronized (map) {
            boolean bl = false;
            while (this.bytesize > 50000000) {
                URI olduri = this.bytemapAccessQueue.removeFirst();
                byte[] oldbimg = this.bytemap.remove(olduri);
                Intrinsics.checkNotNull((Object)oldbimg);
                this.bytesize -= oldbimg.length;
            }
            this.bytemap.put(uri, bimg);
            this.bytesize += bimg.length;
            this.bytemapAccessQueue.addLast(uri);
            Unit unit = Unit.INSTANCE;
        }
        this.addToImageCache(uri, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final BufferedImage get(@Nullable URI uri) throws IOException {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            block8: {
                boolean bl = false;
                if (!this.imgmap.containsKey(uri)) break block8;
                this.imgmapAccessQueue.remove(uri);
                this.imgmapAccessQueue.addLast(uri);
                BufferedImage bufferedImage = this.imgmap.get(uri);
                return bufferedImage;
            }
            Unit unit = Unit.INSTANCE;
        }
        map = this.bytemap;
        synchronized (map) {
            block9: {
                boolean bl = false;
                if (!this.bytemap.containsKey(uri)) break block9;
                this.bytemapAccessQueue.remove(uri);
                this.bytemapAccessQueue.addLast(uri);
                BufferedImage img = this.tileFactory.createImage(this.bytemap.get(uri));
                this.addToImageCache(uri, img);
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            Unit unit = Unit.INSTANCE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void needMoreMemory() {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            boolean bl = false;
            this.imgmap.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            boolean bl = false;
            this.imgmap.clear();
            this.imagesize = 0;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToImageCache(URI uri, BufferedImage img) {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            boolean bl = false;
            try {
                while (this.imagesize > 50000000) {
                    URI olduri = this.imgmapAccessQueue.removeFirst();
                    BufferedImage oldimg = this.imgmap.remove(olduri);
                    if (oldimg == null) continue;
                    this.imagesize -= oldimg.getWidth() * oldimg.getHeight() * 4;
                }
                this.imgmap.put(uri, img);
                BufferedImage bufferedImage = img;
                Intrinsics.checkNotNull((Object)bufferedImage);
                this.imagesize += bufferedImage.getWidth() * img.getHeight() * 4;
                this.imgmapAccessQueue.addLast(uri);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

