/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.tile;

import com.cartoplot.tile.AbstractTileFactory;
import com.cartoplot.tile.TileFactoryInfo;
import com.macrofocus.cartoplot.swing.tile.SwingTile;
import com.macrofocus.cartoplot.swing.tile.SwingTileCache;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 '2\u00020\u0001:\u0002'(B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ&\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory;", "Lcom/cartoplot/tile/AbstractTileFactory;", "info", "Lcom/cartoplot/tile/TileFactoryInfo;", "(Lcom/cartoplot/tile/TileFactoryInfo;)V", "cache", "Lcom/macrofocus/cartoplot/swing/tile/SwingTileCache;", "service", "Ljava/util/concurrent/ExecutorService;", "threadPoolSize", "", "tileMap", "", "", "Lcom/macrofocus/cartoplot/swing/tile/SwingTile;", "clearCache", "", "createImage", "Ljava/awt/image/BufferedImage;", "bimg", "", "createTileRunner", "Ljava/lang/Runnable;", "dispose", "getService", "getTile", "x", "y", "zoom", "wrap", "", "tpx", "tpy", "eagerLoad", "promote", "tile", "setThreadPoolSize", "size", "startLoading", "Companion", "TileRunner", "cartoplot"})
public class SwingTileFactory
extends AbstractTileFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int threadPoolSize;
    @Nullable
    private ExecutorService service;
    @NotNull
    private final Map<String, SwingTile> tileMap;
    @NotNull
    private final SwingTileCache cache;
    @NotNull
    private static final BlockingQueue<SwingTile> tileQueue = new PriorityBlockingQueue(5, SwingTileFactory::tileQueue$lambda$0);

    public SwingTileFactory(@Nullable TileFactoryInfo info) {
        TileFactoryInfo tileFactoryInfo = info;
        Intrinsics.checkNotNull((Object)tileFactoryInfo);
        super(tileFactoryInfo);
        this.threadPoolSize = 4;
        this.tileMap = new HashMap();
        this.cache = new SwingTileCache(this);
    }

    @NotNull
    public final SwingTile getTile(int x, int y, int zoom, boolean wrap) {
        return this.getTile(x, y, zoom, wrap, true);
    }

    private final SwingTile getTile(int tpx, int tpy, int zoom, boolean wrap, boolean eagerLoad) {
        int tileX = tpx;
        if (wrap) {
            int numTilesWide = this.getMapWidth(zoom);
            if (tileX < 0) {
                tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
            }
            tileX %= numTilesWide;
        }
        String url = this.getInfo().getTileUrl(tileX, tpy, zoom);
        SwingTile.Priority pri = SwingTile.Priority.High;
        if (!eagerLoad) {
            pri = SwingTile.Priority.Low;
        }
        SwingTile tile = null;
        if (!this.tileMap.containsKey(url)) {
            if (!this.getInfo().isValidTile(tileX, tpy, zoom)) {
                tile = new SwingTile(tileX, tpy, zoom);
            } else {
                tile = new SwingTile(tileX, tpy, zoom, url, pri, this);
                this.startLoading(tile);
            }
            this.tileMap.put(url, tile);
        } else {
            SwingTile swingTile = tile = this.tileMap.get(url);
            Intrinsics.checkNotNull((Object)swingTile);
            if (swingTile.getPriority() == SwingTile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return tile;
    }

    @Nullable
    public final synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count;

                @NotNull
                public Thread newThread(@NotNull Runnable r) {
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    int n = this.count;
                    this.count = n + 1;
                    Thread t = new Thread(r, "tile-pool-" + n);
                    t.setPriority(1);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    public final void dispose() {
        if (this.service != null) {
            ExecutorService executorService = this.service;
            Intrinsics.checkNotNull((Object)executorService);
            executorService.shutdown();
            this.service = null;
        }
    }

    public final void clearCache() {
        this.cache.clear();
        for (SwingTile tile : this.tileMap.values()) {
            tile.setImage(new SoftReference<Object>(null));
        }
    }

    public final void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public final synchronized void startLoading(@NotNull SwingTile tile) {
        Intrinsics.checkNotNullParameter((Object)tile, (String)"tile");
        if (tile.isLoading()) {
            System.out.println((Object)"already loading. bailing");
            return;
        }
        tile.setLoading(true);
        try {
            tileQueue.put(tile);
            ExecutorService executorService = this.getService();
            Intrinsics.checkNotNull((Object)executorService);
            executorService.submit(this.createTileRunner());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public final Runnable createTileRunner() {
        return new TileRunner();
    }

    public final synchronized void promote(@Nullable SwingTile tile) {
        if (tileQueue.contains(tile)) {
            try {
                tileQueue.remove(tile);
                SwingTile swingTile = tile;
                Intrinsics.checkNotNull((Object)swingTile);
                swingTile.setPriority(SwingTile.Priority.High);
                tileQueue.put(tile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Nullable
    public BufferedImage createImage(@Nullable byte[] bimg) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(bimg));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int tileQueue$lambda$0(SwingTile o1, SwingTile o2) {
        SwingTile swingTile = o1;
        Intrinsics.checkNotNull((Object)swingTile);
        if (swingTile.getPriority() == SwingTile.Priority.Low) {
            SwingTile swingTile2 = o2;
            Intrinsics.checkNotNull((Object)swingTile2);
            if (swingTile2.getPriority() == SwingTile.Priority.High) {
                return 1;
            }
        }
        if (o1.getPriority() != SwingTile.Priority.High) return 0;
        SwingTile swingTile3 = o2;
        Intrinsics.checkNotNull((Object)swingTile3);
        if (swingTile3.getPriority() != SwingTile.Priority.Low) return 0;
        return -1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory$Companion;", "", "()V", "tileQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/macrofocus/cartoplot/swing/tile/SwingTile;", "cartoplot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory$TileRunner;", "Ljava/lang/Runnable;", "(Lcom/macrofocus/cartoplot/swing/tile/SwingTileFactory;)V", "cacheInputStream", "", "url", "Ljava/net/URL;", "getURI", "Ljava/net/URI;", "tile", "Lcom/macrofocus/cartoplot/swing/tile/SwingTile;", "run", "", "cartoplot"})
    private final class TileRunner
    implements Runnable {
        @Nullable
        public final URI getURI(@Nullable SwingTile tile) throws URISyntaxException {
            SwingTile swingTile = tile;
            Intrinsics.checkNotNull((Object)swingTile);
            return swingTile.getURL() == null ? null : new URI(tile.getURL());
        }

        @Override
        public void run() {
            SwingTile tile = (SwingTile)tileQueue.remove();
            int trys = 3;
            while (true) {
                SwingTile swingTile = tile;
                Intrinsics.checkNotNull((Object)swingTile);
                if (swingTile.isLoaded() || trys <= 0) break;
                try {
                    BufferedImage img = null;
                    URI uri = this.getURI(tile);
                    img = SwingTileFactory.this.cache.get(uri);
                    if (img == null) {
                        URI uRI = uri;
                        Intrinsics.checkNotNull((Object)uRI);
                        URL uRL = uRI.toURL();
                        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                        byte[] bimg = this.cacheInputStream(uRL);
                        img = SwingTileFactory.this.createImage(bimg);
                        SwingTileFactory.this.cache.put(uri, bimg, img);
                        img = SwingTileFactory.this.cache.get(uri);
                    }
                    if (img == null) {
                        System.out.println((Object)("error loading: " + uri));
                        System.err.println("Failed to load: " + uri);
                        --trys;
                        continue;
                    }
                    BufferedImage i = img;
                    SwingUtilities.invokeAndWait(() -> TileRunner.run$lambda$0(tile, i, SwingTileFactory.this));
                }
                catch (OutOfMemoryError memErr) {
                    SwingTileFactory.this.cache.needMoreMemory();
                }
                catch (Throwable e) {
                    if (trys == 0) {
                        System.err.println("Failed to load a tile at url: " + tile.getURL() + ", stopping");
                        continue;
                    }
                    System.err.println("Failed to load a tile at url: " + tile.getURL() + ", retrying");
                    e.printStackTrace();
                    --trys;
                }
            }
            tile.setLoading(false);
        }

        private final byte[] cacheInputStream(URL url) throws IOException {
            int n;
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "Macrofocus CartoPlot/1.0rc3");
            InputStream ins = connection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = ins.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            byte[] byArray = bout.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return byArray;
        }

        private static final void run$lambda$0(SwingTile $tile, BufferedImage $i, SwingTileFactory this$0) {
            Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            $tile.setImage(new SoftReference<BufferedImage>($i));
            $tile.setLoaded(true);
            this$0.fireTileLoadedEvent($tile);
        }
    }
}

