/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.barchart

import com.macrofocus.license.LicenseModel
import org.molap.dataframe.DataFrame

abstract class AbstractBarChart<Row, Column>() :
    BarChart<Row, Column> {
    override var model: BarChartModel<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field = value

                // Register it to the current view
                view?.model = value
            }
        }

    override var view: BarChartView<Row, Column>? = null
        set(value) {
            if (field !== value) {
                // Deregister the current view
                field?.model = null
                field = value
                if (value != null) {
                    value.model = model
                    field!!.setLicenseModel(licenseModel)
                }
            }
        }

    override var controller: BarChartController<Row, Column>? = null
        set(value) {
            if (field !== value) {
                field?.view = null
                field = value
                if (value != null) {
                    value.view = view
                }
            }
        }
    /**
     * Loads the specified data frame.
     *
     * @param dataFrame a data frame
     */
    protected fun load(dataFrame: DataFrame<*, *, *>?) {
        model = createModel(dataFrame)
    }

    /**
     * Creates a model that can be used by the parallel coordinates component
     *
     * @param dataFrame a Swing TableModel
     *
     * @return a BarChartModel instance
     */
    protected abstract fun createModel(dataFrame: DataFrame<*,*,*>?): BarChartModel<Row, Column>

    /**
     * Creates a view that can be used by the parallel coordinates component
     *
     * @return a BarChartView instance
     */
    protected abstract fun createView(): BarChartView<Row, Column>?

    /**
     * Creates a controller that can be used by the parallel coordinates component
     *
     * @param view the view that should be controlled
     *
     * @return a BarChartController instance
     */
    protected abstract fun createController(view: BarChartView<Row, Column>?): BarChartController<Row, Column>?

    companion object {
        protected var licenseModel: LicenseModel? = null

        /**
         * Register the license key that legally entitle the use of BarChart. This should be called prior to the first
         * instantiation of this component.
         *
         * @param username the user name
         * @param key      the license key
         */
        fun setLicenseKey(username: String?, key: String?) {
//            licenseModel = SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key)
        }
    }
}