/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.details

import com.macrofocus.common.selection.SingleSelectionEvent
import com.macrofocus.common.selection.SingleSelectionListener
import org.mkui.visual.Visual
import org.molap.dataframe.AbstractDataFrame
import org.molap.dataframe.DataFrame
import org.molap.dataframe.DataFrameEvent
import org.molap.dataframe.DataFrameListener
import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex
import org.molap.series.Series
import kotlin.reflect.KClass

class DetailsDataFrame<R, C, V>(model: DataFrame<R, C, V>, visual: Visual<R, C>) : AbstractDataFrame<C, String?, Any?>() {
    private val model: DataFrame<R, C, V>
    private var current: R? = null
    override fun getRowClass(c: C): KClass<out Any>? {
        return null
    }

    override fun getColumnClass(column: String?): KClass<out Any> {
        return if (column === NAME) {
            String::class
        } else if (column === VALUE) {
            Any::class
        } else {
            Any::class
        }
    }

    override fun getValueAt(row: C, column: String?): Any? {
        return if (column === NAME) {
            model.getColumnName(row)
        } else if (column === VALUE) {
            if (current != null) {
                model.getValueAt(current!!, row)
            } else {
                null
            }
        } else {
            null
        }
    }

    fun getRow(c: C): Series<String, *>? {
        return null
    }

    override val rowIndex: UniqueIndex<C>
        get() = model.columnIndex

    override val columnIndex: UniqueIndex<String?>
        get() = columns

    fun join(series: Series<*,*>?, strings: Array<String?>?): DataFrame<*,*,*>? {
        return null
    }

    protected fun scheduleUpdate() {
        updateImmediatelly()
    }

    protected fun updateImmediatelly() {
        notifyDataFrameChanged(DataFrameEvent<C, String?>(null, null, true))
    }

    companion object {
        private const val NAME = "Variable"
        private const val VALUE = "Value"
        private val columns: UniqueIndex<String?> = DefaultUniqueIndex(NAME, VALUE)
    }

    init {
        this.model = model
        visual.probing.addSingleSelectionListener(object : SingleSelectionListener<R> {
            override fun selectionChanged(event: SingleSelectionEvent<R>) {
                if (event.currentSelection != null) {
                    current = event.currentSelection
                } else {
                    if (visual.selection.isActive && visual.selection.selectedCount === 1) {
                        for (node in visual.selection) {
                            current = node
                        }
                    } else {
                        current = null
                    }
                }
                scheduleUpdate()
            }
        })
        model.addDataFrameListener(object : DataFrameListener<R, C> {
            override fun dataFrameChanged(event: DataFrameEvent<R, C>) {
                scheduleUpdate()
            }
        })
    }
}