/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.distributions

abstract class AbstractDistributionsModel<Row, Column, Value, Bin> :
    DistributionsModel<Row, Column, Value, Bin> {
    private val listeners: MutableList<DistributionsListener> =
        ArrayList<DistributionsListener>()

    /**
     * {@inheritDoc}
     */
    override fun addDistributionsListener(listener: DistributionsListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeDistributionsListener(listener: DistributionsListener) {
        listeners.remove(listener)
    }

    fun firedDistributionsChanged() {
        for (listener in listeners) {
            listener.distributionsChanged()
        }
    }
}