/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.list

abstract class AbstractListContentModel<V> : ListContentModel<V> {
    override fun getObjectIndexStartWith(string: String): Int {
        var index = -1
        for (i in 0 until objectCount) {
            if (getObject(i).toString().toUpperCase().startsWith(string.toUpperCase())) {
                index = i
                break
            }
        }
        return index
    }
}