package com.macrofocus.high_d.parallelcoordinates

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import com.macrofocus.hierarchy.Hierarchy
import com.macrofocus.high_d.axis.AxisListener
import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.high_d.axis.AxisView
import com.macrofocus.high_d.axis.DefaultAxisView
import com.macrofocus.high_d.axis.group.AxisGroupModel
import com.macrofocus.high_d.axis.group.AxisGroupView
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry
import com.macrofocus.high_d.parallelcoordinates.layout.DefaultParallelCoordinatesLayoutEngine
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayoutEngine
import com.macrofocus.license.LicenseModel
import org.mkui.canvas.Rendering
import org.mkui.component.CPComponent
import org.mkui.component.absolute.AbsoluteCPContainer
import org.mkui.component.absolute.Layout
import org.mkui.component.label.CPLabel
import org.mkui.geom.Rectangle2D

class DefaultParallelCoordinatesView<Row,Column> : AbstractParallelCoordinatesView<Row,Column>() {
    override val component: AbsoluteCPContainer = AbsoluteCPContainer(object : Layout {
        override fun layout(container: AbsoluteCPContainer, width: Double, height: Double) {
            runLayout()
        }
    })

    private val axisListener: AxisListener = object : AxisListener {
        override fun axisChanged() {
            refresh()
        }
    }

    fun runLayout() {
        if (model != null && getWidth() > 0 && getHeight() > 0) {
            //        final Runnable runnable = new Runnable() {
            //            @Override
            //            public void run() {
            val axisView: AxisView<Row, Column> = createDummyAxisView()
            layout = layoutEngine.doLayout(axisView.preferredWidth, axisView.beforeTrackGap, axisView.afterTrackGap)

            //                final Dimension containerSize = nativeComponent.getSize();
            if (component.height <= 0 || component.width <= 0) {
                return
            }

            for (l in 0 until layout!!.getLevelCount()) {
                val bounds: Rectangle2D = layout!!.getLevelBounds(l)
                if (bounds != null) {
                    val component: ParallelCoordinatesComponent<Row, Column> = getParallelCoordinatesComponent(l)!!
                    component.clearCache()
                    this.component.setBounds(
                        component,
                        Rectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height)
                    )
                    component.scheduleUpdate()
                }
            }

            for (axisGroup in model!!.getAxisHierarchy().axisGroupHierarchy.breadthFirstIterator()) {
                doLayout(model!!.getAxisHierarchy().axisGroupHierarchy, axisGroup)
            }

            //                nativeComponent.revalidate();
            //            }
            //        };
            //        if (SwingUtilities.isEventDispatchThread()) {
            //            runnable.run();
            //        } else {
            //            try {
            //                SwingUtilities.invokeAndWait(runnable);
            //            } catch (InterruptedException e) {
            //                e.printStackTrace();
            //            } catch (InvocationTargetException e) {
            //                e.printStackTrace();
            //            }
            //        }
        }
    }

    protected fun createDummyAxisView(): AxisView<Row, Column> {
        return DefaultAxisView()
    }

    private fun doLayout(hierarchy: Hierarchy<AxisGroupModel<Row, Column>>, axisGroup: AxisGroupModel<Row, Column>) {
        val axisGroupView: AxisGroupView? = getAxisGroupView(axisGroup)
        if (axisGroupView != null) {
            val rect = layout!!.getHeaderBounds(axisGroup)
            this.component.setBounds(
                axisGroupView,
                Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height)
            )
        }

        for (axisModel in axisGroup.axisOrder!!) {
            val axisView: AxisView<Row, Column> = getAndInstallAxisView(axisModel)
            val label: CPComponent = getLabel(axisModel)
            //            switch (getAlignment().getValue()) {
//                case Left:
//                    label.setHorizontalAlignment(JLabel.LEADING);
//                    break;
//                case Center:
//                    label.setHorizontalAlignment(JLabel.CENTER);
//                    break;
//                case Fill:
//                    label.setHorizontalAlignment(JLabel.CENTER);
//                    break;
//                case Right:
//                    label.setHorizontalAlignment(JLabel.TRAILING);
//                    break;
//            }
//
            val headerBounds = layout!!.getHeaderBounds(axisGroup, axisModel)!!
            this.component.setBounds(
                label,
                Rectangle2D.Double(
                    headerBounds.x,
                    headerBounds.y,
                    headerBounds.width,
                    headerBounds.height
                )
            )

            if(axisView.model != null) {
                val aBounds = layout!!.getSliderBounds(axisGroup, axisView.model!!)!!
                this.component.setBounds(
                    axisView,
                    Rectangle2D.Double(
                        aBounds.x,
                        aBounds.y,
                        aBounds.width,
                        aBounds.height
                    )
                )
            }
            //
//            Rectangle2D axisBounds = layout.getBounds(axisGroup, axisView.getModel());
//            double x = aBounds.getX() + axisView.getWidth();
//            double width = Math.min(headerBounds.getMaxX() - x, axisBounds.getMaxX() - x);
//            getMaximumLabel(axisModel).setBounds((int) x, (int) aBounds.getY(), (int) width, axisView.getBeforeTrackGap());
//            getMinimumLabel(axisModel).setBounds((int) x, (int) aBounds.getY() + (int) aBounds.getHeight() - axisView.getAfterTrackGap(), (int) width, axisView.getBeforeTrackGap());
        }

        for (child in hierarchy.getChildren(axisGroup)!!) {
            doLayout(hierarchy, child)
        }
    }

    fun getLabel(axisModel: AxisModel<Row, Column>): CPComponent {
        val label: CPComponent = getParallelPanel(axisModel).getLabel()!!
//        if (label.getNativeComponent().getParent() == null) {
            component.addComponent(label, PALETTE_LAYER)
//        }
        return label
    }

    fun getAndInstallAxisView(axisModel: AxisModel<Row, Column>): AxisView<Row, Column> {
        val axisView: AxisView<Row, Column> = getParallelPanel(axisModel).getAxisView()!!
//        if (axisView.getNativeComponent().getParent() == null) {
//            final Runnable runnable = new Runnable() {
//                @Override
//                public void run() {
            component.addComponent(axisView, PALETTE_LAYER)
            //                }
//            };
//            if (SwingUtilities.isEventDispatchThread()) {
//                runnable.run();
//            } else {
//                try {
//                    SwingUtilities.invokeAndWait(runnable);
//                } catch (InterruptedException e) {
//                    e.printStackTrace();
//                } catch (InvocationTargetException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
        return axisView
    }

    //    private double computeNormalizedLocation(AxisView axisView) {
    //        AxisGroupModel axisGroup = model.getAxisHierarchy().getAxisGroup(axisView.getModel());
    //        Rectangle2D rect = layout.getBounds(axisGroup);
    //        Alignment alignment = getAlignment().getValue();
    //        return Math.min(alignment.getMaximumPosition(axisGroup) + 0.05, Math.max(alignment.getMinimumPosition(axisGroup) - 0.05, ((axisView.getX() + (axisView.getWidth() / 2)) - rect.getX()) / (double) rect.getWidth()));
    //    }
    //    JPopupMenu getPopupMenu() {
    //        return new ParallelCoordinatesPopupMenu(model, this);
    //    }
    fun getParallelPanel(axisModel: AxisModel<Row, Column>): DefaultAxisComponents<Row, Column> {
        if (!axisComponents.containsKey(axisModel)) {
//                val doRun: java.lang.Runnable = object : java.lang.Runnable() {
//                    override fun run() {
                        axisModel.addAxisListener(axisListener)

                        val label: CPComponent? = createAxisHeaderView(axisModel)

                        val panel: DefaultAxisComponents<Row, Column> = DefaultAxisComponents(label)
                        val axisView: AxisView<Row, Column> = createAxisView(axisModel)

                        //                        axisView.setInheritsPopupMenu(true);

//                        final MouseListener mouseListener = createAxisMouseListener(label);
//                        if (mouseListener != null) {
//                            label.addMouseListener(mouseListener);
//                            axisView.addMouseListener(mouseListener);
//                        }
                        panel.setAxisView(axisView)

                        //                        createAxisController(label, axisView);
                        axisComponents[axisModel] = panel
                    }
//                }
                //                if(!SwingUtilities.isEventDispatchThread()) {
//                    try {
//                        SwingUtilities.invokeAndWait(doRun);
//                    } catch (InterruptedException e) {
//                        e.printStackTrace();
//                    } catch (InvocationTargetException e) {
//                        e.printStackTrace();
//                    }
//                } else {
//                doRun.run()
//        }
        return axisComponents[axisModel]!!
    }

    protected fun createAxisHeaderView(axisModel: AxisModel<Row, Column>): CPComponent? {
//        final AxisHeaderView label = new AxisHeaderView(axisModel);
//        label.addMouseListener(new MouseAdapter() {
//            @Override
//            public void mouseClicked(MouseEvent e) {
//                if (e.getClickCount() == 2) {
//                    final double start = axisModel.getInterval().getStart();
//                    final double end = axisModel.getInterval().getEnd();
//                    final double max = axisModel.getMaximum();
//                    final double min = axisModel.getMinimum();
//                    axisModel.setMinMax(max, min);
//                    axisModel.getInterval().setStart(end);
//                    axisModel.getInterval().setEnd(start);
//                }
//            }
//
//            @Override
//            public void mouseExited(MouseEvent e) {
//                nativeComponent.requestFocusInWindow(true);
//            }
//        });
//        label.setModel(axisModel.getButtonModel());

//        val button: Button = Button(axisModel.name, object : ClickHandler() {
//            fun onClick(event: ClickEvent?) {
//                val start: Double = axisModel.interval.getStart()
//                val end: Double = axisModel.interval.getEnd()
//                val max = axisModel.maximum
//                val min = axisModel.minimum
//                axisModel.setMinMax(max, min)
//                axisModel.interval.setStart(end)
//                axisModel.interval.setEnd(start)
//            }
//        })
//        button.getElement().setClassName("header")
//        return button

        return CPLabel(SimpleProperty(axisModel.name))
    }

    //    protected PopupAxisController createAxisController(JButton label, AxisView axisView) {
    //        return new PopupAxisController(axisView, label, GWTParallelCoordinatesView.this);
    //    }
    protected fun createAxisView(axisModel: AxisModel<Row,Column>?): AxisView<Row,Column> {
        val axisView: AxisView<Row,Column> = DefaultAxisView(axisModel)
        return axisView
    }

    override var model: ParallelCoordinatesModel<Row, Column>? = null
        get() = field
        set(value) {
            if (field != null) {
                // Todo
//                model!!.removeParallelCoordinateListener(listener)
//                val groupHierarchy = model!!.getAxisHierarchy().axisGroupHierarchy
//                groupHierarchy.removeHierarchyListener(axisGroupHierarchyListener)
//                groupHierarchy.root.axisOrder!!.removeOrderListener(orderListener)
            }

            field = value


            //        Component[] components = nativeComponent.getComponentsInLayer(JLayeredPane.PALETTE_LAYER);
//        for (Component component : components) {
//            nativeComponent.remove(component);
//        }
//
//        components = nativeComponent.getComponentsInLayer(JLayeredPane.POPUP_LAYER);
//        for (Component component : components) {
//            nativeComponent.remove(component);
//        }
//
//        components = nativeComponent.getComponentsInLayer(JLayeredPane.DRAG_LAYER);
//        for (Component component : components) {
//            nativeComponent.remove(component);
//        }
//
//        components = nativeComponent.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
//        for (Component component : components) {
//            nativeComponent.remove(component);
//        }

//        components = getComponents();
//        for (Component component : components) {
//            remove(component);
//        }
            axisComponents.clear()
            for (component in parallelCoordinatesComponents.values) {
                component.model = null
            }
            parallelCoordinatesComponents.clear()

            if (this.model != null) {
                // Todo
//                model!!.addParallelCoordinatesListener(listener)
                val groupHierarchy = model!!.getAxisHierarchy().axisGroupHierarchy
//                groupHierarchy.addHierarchyListener(axisGroupHierarchyListener)
//                groupHierarchy.root.axisOrder!!.addOrderListener(orderListener)

                for (groupModel in groupHierarchy.breadthFirstIterator()) {
                    for (axisModel in groupModel.axisOrder!!) {
                        getParallelPanel(axisModel)
                    }
                }
            }

            refresh()
        }

    //    private Timing timing = new Timing("Paint");
    private val axisComponents: MutableMap<AxisModel<Row, Column>, DefaultAxisComponents<Row, Column>> = HashMap<AxisModel<Row, Column>, DefaultAxisComponents<Row, Column>>()
    private val axisGroupViews: MutableMap<AxisGroupModel<Row, Column>, AxisGroupView> = HashMap<AxisGroupModel<Row, Column>, AxisGroupView>()
    private val parallelCoordinatesComponents: MutableMap<Int, ParallelCoordinatesComponent<Row, Column>> = HashMap<Int, ParallelCoordinatesComponent<Row, Column>>()

    private val draggedAxisView: AxisView<Row, Column>? = null
    private val draggedLocation = 0

    private val isSelectionMode = true

    private val headerMaximumHeight = 24


    //    private LicenseModel licenseModel;
    //    private JPanel unregisteredPanel;
    //    private ComponentAdapter unregisteredPanelListener;
    private val layoutEngine: ParallelCoordinatesLayoutEngine<Row, Column> =
        DefaultParallelCoordinatesLayoutEngine<Row, Column>(
            this
        )
    private var layout: ParallelCoordinatesLayout<Row, Column>? = null

    override fun getClosestRow(x: Int, y: Int): Row? {
        if (layout != null) {
            for (l in 0 until layout!!.getLevelCount()) {
                val component: ParallelCoordinatesComponent<Row, Column> = getParallelCoordinatesComponent(l)!!
                val b: Rectangle2D = this.component.getBounds(component)!!
                if (b.contains(x.toDouble(), y.toDouble())) {
                    return component.getClosestRow(x - b.x.toInt(), y - b.y.toInt())
                }
            }
        }
        return null
    }

    private fun getParallelCoordinatesComponent(level: Int): ParallelCoordinatesComponent<Row, Column>? {
        if (!parallelCoordinatesComponents.containsKey(level)) {
            val parallelCoordinatesComponent: ParallelCoordinatesComponent<Row, Column> = DefaultParallelCoordinatesComponent<Row, Column>(this, level)
            parallelCoordinatesComponent.model = model
            parallelCoordinatesComponents.put(level, parallelCoordinatesComponent)
            component.addComponent(parallelCoordinatesComponent, DEFAULT_LAYER)
        }
        return parallelCoordinatesComponents[level]
    }
    override fun getRows(rect: Rectangle2D?): Collection<Row> {
        TODO("Not yet implemented")
    }

    override fun isSelectionMode(): Boolean {
        TODO("Not yet implemented")
    }

    override fun setSelectionMode(value: Boolean) {
        TODO("Not yet implemented")
    }

    override fun getWidth(): Int {
        return component.width.toInt()
    }

    override fun getHeight(): Int {
        return component.height.toInt()
    }

    override fun isShowTiming(): Boolean {
        TODO("Not yet implemented")
    }

    override fun setShowTiming(showTiming: Boolean) {
        TODO("Not yet implemented")
    }

    override fun getAxisGroupView(axisGroup: AxisGroupModel<Row, Column>?): AxisGroupView? {
        return axisGroupViews?.get(axisGroup)
    }

    override fun getAxisView(axisModel: AxisModel<*, *>?): AxisView<Row, Column>? {
        TODO("Not yet implemented")
    }

    override fun setLicenseModel(licenseModel: LicenseModel?) {
        TODO("Not yet implemented")
    }

    override fun waitUntilReady() {
        TODO("Not yet implemented")
    }

    override fun getHeaderAxisGroupMaximumHeight(): Int {
        TODO("Not yet implemented")
    }

    override fun getHeaderAxisMaximumHeight(): Int {
        return headerMaximumHeight
    }

    override fun getParallelCoordinatesLayout(): ParallelCoordinatesLayout<Row, Column> {
        return layout!!
    }

    override fun getAxisX(axisGroup: AxisGroupModel<Row, Column>, axisModel: AxisModel<Row, Column>): Int {
        return layout!!.getTrackBounds(axisGroup, axisModel).x.toInt()
    }

    override fun setShowFiltered(showFiltered: MutableProperty<Boolean>?) {
        TODO("Not yet implemented")
    }

    override fun setRendering(rendering: MutableProperty<Rendering>?) {
        TODO("Not yet implemented")
    }

    override fun setAntialiasing(antialiasing: MutableProperty<Boolean>?) {
        TODO("Not yet implemented")
    }

    override fun setGeometry(geometry: MutableProperty<Geometry>) {
        TODO("Not yet implemented")
    }

    private fun repaint() {
    }

    private fun refresh() {
        // ToDo: Optimize
        //        if(isShowing()) {
        runLayout()

        for (parallelCoordinatesComponent in parallelCoordinatesComponents.values) {
            parallelCoordinatesComponent.clearCache()
            parallelCoordinatesComponent.scheduleUpdate()
        }

        repaint()
//        }
    }

    private fun reset() {
        if (model != null) {
            // ToDo: Optimize
            //        if(isShowing()) {
            runLayout()

            for (parallelCoordinatesComponent in parallelCoordinatesComponents.values) {
                parallelCoordinatesComponent.reset()
                parallelCoordinatesComponent.scheduleUpdate()
            }

            repaint()
            //        }
        }
    }
}