/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinates

import org.mkui.component.CPComponent

interface ParallelCoordinates<Row, Column> : CPComponent {
    /**
     * Returns the model used by the parallel coordinates component.
     *
     * @return the model in use
     */
    var model: ParallelCoordinatesModel<Row, Column>?

    /**
     * Returns the view used by the parallel coordinates component.
     *
     * @return the view in use
     */
    var view: ParallelCoordinatesView<Row, Column>?

    /**
     * Returns the controller used by the parallel coordinates component.
     *
     * @return the controller in use
     */
    var controller: ParallelCoordinatesController<Row, Column>?
}