/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinates

import com.macrofocus.common.properties.MutableProperty
import org.mkui.interaction.InteractionMode

/**
 * Control the user interactions with the view.
 */
interface ParallelCoordinatesController<Row, Column> {
    fun getMode(): InteractionMode
    fun setMode(mode: InteractionMode)
    fun setLocksmith(locksmith: Any)

    /**
     * Replace the view currently under control.
     *
     * @param view the ParallelCoordinatesView to use
     */
    var view: ParallelCoordinatesView<Row, Column>?

    var reordering: MutableProperty<Boolean>
    var reversing : MutableProperty<Boolean>

    companion object {
        const val PROPERTY_REORDERING = "reordering"
        const val PROPERTY_REVERSING = "reversing"
    }
}