/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinates.layout

import com.macrofocus.high_d.axis.AxisModel
import com.macrofocus.high_d.axis.group.AxisGroupModel
import org.mkui.geom.Rectangle2D

interface ParallelCoordinatesLayout<Row, Column> {
    fun getAxisPreferredWidth(): Int
    fun getAxisBeforeTrackGap(): Int
    fun getAxisAfterTrackGap(): Int
    fun getBounds(axisGroup: AxisGroupModel<Row, Column>): Rectangle2D
    fun getBounds(axisGroup: AxisGroupModel<Row, Column>, axisModel: AxisModel<Row, Column>): Rectangle2D
    fun getHeaderBounds(axisGroup: AxisGroupModel<Row, Column>): Rectangle2D
    fun getHeaderBounds(axisGroup: AxisGroupModel<Row, Column>, axisModel: AxisModel<Row, Column>): Rectangle2D?
    fun getSliderBounds(axisGroup: AxisGroupModel<Row, Column>, axisModel: AxisModel<Row, Column>): Rectangle2D?
    fun getTrackBounds(axisGroup: AxisGroupModel<Row, Column>, axisModel: AxisModel<Row, Column>): Rectangle2D
    fun getLevelBounds(level: Int): Rectangle2D
    fun getLevelCount(): Int
    fun getAxisGroups(level: Int): Iterable<AxisGroupModel<Row, Column>>
}