/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.scatterplot

import com.macrofocus.license.LicenseModel
import org.molap.dataframe.DataFrame

abstract class AbstractScatterPlot<Row, Column> : ScatterPlot<Row, Column> {
    override open var model: ScatterPlotModel<Row, Column>? = null
    override open var view: ScatterPlotView<Row, Column>? = null
    override open var controller: ScatterPlotController<Row, Column>? = null

    /**
     * Loads the specified data frame.
     *
     * @param dataFrame a data frame
     */
    protected fun load(dataFrame: DataFrame<*, *, *>?) {
        model = createModel(dataFrame)
    }

    /**
     * Creates a model that can be used by the parallel coordinates component
     *
     * @param dataFrame a Swing TableModel
     *
     * @return a ScatterPlotModel instance
     */
    protected abstract fun createModel(dataFrame: DataFrame<*,*,*>?): ScatterPlotModel<Row, Column>

    /**
     * Creates a view that can be used by the parallel coordinates component
     *
     * @return a ScatterPlotView instance
     */
    protected abstract fun createView(): ScatterPlotView<Row, Column>?

    /**
     * Creates a controller that can be used by the parallel coordinates component
     *
     * @param view the view that should be controlled
     *
     * @return a ScatterPlotController instance
     */
    protected abstract fun createController(view: ScatterPlotView<*, *>?): ScatterPlotController<*, *>?

    companion object {
        protected var licenseModel: LicenseModel? = null

        /**
         * Register the license key that legally entitle the use of ScatterPlot. This should be called prior to the first
         * instantiation of this component.
         *
         * @param username the user name
         * @param key      the license key
         */
        @kotlin.jvm.JvmStatic
        fun setLicenseKey(username: String?, key: String?) {
//            licenseModel = SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key)
        }
    }
}