package com.macrofocus.high_d.scatterplot

import com.macrofocus.common.interval.MutableBoundedInterval
import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.license.LicenseModel
import com.macrofocus.plot.guide.Guide
import org.mkui.canvas.*
import org.mkui.color.MkColor
import org.mkui.component.CPComponent
import org.mkui.geom.Rectangle2D
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.rubberband.RubberBand
import org.mkui.transform.MutableTwoDScreenTransform

interface ScatterPlotView<Row, Column> : CPComponent {
    enum class PropertyType {
        ShowFiltered, ShowGrid, Antialiasing, Rendering, GridThickness, ShowColor, Regression, MarkerSize, ColorTheme, DisplayLabels, SizeProportion
    }

    val xGuide: Guide?
    val yGuide: Guide?
    fun setShowFiltered(showFiltered: MutableProperty<Boolean>?)
    fun setRendering(rendering: MutableProperty<Rendering>?)
    fun setAntialiasing(antialiasing: MutableProperty<Boolean>?)
    fun getClosestRow(x: Int, y: Int): Row?

    /**
     * Returns the nodes overlapping the specified rectangle.
     *
     * @param rect the rectangle in screen coordinates
     *
     * @return the list of nodes
     */
    fun getRows(rect: Rectangle2D): List<Row>
    fun getRubberBand(): RubberBand
    fun isSelectionMode(): Boolean
    fun setSelectionMode(value: Boolean)

    /**
     * Returns whether information about refresh rate should be displayed.
     *
     * @return true to display refresh rate information, false otherwise
     */
    fun isShowTiming(): Boolean

    /**
     * Sets whether information about refresh rate should be displayed.
     *
     * @param showTiming true to display refresh rate information, false otherwise
     */
    fun setShowTiming(showTiming: Boolean)
    fun setLicenseModel(licenseModel: LicenseModel?)

    /**
     * Returns the ScatterPlotModel that provides the data displayed by this ScatterPlotView.
     *
     * @return the ScatterPlotModel that provides the data displayed by this ScatterPlotView
     *
     * @see .setModel
     */
    var model: ScatterPlotModel<Row, Column>?

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>?)
    fun getXRangeModel(): MutableBoundedInterval
    fun getYRangeModel(): MutableBoundedInterval
    val screenTransform: MutableTwoDScreenTransform
    fun zoom(animate: Boolean, x1: Double, x2: Double, y1: Double, y2: Double)
    fun getShowFiltered(): MutableProperty<Boolean>
    fun getShowGrid(): MutableProperty<Boolean>
    fun getAntialiasing(): MutableProperty<Boolean>
    fun getRendering(): MutableProperty<Rendering>
    fun getGridThickness(): MutableProperty<Float?>
    fun getShowColor(): MutableProperty<MkColor?>
    fun getRegression(): MutableProperty<Boolean>
    fun getMarkerSize(): MutableProperty<Double?>
    fun getDisplayLabels(): MutableProperty<Boolean>
    fun getSizeProportion(): MutableProperty<SizeProportion>
    val properties: MutableProperties<*>?
    fun setMaintainAspectRatio(maintainAspectRatio: Boolean)
    fun isMaintainAspectRatio(): Boolean
    fun addMouseListener(l: MouseListener)
    fun addMouseMotionListener(l: MouseMotionListener)
    fun addMouseWheelListener(l: MouseWheelListener)
    fun addKeyListener(listener: KeyListener)
}