/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.scatterplotmatrix

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.license.LicenseModel
import org.mkui.canvas.Rendering
import org.mkui.component.CPInteractiveComponent
import org.mkui.geom.Rectangle2D
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.rubberband.RubberBand

interface ScatterPlotMatrixView<Row, Column> : CPInteractiveComponent {
    enum class PropertyType {
        ShowTiming, ShowFiltered, Rendering, ColorTheme, Antialiasing
    }

    fun getClosestRow(x: Int, y: Int): Row?
    fun getRows(rect: Rectangle2D?): List<Row>
    fun isSelectionMode(): Boolean
    fun getWidth(): Int
    fun getHeight(): Int
    fun setSelectionMode(value: Boolean)
    fun setLicenseModel(licenseModel: LicenseModel?)
    //    /**
    //     * {@inheritDoc}
    //     */
    //    @Override
    //    public void paint(final Graphics g) {
    //        timing.start();
    //
    //        // Avoid IllegalArgumentException: null incompatible with Text-specific antialiasing enable key in
    //        // org.apache.batik.ext.awt.g2d.AbstractGraphics2D.setRenderingHint(AbstractGraphics2D.java:1071)
    //        // de.javasoft.plaf.synthetica.GraphicsUtils.paintText(GraphicsUtils.java:194)
    //        Graphics2D g2 = (Graphics2D)g;
    //        final Object antialias = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
    //        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null? antialias: RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    //
    //        super.paint(g);
    //
    //        timing.end();
    //
    //        if (isShowTiming()) {
    //            timing.draw(g2, getSize(), 10);
    //        }
    //    }

    /**
     * Returns the ScatterPlotModel that provides the data displayed by this ScatterPlotView.
     *
     * @return the ScatterPlotModel that provides the data displayed by this ScatterPlotView
     *
     * @see .setModel
     */
    var model: ScatterPlotMatrixModel<Row,Column>?

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>)
    fun getShowTiming(): MutableProperty<Boolean>
    fun getShowFiltered(): MutableProperty<Boolean>
    fun setShowFiltered(showFiltered: MutableProperty<Boolean>)
    fun getRendering(): MutableProperty<Rendering>
    fun setRendering(rendering: MutableProperty<Rendering>)
    fun getAntialiasing(): MutableProperty<Boolean>
    fun setAntialiasing(antialiasing: MutableProperty<Boolean>)
    fun getRubberBand(): RubberBand
}