/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.som

import com.macrofocus.high_d.axis.group.AxisGroupModel
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

interface SOMModel<Row, Column> {
    val visual: Visual<Row, Column>?
    val axisGroupModel: AxisGroupModel<*,*>?
    val dataFrame: DataFrame<*, *, *>?

    /**
     * Add a listener for receiving interesting events about changes in the model.
     *
     * @param listener the listener to add.
     */
    fun addSOMListener(listener: SOMListener)

    /**
     * Remove a listener from the list of listeners that should be notified about changes in the model.
     *
     * @param listener the listener to remove.
     */
    fun removeSOMListener(listener: SOMListener)
}