/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.som

import com.macrofocus.license.LicenseModel

interface SOMView<Row, Column> {
    fun setLicenseModel(licenseModel: LicenseModel?)
    /**
     * Returns the ScatterPlotModel that provides the data displayed by this ScatterPlotView.
     *
     * @return the ScatterPlotModel that provides the data displayed by this ScatterPlotView
     *
     * @see .setModel
     */
    /**
     * Sets the data model and registers with it for listener notifications from the new data model.
     *
     * @param model the new data model
     *
     * @see .getModel
     */
    var model: SOMModel<Row, Column>?
}