/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.table

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener
import org.molap.dataframe.DataFrame
import org.molap.dataframe.ReMappedDataFrame

class ShowFilteredDataFrame<R, C, V>(filteredDataFrame: DataFrame<R, C, V>, completeDataFrame: DataFrame<R, C, V>, showFiltered: MutableProperty<Boolean>) :
    ReMappedDataFrame<R, C, V>(if(showFiltered.value) completeDataFrame else filteredDataFrame, null) {
    private var showFiltered: MutableProperty<Boolean>? = null
    private val filteredDataFrame: DataFrame<R, C, V>
    private val completeDataFrame: DataFrame<R, C, V>
    val propertyListener: PropertyListener<Boolean> = object : PropertyListener<Boolean> {
        override fun propertyChanged(event: PropertyEvent<Boolean>) {
            updateDataset()
        }
    }

    fun setShowFiltered(showFiltered: MutableProperty<Boolean>) {
        if (this.showFiltered != null) {
            this.showFiltered!!.removePropertyListener(propertyListener)
        }
        this.showFiltered = showFiltered
        showFiltered.addPropertyListener(propertyListener)
        updateDataset()
    }

    private fun updateDataset() {
        setDataFrame(if (showFiltered!!.value) completeDataFrame else filteredDataFrame)
    }

    fun getShowFiltered(): MutableProperty<Boolean>? {
        return showFiltered
    }

    fun getFilteredDataFrame(): DataFrame<R, C, V> {
        return filteredDataFrame
    }

    fun getCompleteDataFrame(): DataFrame<R, C, V> {
        return completeDataFrame
    }

    init {
        this.filteredDataFrame = filteredDataFrame
        this.completeDataFrame = completeDataFrame
        setShowFiltered(showFiltered)
    }
}