/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.tablelens

import org.mkui.component.CPComponentProvider
import org.mkui.component.CPInteractiveComponentProvider
import org.mkui.geom.Rectangle2D

interface TableLensComponent<Row, Column> : CPInteractiveComponentProvider {
    fun scheduleUpdate()
    var model: TableLensModel<Row, Column>?
    fun createOverplots()
    fun getClosestRow(x: Int, y: Int): Row?

    /**
     * Returns the nodes overlapping the specified rectangle.
     *
     * @param rect the rectangle in screen coordinates
     *
     * @return the list of nodes
     */
    fun getRows(rect: Rectangle2D): List<Row>
}