/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.high_d.scatterplot.ScatterPlotController;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.KeyEvent;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseEvent;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelEvent;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0003\u001e\u001f B\u001b\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00120\u000eR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R@\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00052\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0006\u00a8\u0006!"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController;", "Row", "Column", "Lcom/macrofocus/high_d/scatterplot/ScatterPlotController;", "view", "Lcom/macrofocus/high_d/scatterplot/ScatterPlotView;", "(Lcom/macrofocus/high_d/scatterplot/ScatterPlotView;)V", "improvedBorderZooming", "", "keyListener", "Lorg/mkui/canvas/KeyListener;", "mode", "Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController$Mode;", "mouseListener", "Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController$DefaultMouseListener;", "multipleSelectionEnabled", "selectOnPopupTrigger", "value", "getView", "()Lcom/macrofocus/high_d/scatterplot/ScatterPlotView;", "setView", "getViewport", "Lorg/mkui/geom/Rectangle2D;", "getWorld", "zoom", "", "amount", "", "xCenter", "yCenter", "DefaultMouseListener", "Mode", "Range", "highd"})
@StabilityInferred(parameters=0)
public abstract class AbstractScatterPlotController<Row, Column>
implements ScatterPlotController<Row, Column> {
    @Nullable
    private ScatterPlotView<Row, Column> view;
    @NotNull
    private Mode mode = Mode.Selection;
    private final boolean multipleSelectionEnabled;
    private final boolean selectOnPopupTrigger;
    private final boolean improvedBorderZooming;
    @NotNull
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();
    @NotNull
    private final KeyListener keyListener = new KeyListener(this){
        @Nullable
        private Mode oldMode;
        final /* synthetic */ AbstractScatterPlotController<Row, Column> this$0;
        {
            this.this$0 = $receiver;
        }

        @Nullable
        public final Mode getOldMode() {
            return this.oldMode;
        }

        public final void setOldMode(@Nullable Mode mode) {
            this.oldMode = mode;
        }

        public void keyTyped(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void keyPressed(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getKeyCode() == 83) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractScatterPlotController.access$getMode$p(this.this$0);
                }
                AbstractScatterPlotController.access$setMode$p(this.this$0, Mode.Selection);
            }
            if (event.getKeyCode() == 90 || event.getKeyCode() == 16) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractScatterPlotController.access$getMode$p(this.this$0);
                }
                AbstractScatterPlotController.access$setMode$p(this.this$0, Mode.Zooming);
            }
            if (event.getKeyCode() == 80 || event.getKeyCode() == 32) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractScatterPlotController.access$getMode$p(this.this$0);
                }
                AbstractScatterPlotController.access$setMode$p(this.this$0, Mode.Panning);
            }
        }

        public void keyReleased(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.oldMode != null) {
                Mode mode = this.oldMode;
                Intrinsics.checkNotNull((Object)((Object)mode));
                AbstractScatterPlotController.access$setMode$p(this.this$0, mode);
                this.oldMode = null;
            }
        }
    };
    public static final int $stable = 8;

    public AbstractScatterPlotController(@Nullable ScatterPlotView<Row, Column> view) {
        this.multipleSelectionEnabled = true;
        this.setView(view);
    }

    @Override
    @Nullable
    public ScatterPlotView<Row, Column> getView() {
        return this.view;
    }

    @Override
    public void setView(@Nullable ScatterPlotView<Row, Column> value) {
        if (this.view != null) {
            // empty if block
        }
        this.view = value;
        if (value != null) {
            value.addKeyListener(this.keyListener);
            value.addMouseListener(this.mouseListener);
            value.addMouseMotionListener(this.mouseListener);
            value.addMouseWheelListener(this.mouseListener);
        }
    }

    private final void zoom(double amount, double xCenter, double yCenter) {
        Rectangle2D viewport = this.getViewport();
        Rectangle2D world = this.getWorld();
        Double d = xCenter;
        double d2 = viewport.getMinX();
        double d3 = viewport.getWidth();
        double d4 = world.getMinX();
        double d5 = world.getMaxX();
        ScatterPlotView<Row, Column> scatterPlotView = this.getView();
        Intrinsics.checkNotNull(scatterPlotView);
        Range xRange = new Range(amount, d, d2, d3, d4, d5, scatterPlotView.getXRangeModel().getMaximumExtent()).invoke();
        double xMin = xRange.getMin();
        double xMax = xRange.getMax();
        Double d6 = yCenter;
        double d7 = viewport.getMinY();
        double d8 = viewport.getHeight();
        double d9 = world.getMinY();
        double d10 = world.getMaxY();
        ScatterPlotView<Row, Column> scatterPlotView2 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView2);
        Range yRange = new Range(amount, d6, d7, d8, d9, d10, scatterPlotView2.getYRangeModel().getMaximumExtent()).invoke();
        double yMin = yRange.getMin();
        double yMax = yRange.getMax();
        if (xMin < xMax && yMin < yMax) {
            ScatterPlotView<Row, Column> scatterPlotView3 = this.getView();
            Intrinsics.checkNotNull(scatterPlotView3);
            scatterPlotView3.zoom(false, xMin, xMax, yMin, yMax);
        }
    }

    @NotNull
    public final Rectangle2D getViewport() {
        ScatterPlotView<Row, Column> scatterPlotView = this.getView();
        Intrinsics.checkNotNull(scatterPlotView);
        double d = scatterPlotView.getXRangeModel().getStart();
        ScatterPlotView<Row, Column> scatterPlotView2 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView2);
        double d2 = scatterPlotView2.getYRangeModel().getStart();
        ScatterPlotView<Row, Column> scatterPlotView3 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView3);
        double d3 = scatterPlotView3.getXRangeModel().getExtent();
        ScatterPlotView<Row, Column> scatterPlotView4 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView4);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d3, scatterPlotView4.getYRangeModel().getExtent());
    }

    @NotNull
    public final Rectangle2D getWorld() {
        ScatterPlotView<Row, Column> scatterPlotView = this.getView();
        Intrinsics.checkNotNull(scatterPlotView);
        double d = scatterPlotView.getXRangeModel().getMinimum();
        ScatterPlotView<Row, Column> scatterPlotView2 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView2);
        double d2 = scatterPlotView2.getYRangeModel().getMinimum();
        ScatterPlotView<Row, Column> scatterPlotView3 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView3);
        double d3 = scatterPlotView3.getXRangeModel().getMaximum();
        ScatterPlotView<Row, Column> scatterPlotView4 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView4);
        double d4 = d3 - scatterPlotView4.getXRangeModel().getMinimum();
        ScatterPlotView<Row, Column> scatterPlotView5 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView5);
        double d5 = scatterPlotView5.getYRangeModel().getMaximum();
        ScatterPlotView<Row, Column> scatterPlotView6 = this.getView();
        Intrinsics.checkNotNull(scatterPlotView6);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d4, d5 - scatterPlotView6.getYRangeModel().getMinimum());
    }

    public static final /* synthetic */ Mode access$getMode$p(AbstractScatterPlotController $this) {
        return $this.mode;
    }

    public static final /* synthetic */ void access$setMode$p(AbstractScatterPlotController $this, Mode mode) {
        $this.mode = mode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001cH\u0016J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u001e\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController$DefaultMouseListener;", "Lorg/mkui/canvas/MouseListener;", "Lorg/mkui/canvas/MouseMotionListener;", "Lorg/mkui/canvas/MouseWheelListener;", "(Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController;)V", "last", "Lorg/mkui/canvas/MouseEvent;", "pressedPoint", "Lorg/mkui/geom/Point;", "selectOnRelease", "Ljava/lang/Object;", "zoomOnRelease", "zoomingPoint", "addToSelection", "", "observation", "(Ljava/lang/Object;)V", "newSelection", "", "mouseClicked", "event", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "Lorg/mkui/canvas/MouseWheelEvent;", "removeFromSelection", "setSelection", "highd"})
    public final class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Nullable
        private MouseEvent last;
        @Nullable
        private Row selectOnRelease;
        @Nullable
        private Point zoomOnRelease;
        @Nullable
        private final Point zoomingPoint;
        @Nullable
        private Point pressedPoint;

        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mousePressed(@NotNull MouseEvent event) {
            block4: {
                block5: {
                    Object bestrow;
                    block6: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (AbstractScatterPlotController.this.getView() == null) break block4;
                            this.pressedPoint = new Point(event.getX(), event.getY());
                            ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(scatterPlotView);
                            bestrow = scatterPlotView.getClosestRow(event.getX(), event.getY());
                            if (bestrow == null) break block5;
                            if (event.isMultipleSelectionKey()) break block6;
                            ScatterPlotView scatterPlotView2 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(scatterPlotView2);
                            ScatterPlotModel scatterPlotModel = scatterPlotView2.getModel();
                            Intrinsics.checkNotNull(scatterPlotModel);
                            if (!scatterPlotModel.getSelection().isSelected(bestrow)) break block7;
                            ScatterPlotView scatterPlotView3 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(scatterPlotView3);
                            ScatterPlotModel scatterPlotModel2 = scatterPlotView3.getModel();
                            Intrinsics.checkNotNull(scatterPlotModel2);
                            if (scatterPlotModel2.getSelection().getSelectedCount() <= 1) break block4;
                        }
                        ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView);
                        ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel);
                        scatterPlotModel.getSelection().clearSelection();
                        ScatterPlotView scatterPlotView4 = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView4);
                        ScatterPlotModel scatterPlotModel3 = scatterPlotView4.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel3);
                        scatterPlotModel3.getSelection().setSelectedElement(bestrow);
                        ScatterPlotView scatterPlotView5 = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView5);
                        ScatterPlotView scatterPlotView6 = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView6);
                        ScatterPlotModel scatterPlotModel4 = scatterPlotView6.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel4);
                        scatterPlotView5.setSelectionMode(scatterPlotModel4.getSelection().isSelected(bestrow));
                        break block4;
                    }
                    ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView);
                    ScatterPlotView scatterPlotView7 = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView7);
                    ScatterPlotModel scatterPlotModel = scatterPlotView7.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    scatterPlotView.setSelectionMode(!scatterPlotModel.getSelection().isSelected(bestrow));
                    ScatterPlotView scatterPlotView8 = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView8);
                    if (scatterPlotView8.isSelectionMode()) {
                        ScatterPlotView scatterPlotView9 = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView9);
                        ScatterPlotModel scatterPlotModel5 = scatterPlotView9.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel5);
                        scatterPlotModel5.getSelection().setSelectedState(bestrow, true);
                    } else {
                        ScatterPlotView scatterPlotView10 = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView10);
                        ScatterPlotModel scatterPlotModel6 = scatterPlotView10.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel6);
                        scatterPlotModel6.getSelection().setSelectedState(bestrow, false);
                    }
                    break block4;
                }
                ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView);
                ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
                Intrinsics.checkNotNull(scatterPlotModel);
                scatterPlotModel.getSelection().clearSelection();
            }
        }

        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractScatterPlotController.this.getView() != null) {
                if (!event.isPopupTrigger()) {
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                        Intrinsics.checkNotNull(scatterPlotView);
                        ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
                        Intrinsics.checkNotNull(scatterPlotModel);
                        scatterPlotModel.getSelection().clearSelection();
                        if (AbstractScatterPlotController.this.multipleSelectionEnabled) {
                            Object Row = this.selectOnRelease;
                            Intrinsics.checkNotNull(Row);
                            this.addToSelection(Row);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView);
                    scatterPlotView.getRubberBand().stopRubberBand();
                } else if (AbstractScatterPlotController.this.selectOnPopupTrigger) {
                    ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView);
                    Object node = scatterPlotView.getClosestRow(event.getX(), event.getY());
                    this.setSelection(node);
                }
                this.last = null;
            }
        }

        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractScatterPlotController.this.getView() != null) {
                ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView);
                if (scatterPlotView.getModel() != null) {
                    ScatterPlotView scatterPlotView2 = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView2);
                    ScatterPlotModel scatterPlotModel = scatterPlotView2.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    MutableSingleSelection mutableSingleSelection = scatterPlotModel.getProbing();
                    ScatterPlotView scatterPlotView3 = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView3);
                    mutableSingleSelection.setSelected(scatterPlotView3.getClosestRow(event.getX(), event.getY()));
                }
            }
        }

        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractScatterPlotController.this.getView() != null) {
                ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView);
                if (scatterPlotView.getModel() != null) {
                    ScatterPlotView scatterPlotView2 = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(scatterPlotView2);
                    ScatterPlotModel scatterPlotModel = scatterPlotView2.getModel();
                    Intrinsics.checkNotNull(scatterPlotModel);
                    scatterPlotModel.getProbing().clearSelection();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public void mouseDragged(@NotNull MouseEvent event) {
            block20: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (AbstractScatterPlotController.this.getView() == null) break block20;
                    v0 = AbstractScatterPlotController.this.getView();
                    Intrinsics.checkNotNull(v0);
                    if (v0.getModel() == null) break block20;
                    if (this.last == null) break block21;
                    switch (WhenMappings.$EnumSwitchMapping$0[AbstractScatterPlotController.access$getMode$p(AbstractScatterPlotController.this).ordinal()]) {
                        case 1: {
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                v1 = AbstractScatterPlotController.this.getView();
                                Intrinsics.checkNotNull(v1);
                                v2 = v1.getModel();
                                Intrinsics.checkNotNull(v2);
                                v2.getProbing().clearSelection();
                                if (!AbstractScatterPlotController.access$getMultipleSelectionEnabled$p(AbstractScatterPlotController.this)) break;
                                v3 = AbstractScatterPlotController.this.getView();
                                Intrinsics.checkNotNull(v3);
                                if (!v3.getRubberBand().getRubberBand().isActive()) {
                                    v4 = AbstractScatterPlotController.this.getView();
                                    Intrinsics.checkNotNull(v4);
                                    v5 = v4.getRubberBand();
                                    v6 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v6);
                                    v7 = v6.getIx();
                                    v8 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v8);
                                    v5.startRubberBand(v7, v8.getIy());
                                }
                                v9 = AbstractScatterPlotController.this.getView();
                                Intrinsics.checkNotNull(v9);
                                v9.getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                v10 = AbstractScatterPlotController.this.getView();
                                Intrinsics.checkNotNull(v10);
                                rect = v10.getRubberBand().getRubberBandScreen();
                                if (rect == null) break;
                                v11 = AbstractScatterPlotController.this.getView();
                                Intrinsics.checkNotNull(v11);
                                toSelect = v11.getRows(rect);
                                if (event.isMultipleSelectionKey()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    v12 = AbstractScatterPlotController.this.getView();
                                    Intrinsics.checkNotNull(v12);
                                    v13 = v12.getModel();
                                    Intrinsics.checkNotNull(v13);
                                    v13.getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            v14 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v14);
                            observation = v14.getClosestRow(event.getX(), event.getY());
                            v15 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v15);
                            v16 = v15.getModel();
                            Intrinsics.checkNotNull(v16);
                            v16.getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            v17 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v17);
                            v18 = v17.getModel();
                            Intrinsics.checkNotNull(v18);
                            if (v18.getSelection() == null) ** GOTO lbl-1000
                            v19 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v19);
                            v20 = v19.getModel();
                            Intrinsics.checkNotNull(v20);
                            if (v20.getSelection().isSelected(observation)) {
                                v21 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v21 = isAlreadySelected = false;
                            }
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                v22 = AbstractScatterPlotController.this.getView();
                                Intrinsics.checkNotNull(v22);
                                v23 = v22.getModel();
                                Intrinsics.checkNotNull(v23);
                                v23.getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                if (AbstractScatterPlotController.access$getMultipleSelectionEnabled$p(AbstractScatterPlotController.this)) {
                                    v24 = observation;
                                    Intrinsics.checkNotNull(v24);
                                    this.addToSelection(v24);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (AbstractScatterPlotController.access$getMultipleSelectionEnabled$p(AbstractScatterPlotController.this)) {
                                v25 = observation;
                                Intrinsics.checkNotNull(v25);
                                this.addToSelection(v25);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!event.isLeftMouseButton()) break;
                            viewport = AbstractScatterPlotController.this.getViewport();
                            world = AbstractScatterPlotController.this.getWorld();
                            v26 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v26);
                            v27 = v26.getScreenTransform().getX();
                            v28 = this.last;
                            Intrinsics.checkNotNull((Object)v28);
                            x1 = v27.screenToWorld(v28.getX());
                            v29 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v29);
                            x2 = v29.getScreenTransform().getX().screenToWorld(event.getX());
                            worldDiffX = x1 - x2;
                            xMin = viewport.getMinX() + worldDiffX;
                            xMax = viewport.getMaxX() + worldDiffX;
                            v30 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v30);
                            v31 = v30.getScreenTransform().getY();
                            v32 = this.last;
                            Intrinsics.checkNotNull((Object)v32);
                            y1 = v31.screenToWorld(v32.getY());
                            v33 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v33);
                            y2 = v33.getScreenTransform().getY().screenToWorld(event.getY());
                            worldDiffY = y1 - y2;
                            yMin = viewport.getMinY() + worldDiffY;
                            yMax = viewport.getMaxY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            xMin = Math.max(world.getMinX(), xMin);
                            xMax = Math.min(world.getMaxX(), xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            yMin = Math.max(world.getMinY(), yMin);
                            yMax = Math.min(world.getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            v34 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v34);
                            v34.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 3: {
                            if (!event.isMiddleMouseButton()) break;
                            v35 = event.getY();
                            v36 = this.last;
                            Intrinsics.checkNotNull((Object)v36);
                            v37 = v35 - (double)v36.getY() / 100.0;
                            v38 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v38);
                            v39 = v38.getScreenTransform().getX().screenToWorld(event.getX());
                            v40 = AbstractScatterPlotController.this.getView();
                            Intrinsics.checkNotNull(v40);
                            AbstractScatterPlotController.access$zoom(AbstractScatterPlotController.this, v37, v39, v40.getScreenTransform().getY().screenToWorld(event.getY()));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = event;
            }
        }

        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
            Intrinsics.checkNotNull(scatterPlotView);
            Object closest = scatterPlotView.getClosestRow(event.getX(), event.getY());
            ScatterPlotView scatterPlotView2 = AbstractScatterPlotController.this.getView();
            Intrinsics.checkNotNull(scatterPlotView2);
            ScatterPlotModel scatterPlotModel = scatterPlotView2.getModel();
            Intrinsics.checkNotNull(scatterPlotModel);
            scatterPlotModel.getProbing().setSelected(closest);
        }

        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractScatterPlotController.this.getView() != null) {
                double amount = event.getWheelRotation();
                double d = amount / 500.0;
                ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView);
                double d2 = scatterPlotView.getScreenTransform().getX().screenToWorld(event.getX());
                ScatterPlotView scatterPlotView2 = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView2);
                AbstractScatterPlotController.this.zoom(d, d2, scatterPlotView2.getScreenTransform().getY().screenToWorld(event.getY()));
            }
        }

        private final void removeFromSelection(Row observation) {
            ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
            Intrinsics.checkNotNull(scatterPlotView);
            ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
            Intrinsics.checkNotNull(scatterPlotModel);
            scatterPlotModel.getSelection().setSelectedState(observation, false);
        }

        private final void setSelection(Row observation) {
            if (observation != null) {
                ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView);
                ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
                Intrinsics.checkNotNull(scatterPlotModel);
                Object[] objectArray = new Object[]{observation};
                scatterPlotModel.getSelection().setSelectedElements(objectArray);
            } else {
                ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
                Intrinsics.checkNotNull(scatterPlotView);
                ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
                Intrinsics.checkNotNull(scatterPlotModel);
                scatterPlotModel.getSelection().clearSelection();
            }
        }

        private final void addToSelection(Row observation) {
            ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
            Intrinsics.checkNotNull(scatterPlotView);
            ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
            Intrinsics.checkNotNull(scatterPlotModel);
            scatterPlotModel.getSelection().setSelectedState(observation, true);
        }

        private final void addToSelection(List<? extends Row> newSelection) {
            ScatterPlotView scatterPlotView = AbstractScatterPlotController.this.getView();
            Intrinsics.checkNotNull(scatterPlotView);
            ScatterPlotModel scatterPlotModel = scatterPlotView.getModel();
            Intrinsics.checkNotNull(scatterPlotModel);
            scatterPlotModel.getSelection().setSelectedIterableState((Iterable)newSelection, true);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.Selection.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.Panning.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.Zooming.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController$Mode;", "", "(Ljava/lang/String;I)V", "Selection", "Zooming", "Panning", "highd"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Selection = new Mode();
        public static final /* enum */ Mode Zooming = new Mode();
        public static final /* enum */ Mode Panning = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Selection, Mode.Zooming, Mode.Panning};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0019\u0010\u0010\u001a\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController$Range;", "", "_amount", "", "_center", "_start", "_extent", "_minRange", "_maxRange", "_maxExtent", "(Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController;DLjava/lang/Double;DDDDD)V", "Ljava/lang/Double;", "_max", "_min", "getMax", "getMin", "invoke", "Lcom/macrofocus/high_d/scatterplot/AbstractScatterPlotController;", "highd"})
    private final class Range {
        private final double _amount;
        @Nullable
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private final double _maxExtent;
        private double _min;
        private double _max;

        public Range(@Nullable double _amount, Double _center, double _start, double _extent, double _minRange, double _maxRange, double _maxExtent) {
            this._amount = _amount;
            this._center = _center;
            this._start = _start;
            this._extent = _extent;
            this._minRange = _minRange;
            this._maxRange = _maxRange;
            this._maxExtent = _maxExtent;
        }

        public final double getMin() {
            return this._min;
        }

        public final double getMax() {
            return this._max;
        }

        @NotNull
        public final Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            this._min = Math.max(this._minRange, this._min);
            this._max = Math.min(this._maxRange, this._max);
            return this;
        }
    }
}

