/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.barchart

import com.macrofocus.license.LicenseModel

interface BarChartView<Row, Column> {
    fun setLicenseModel(licenseModel: LicenseModel?)

    /**
     * Sets the data model and registers with it for listener notifications from the new data model.
     *
     * @param model the new data model
     *
     * @see .getModel
     */
    var model: BarChartModel<Row, Column>?
}