/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.distributions

import com.macrofocus.common.collection.SimpleImmutableEntry
import org.mkui.canvas.MouseEvent
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener
import org.mkui.interaction.InteractionMode
import org.molap.subset.DistributionDimension
import org.molap.subset.SingleBinningDimension

/**
 * Created by luc on 15/06/16.
 */
open class AbstractDistributionsController<Row, Column, Value, Bin> :
    DistributionsController<Row, Column, Value, Bin> {
    override var view: DistributionsView<Row, Column, Value, Bin>? = null
    set(value) {
        if (field != null) {
            field!!.removeMouseListener(mouseListener)
            field!!.removeMouseMotionListener(mouseListener)
        }
        field = value
        if (value != null) {
            value.addMouseListener(mouseListener)
            value.addMouseMotionListener(mouseListener)
        }
    }
    private val mouseListener: DefaultMouseListener = DefaultMouseListener()

    inner class DefaultMouseListener : MouseListener, MouseMotionListener {
        override fun mouseClicked(event: MouseEvent) {}
        override fun mousePressed(event: MouseEvent) {
//            final Object bestrow = view.getClosestRow(event.getX(), event.getY());
//            if (bestrow != null) {
//                if (!event.isMultipleSelectionKey()) {
//                    if (!view.getModel().getSelection().isSelected(bestrow) ||
//                            view.getModel().getSelection().getSelectedCount() > 1) {
//                        view.getModel().getSelection().clearSelection();
//                        view.getModel().getSelection().setSelected(bestrow);
//                        view.setSelectionMode(view.getModel().getSelection().isSelected(bestrow));
//                    }
//                } else {
//                    view.setSelectionMode(!view.getModel().getSelection().isSelected(bestrow));
//                    if (view.isSelectionMode()) {
//                        view.getModel().getSelection().setSelected(bestrow, true);
//                    } else {
//                        view.getModel().getSelection().setSelected(bestrow, false);
//                    }
//                }
//            } else {
//                view.getModel().getSelection().clearSelection();
//            }
            select(event, false)
        }

        override fun mouseReleased(event: MouseEvent) {}
        override fun mouseEntered(event: MouseEvent) {
            probe(event, true)
        }

        override fun mouseExited(event: MouseEvent) {
//            view.getModel().getProbing().clearSelection();
        }

        override fun mouseDragged(event: MouseEvent) {
            probe(event, true)
            select(event, true)

//            final Object bestrow = view.getClosestRow(event.getX(), event.getY());
//            view.getModel().getProbing().setSelected(bestrow);
//
//            if (bestrow != null) {
//                if (!event.isMultipleSelectionKey()) {
//                    if (!view.getModel().getSelection().isSelected(bestrow) ||
//                            view.getModel().getSelection().getSelectedCount() > 1) {
//                        view.getModel().getSelection().clearSelection();
//                        view.getModel().getSelection().setSelected(bestrow);
//                        view.setSelectionMode(view.getModel().getSelection().isSelected(bestrow));
//                    }
//                } else {
//                    view.setSelectionMode(!view.getModel().getSelection().isSelected(bestrow));
//                    if (view.isSelectionMode()) {
//                        view.getModel().getSelection().setSelected(bestrow, true);
//                    } else {
//                        view.getModel().getSelection().setSelected(bestrow, false);
//                    }
//                }
//            } else {
//                view.getModel().getSelection().clearSelection();
//            }
        }

        override fun mouseMoved(event: MouseEvent) {
//            final Object closest = view.getClosestRow(event.getX(), event.getY());
//            view.getModel().getProbing().setSelected(closest);
            probe(event, true)
        }
    }

    fun select(e: MouseEvent, continuous: Boolean) {
        val dimension: DistributionDimension<Row, Value, Bin>? = view!!.getClosestDistribution(e.x, e.y)
        val bin: Bin = view!!.getClosestBin(e.x, e.y)
        if (bin != null) {
            val active: Boolean = dimension?.getActiveDensity(bin)!! > 0
            if (active) {
                var interactionMode: InteractionMode? = view!!.getInteractionMode().value
                if (e.isAltKeyDown) {
                    when (interactionMode) {
                        InteractionMode.Selection -> interactionMode = InteractionMode.Filter
                        InteractionMode.Toggle -> interactionMode = InteractionMode.Filter
                        InteractionMode.Filter -> interactionMode = if (dimension.selection != null) InteractionMode.Selection else InteractionMode.Toggle
                        InteractionMode.DoNothing -> {}
                        else -> {}
                    }
                }
                if (interactionMode === InteractionMode.Selection) {
                    if (dimension?.selection != null) {
                        if (e.isMenuShortcutKeyDown) {
                            dimension.selection!!.setSelectedIterableState(dimension.getRows(bin)!!, true)
                        } else {
                            dimension.selection!!.setSelectedIterable(dimension.getRows(bin)!!)
                        }
                    }
                } else {
                    if (!continuous && dimension.filterExact!!.isSelected(bin) && dimension.filterExact!!.selectedCount == 1) {
                        dimension.filterAll()
                    } else {
                        if (interactionMode === InteractionMode.Filter && !e.isMenuShortcutKeyDown ||
                            interactionMode === InteractionMode.Toggle && e.isMenuShortcutKeyDown
                        ) {
                            dimension!!.filterExact(bin)
                        } else {
                            val allSelected: Boolean = !dimension!!.filterExact!!.isActive
                            if (allSelected) {
                                if (interactionMode === InteractionMode.Filter) {
                                    dimension!!.filterExact!!.setSelectedIterable(dimension.activeBins!!)
                                    dimension!!.filterExact!!.setSelectedState(bin, false)
                                } else {
                                    dimension!!.filterExact(bin)
                                }
                            } else {
                                val currentlySelected: Boolean = dimension.filterExact!!.isSelected(bin)
                                dimension?.filterExact!!.setSelectedState(bin, !currentlySelected)
                            }
                        }
                    }
                }
            }
        }
    }

    fun probe(e: MouseEvent, continuous: Boolean) {
        val dimension: DistributionDimension<Row,Value,Bin>? = view!!.getClosestDistribution(e.x, e.y)
        val bin: Bin = view!!.getClosestBin(e.x, e.y)
        if (dimension != null && bin != null) {
            view!!.getProbing().selected = SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>(dimension, bin)
        } else {
            view!!.getProbing().clearSelection()
        }
        //        final int y = view.getOrientation().getValue() == view.Orientation.Horizontal ? e.getY() : e.getX();
//
//        int index = view.getIndex(y);
//        if (index >= 0 && index < view.getBins().size()) {
//            final Bin bin = getBins().get(index);
//
//            final boolean active = dimension.getActiveDensity(bin) > 0;
//
//            if (active) {
//                probing.setSelected(bin);
//            } else {
//                probing.clearSelection();
//            }
//        } else {
//            probing.clearSelection();
//        }
    }
}