/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.distributions

import org.mkui.component.CPComponent

interface Distributions<Row, Column, Value, Bin> : CPComponent {
    /**
     * Returns the model used by the parallel coordinates component.
     *
     * @return the model in use
     */
    var model: DistributionsModel<Row, Column, Value, Bin>?

    /**
     * Returns the view used by the parallel coordinates component.
     *
     * @return the view in use
     */
    var view: DistributionsView<Row, Column, Value, Bin>?

    /**
     * Returns the controller used by the parallel coordinates component.
     *
     * @return the controller in use
     */
    var controller: DistributionsController<Row, Column, Value, Bin>?
}