/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.list

import com.macrofocus.common.collection.TreeMap
import org.molap.dataframe.DataFrame

class EfficientIndexModel<R, C, V>(dataFrame: DataFrame<R, C, V>, column: C, comparator: Comparator<Any?>?) : AbstractIndexModel<Any?>() {
    private val keys: Array<Any?>
    private val values: Array<Any?>
    private val missingValue: MutableList<Any?>
    private val rows: MutableList<Any?>
    override fun getObject(index: Int): Any? {
        return keys[index]
    }

    override val objectCount: Int
        get() = keys.size

    override fun addObject(source: Any?, `object`: Any?) {}
    override fun replaceObject(source: Any?, oldkey: Any?, newkey: Any?) {}
    override fun removeObject(source: Any?, index: Int, key: Any?) {}
    override fun getRow(index: Int, j: Int): Int {
        return ((values[index] as MutableList<Any?>).elementAt(j) as Int).toInt()
    }

    override fun getRowCount(index: Int): Int {
        return (values[index] as MutableList<Any?>).size
    }

    override fun addRow(source: Any?, index: Int, row: Int) {}
    override fun removeRow(source: Any?, index: Int, row: Int) {}
    override fun getMissing(j: Int): Int {
        return (missingValue.get(j) as Int).toInt()
    }

    override val missingCount: Int
        get() = missingValue.size

    override fun addMissing(source: Any?, row: Int) {}
    override fun removeMissing(source: Any?, row: Int) {}
    override fun getIndex(row: Int, j: Int): Int {
        return ((rows.get(row) as MutableList<Any?>).elementAt(j) as Int).toInt()
    }

    override fun getIndexCount(row: Int): Int {
        return (rows.get(row) as MutableList<Any?>).size
    }

    override fun addIndexListener(indexListener: IndexListener?) {}

    init {
        val hashtable: MutableMap<Any?,Any?> = TreeMap<Any?,Any?>()
        missingValue = ArrayList()
        for (row in 0 until dataFrame.rowCount) {
            val rowKey: R = dataFrame.getRowKey(row)
            if (dataFrame.getValueAt(rowKey, column) != null) {
                var key: Any? = dataFrame.getValueAt(rowKey, column)
                if (key is Array<*>) {
                    val vector = key
                    for (i in vector.indices) {
                        key = vector[i]
                        val value: MutableList<Any?>
                        if (hashtable.containsKey(key)) {
                            value = hashtable[key] as MutableList<Any?>
                        } else {
                            value = ArrayList()
                        }
                        value.add(row)
                        hashtable[key] = value
                    }
                } else {
                    val value: MutableList<Any?>
                    if (hashtable.containsKey(key)) {
                        value = hashtable[key] as MutableList<Any?>
                    } else {
                        value = ArrayList()
                    }
                    value.add(row)
                    hashtable[key] = value
                }
            } else {
                missingValue.add(row)
            }
        }
        keys = arrayOfNulls(hashtable.size)
        values = arrayOfNulls(hashtable.size)
        var index: Int
        val e: Iterator<*>
        index = 0
        e = hashtable.keys.iterator()
        while (e.hasNext()) {
            val key = e.next()!!
            keys[index] = key
            values[index] = hashtable[key]
            index++
        }
        rows = ArrayList<Any?>(dataFrame.rowCount)
        for (row in 0 until dataFrame.rowCount) {
            rows.add(ArrayList<Any?>())
        }
        index = 0
        while (index < objectCount) {
            for (j in 0 until getRowCount(index)) {
                (rows.get(getRow(index, j)) as MutableList<Any?>).add(index)
            }
            index++
        }
    }
}