/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinates

import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperties
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesController.Companion.PROPERTY_REORDERING
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesController.Companion.PROPERTY_REVERSING
import org.mkui.canvas.MouseEvent
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener
import org.mkui.geom.Point
import org.mkui.geom.Rectangle2D
import org.mkui.interaction.InteractionMode

abstract class AbstractParallelCoordinatesController<Row, Column> : ParallelCoordinatesController<Row, Column> {
    //    protected final GenericMouseListener<Row> mouseListener = new GenericMouseListener<Row>() {
    //        @Override
    //        protected InteractionMode getMode() {
    //            return AbstractParallelCoordinatesController.this.getMode();
    //        }
    //
    //        @Override
    //        protected void setMode(InteractionMode mode) {
    //            AbstractParallelCoordinatesController.this.setMode(mode);
    //        }
    //
    //        @Override
    //        protected MutableSingleSelection<Row> getProbing() {
    //            return view.model.getProbing();
    //        }
    //
    //        @Override
    //        protected MutableSelection<Row> getSelection() {
    //            return view.model.getSelection();
    //        }
    //
    //        @Override
    //        protected MutableFilter<Row> getFilter() {
    //            return view.model.getFilter();
    //        }
    //
    //        @Override
    //        protected Row getClosestRow(int x, int y) {
    //            return view.getClosestRow(x, y);
    //        }
    //
    //        @Override
    //        protected Collection<Row> getRows(Rectangle2D rect) {
    //            return view.getRows(rect);
    //        }
    //    };
    protected val mouseListener: DefaultMouseListener = DefaultMouseListener()
    private val properties: MutableProperties<String?> = SimpleProperties()
    override var reordering: MutableProperty<Boolean> = properties.createProperty(PROPERTY_REORDERING, true)
        set(value) {
            field = value
            properties.replaceProperty(PROPERTY_REORDERING, value)
        }
    override var reversing: MutableProperty<Boolean> = properties.createProperty(PROPERTY_REVERSING, true)
        set(value) {
            field = value
            properties.replaceProperty(PROPERTY_REVERSING, value)
        }
    private val multipleSelectionEnabled = true
    private val selectOnPopupTrigger = false
    private var mode: InteractionMode = InteractionMode.Selection
    private var locksmith: Any

    override fun getMode(): InteractionMode {
        return mode
    }

    override fun setMode(mode: InteractionMode) {
        this.mode = mode
    }

    fun getLocksmith(): Any {
        return locksmith
    }

    override fun setLocksmith(locksmith: Any) {
        this.locksmith = locksmith
    }

    inner class DefaultMouseListener : MouseListener, MouseMotionListener {
        private var last: Point? = null
        private var selectOnRelease: Row? = null
        private var zoomOnRelease: Point? = null
        private val zoomingPoint: Point? = null
        private var pressedPoint: Point? = null
        override fun mouseClicked(e: MouseEvent) {}
        override fun mousePressed(event: MouseEvent) {
            if (view != null) {
                pressedPoint = Point(event.x, event.y)

//                view.getNativeComponent().requestFocus();
                val bestrow: Row? = view!!.getClosestRow(event.x, event.y)
                when (getMode()) {
                    InteractionMode.Selection -> if (bestrow != null) {
                        if (!event.isMultipleSelectionKey) {
                            if (!view!!.model!!.getSelection().isSelected(bestrow) ||
                                view!!.model!!.getSelection().selectedCount > 1
                            ) {
                                view!!.model!!.getSelection().clearSelection()
                                view!!.model!!.getSelection().setSelectedElement(bestrow)
                                view!!.setSelectionMode(view!!.model!!.getSelection().isSelected(bestrow))
                            }
                        } else {
                            view!!.setSelectionMode(!view!!.model!!.getSelection().isSelected(bestrow))
                            if (view!!.isSelectionMode()) {
                                view!!.model!!.getSelection().setSelectedState(bestrow, true)
                            } else {
                                view!!.model!!.getSelection().setSelectedState(bestrow, false)
                            }
                        }
                    } else {
                        view!!.model!!.getSelection().clearSelection()
                    }
                    InteractionMode.Toggle -> {
                        val selected: Boolean = view!!.model!!.getSelection().isSelected(bestrow)
                        view!!.model!!.getSelection().setSelectedState(bestrow!!, !selected)
                    }
                    InteractionMode.Filter -> {
                        val filtered: Boolean = view!!.model!!.getFilter().isFilteredBy(bestrow!!, this)
                        view!!.model!!.getFilter().setFiltered(bestrow!!, !filtered, this)
                    }
                    InteractionMode.DoNothing -> {}
                }
            }
        }

        override fun mouseReleased(event: MouseEvent) {
            if (view != null) {
                if (!event.isPopupTrigger) {
                    when (getMode()) {
                        InteractionMode.Selection -> {
                            if (selectOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    view!!.model!!.getSelection().clearSelection()
                                    if (multipleSelectionEnabled) {
                                        addToSelection(selectOnRelease!!)
                                    } else {
                                        setSelection(selectOnRelease)
                                    }
                                    selectOnRelease = null
                                }
                            }
                            if (zoomOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    //                            zoom(-1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                } else {
                                    //                            zoom(1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                }
                                zoomOnRelease = null
                            }
                            view!!.getRubberBand().stopRubberBand()
                        }
                        InteractionMode.Toggle -> {
                            if (selectOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    view!!.model!!.getSelection().clearSelection()
                                    if (multipleSelectionEnabled) {
                                        addToSelection(selectOnRelease!!)
                                    } else {
                                        setSelection(selectOnRelease)
                                    }
                                    selectOnRelease = null
                                }
                            }
                            if (zoomOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    //                            zoom(-1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                } else {
                                    //                            zoom(1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                }
                                zoomOnRelease = null
                            }
                            view!!.getRubberBand().stopRubberBand()
                        }
                        InteractionMode.Filter -> {
                        }
                        InteractionMode.DoNothing -> {}
                    }
                } else {
                    if (selectOnPopupTrigger) {
                        val node: Row? = view!!.getClosestRow(event.x, event.y)
                        setSelection(node)
                    }

//                    if (popupMenu != null) {
//                        popupMenu.show(_view, e.x, e.y);
//                    }
                }
                last = null
            }
        }

        override fun mouseEntered(e: MouseEvent) {}
        override fun mouseExited(e: MouseEvent) {
            if (view != null) {
                if (view!!.model != null) {
                    view!!.model!!.getProbing().clearSelection()
                }
            }
        }

        override fun mouseDragged(event: MouseEvent) {
            if (view != null) {
                if (view!!.model != null) {
                    val point = Point(event.x, event.y)
                    if (last != null) {
                        when (getMode()) {
                            InteractionMode.Selection -> if (event.isLeftMouseButton) {
                                if (event.isAltKeyDown || event.isShiftKeyDown) {
                                    view!!.model!!.getProbing().clearSelection()
                                    if (multipleSelectionEnabled) {
                                        if (!view!!.getRubberBand().rubberBand.isActive) {
                                            view!!.getRubberBand().startRubberBand(pressedPoint!!.ix, pressedPoint!!.iy)
                                        }
                                        view!!.getRubberBand().stretchRubberBand(event.x, event.y)
                                        val rect: Rectangle2D? = view!!.getRubberBand().rubberBandScreen
                                        if (rect != null) {
                                            val toSelect: Collection<Row>? = view!!.getRows(rect)
                                            if (event.isMultipleSelectionKey) {
                                                addToSelection(toSelect!!)
                                            } else {
                                                view!!.model!!.getSelection().setSelectedIterable(toSelect!!)
                                            }
                                            selectOnRelease = null
                                        }
                                    }
                                } else {
                                    val observation: Row? = view!!.getClosestRow(point.ix, point.iy)
                                    view!!.model!!.getProbing().setSelectedElement(observation!!)
                                    selectOnRelease = null
                                    val isAlreadySelected =
                                        view!!.model!!.getSelection() != null && view!!.model!!.getSelection().isSelected(observation)
                                    if (!isAlreadySelected && !event.isMenuShortcutKeyDown) {
                                        view!!.model!!.getSelection().clearSelection()
                                    }
                                    if (event.isMenuShortcutKeyDown) {
                                        if (multipleSelectionEnabled) {
                                            addToSelection(observation)
                                        } else {
                                            setSelection(observation)
                                        }
                                    } else {
                                        if (isAlreadySelected) {
                                            selectOnRelease = observation
                                        } else {
                                            if (multipleSelectionEnabled) {
                                                addToSelection(observation)
                                            } else {
                                                setSelection(observation)
                                            }
                                        }
                                    }
                                }
                            }
                            else -> {}
                        }
                    }
                    last = Point(event.x, event.y)
                }
            }
        }

        override fun mouseMoved(event: MouseEvent) {
            val closest: Row? = view!!.getClosestRow(event.x, event.y)
            view!!.model!!.getProbing().selected = closest
        }
    }

    private fun removeFromSelection(observation: Row) {
        view!!.model!!.getSelection().setSelectedState(observation, false)
    }

    private fun setSelection(observation: Row?) {
        if (observation != null) {
            view!!.model!!.getSelection().setSelectedElements(observation)
        } else {
            view!!.model!!.getSelection().clearSelection()
        }
    }

    private fun addToSelection(observation: Row) {
        view!!.model!!.getSelection().setSelectedState(observation, true)
    }

    private fun addToSelection(newSelection: Collection<Row>) {
        view!!.model!!.getSelection().setSelectedIterableState(newSelection, true)
    }

    init {
        locksmith = this
    }
}