package com.macrofocus.high_d.parallelcoordinates

import com.macrofocus.high_d.axis.AxisView
import org.mkui.interaction.InteractionMode

/**
 * Default controller mediating user interactions with a ParallelCoordinatesView.
 */
class DefaultParallelCoordinatesController<Row, Column>(view: ParallelCoordinatesView<Row, Column>) : AbstractParallelCoordinatesController<Row, Column>() {
    override var view: ParallelCoordinatesView<Row, Column>? = null
        /**
         * {@inheritDoc}
         */
        set(view) {
            if (field != null) {
//                field!!.nativeComponent.removeKeyListener(keyListener)

                field!!.removeMouseListener(mouseListener)
                field!!.removeMouseMotionListener(mouseListener)

                field!!.removeDragListener(dragListener)
                field!!.removeHeaderListener(headerListener)
            }

            field = view

            if (view != null) {
//                view.nativeComponent.setFocusable(true)
//                view.nativeComponent.addKeyListener(keyListener)

                view.addMouseListener(mouseListener)
                view.addMouseMotionListener(mouseListener)

                view.addDragListener(dragListener)
                view.addHeaderListener(headerListener)
            }
        }

    private var draggedAxisView: AxisView<*, *>? = null
    private var draggedLocation = 0

//    private val keyListener: KeyListener = object : KeyAdapter() {
//        var oldMode: InteractionMode? = null
//
//        override fun keyPressed(e: KeyEvent) {
//            if (e.keyCode == KeyEvent.VK_S) {
//                if (oldMode == null) {
//                    oldMode = getMode()
//                }
//                setMode(InteractionMode.Selection)
//            }
//        }
//
//        override fun keyReleased(e: KeyEvent) {
//            if (oldMode != null) {
//                setMode(oldMode!!)
//                oldMode = null
//            }
//        }
//    }

    private val dragListener: ParallelCoordinatesView.DragListener = object : ParallelCoordinatesView.DragListener {
        /**
         * {@inheritDoc}
         */
        override fun startDragging(axisView: AxisView<*, *>) {
            if (reordering.value) {
                draggedAxisView = axisView
//                draggedLocation = (axisView as SwingAxisView).getX()
//                (view as SwingParallelCoordinatesView).getInteractiveComponent()
//                    .setLayer((axisView as SwingAxisView), JLayeredPane.DRAG_LAYER)
//                (view as SwingParallelCoordinatesView).getInteractiveComponent()
//                    .setLayer((view as SwingParallelCoordinatesView).getLabel(axisView.model), JLayeredPane.DRAG_LAYER)
//
//                val axisGroup = view.model!!.getAxisHierarchy().getAxisGroup(axisView.model)
//                view.model!!.getAxisLocations(axisGroup)!!
//                    .drag(
//                        view.getAlignment().value,
//                        axisView.model,
//                        computeNormalizedLocation((axisView as SwingAxisView))
//                    )
//
//                (view as SwingParallelCoordinatesView).refresh()
            }
        }

        /**
         * Drags divider to right location. If it's continuous layout, really drag the divider; if not, only drag the
         * shadow.
         *
         * @param axisView the axis
         * @param location new location
         */
        override fun dragAxisTo(axisView: AxisView<*, *>, location: Int) {
            if (reordering.value) {
                draggedAxisView = axisView
//                (draggedAxisView as SwingAxisView?).setLocation(
//                    draggedLocation + location,
//                    (draggedAxisView as SwingAxisView?).getY()
//                )
//
//                val axisGroup = view.model!!.getAxisHierarchy().getAxisGroup(axisView.model)
//                view.model!!.getAxisLocations(axisGroup)!!
//                    .drag(
//                        view.getAlignment().value,
//                        axisView.model,
//                        computeNormalizedLocation((axisView as SwingAxisView))
//                    )
//                (view as SwingParallelCoordinatesView).refresh()
            }
        }

        /**
         * {@inheritDoc}
         */
        override fun stopDragging(axisView: AxisView<*, *>) {
            if (reordering.value) {
                draggedAxisView = null
                draggedLocation = 0
//                val axisGroup = view.model!!.getAxisHierarchy().getAxisGroup(axisView.model)
//                view.model!!.getAxisLocations(axisGroup)!!.stopDragging()
//
//                (view as SwingParallelCoordinatesView).getInteractiveComponent().setLayer(
//                    (view as SwingParallelCoordinatesView).getLabel(axisView.model),
//                    JLayeredPane.PALETTE_LAYER
//                )
//                (view as SwingParallelCoordinatesView).getInteractiveComponent()
//                    .setLayer((axisView as SwingAxisView), JLayeredPane.PALETTE_LAYER)
//
//                (view as SwingParallelCoordinatesView).refresh()
            }
        }

//        private fun computeNormalizedLocation(axisView: SwingAxisView): Double {
//            val axisGroup = view.model!!.getAxisHierarchy().getAxisGroup(axisView.getModel())
//            val rect: Rectangle2D = view.getParallelCoordinatesLayout().getBounds(axisGroup)
//            val alignment = view.getAlignment().value
//            return Math.min(
//                alignment.getMaximumPosition(axisGroup!!) + 0.05, Math.max(
//                    alignment.getMinimumPosition(
//                        axisGroup
//                    ) - 0.05, ((axisView.getX() + (axisView.getWidth() / 2)) - rect.x) / rect.width
//                )
//            )
//        }
    }

    private val headerListener: ParallelCoordinatesView.HeaderListener =
        object : ParallelCoordinatesView.HeaderListener {
            override fun headerSelected(view: AxisView<*, *>, clickCount: Int) {
                if (clickCount == 2 && reversing.value) {
                    val axisModel = view.model
                    val start: Double = axisModel!!.scaledInterval.start
                    val end: Double = axisModel.scaledInterval.end
                    val max = axisModel.maximum
                    val min = axisModel.minimum
                    axisModel.setMinMax(max, min)
                    axisModel.scaledInterval.start = end
                    axisModel.scaledInterval.end = start
                }
            }
        }

    init {
        this.view = view
    }
}
