/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix
abstract class AbstractParallelCoordinatesMatrixModel<O, C> :
    ParallelCoordinatesMatrixModel<O, C> {
    private val listeners: MutableList<ParallelCoordinatesMatrixListener> =
        ArrayList<ParallelCoordinatesMatrixListener>()

    /**
     * {@inheritDoc}
     */
    override fun addParallelCoordinatesMatrixListener(listener: ParallelCoordinatesMatrixListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeParallelCoordinatesMatrixListener(listener: ParallelCoordinatesMatrixListener) {
        listeners.remove(listener)
    }

    fun firedParallelCoordinatesMatrixChanged() {
        for (listener in listeners) {
            listener.parallelCoordinatesMatrixChanged()
        }
    }
}