/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix

import com.macrofocus.colormapping.implementation.SimpleColorMapping
import com.macrofocus.common.filter.Filter
import com.macrofocus.common.selection.MutableSelection
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.high_d.axis.AxisFactory
import com.macrofocus.high_d.axis.group.AxisGroupModel
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel
import com.macrofocus.high_d.axis.hierarchy.AxisHierarchy
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesSettings
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesSettings
import com.macrofocus.visual.SimpleVisual
import com.macrofocus.visual.SimpleVisualObjects
import org.mkui.coloring.MutableColoring
import org.mkui.colormap.ColorMapFactory
import org.mkui.colormapping.MutableColorMapping
import org.mkui.visual.Visual
import org.mkui.visual.VisualObjects
import org.molap.dataframe.DataFrame

class DefaultParallelCoordinatesMatrixModel<Row, C>(
    dataFrame: DataFrame<Row, C, *>,
    visual: Visual<Row, C>,
    axisGroupModel: AxisGroupModel<Row, C>,
    axisHierarchy: AxisHierarchy<Row, C>,
    settings: ParallelCoordinatesSettings
) : AbstractParallelCoordinatesMatrixModel<Row, C>(), VisualObjects<Row> {
    private val dataFrame: DataFrame<Row, C, *>
    private val visual: Visual<Row, C>
    private val axisGroupModel: AxisGroupModel<Row, C>
    private val axisHierarchy: AxisHierarchy<Row, C>
    private val settings: ParallelCoordinatesSettings

    constructor(dataFrame: DataFrame<Row, C, *>, colorMapFactory: ColorMapFactory) : this(
        dataFrame,
        SimpleVisual<Row, C>(SimpleVisualObjects<Row>(dataFrame), SimpleColorMapping<Row, C>(colorMapFactory, dataFrame)),
    ) {
    }

    constructor(dataFrame: DataFrame<Row, C, *>, visual: Visual<Row, C>) : this(
        dataFrame, visual, DefaultAxisGroupModel("Root", dataFrame, null, visual.probing, visual.selection, visual.filter),
        DefaultAxisHierarchy<Row, C>(
            AxisFactory<Row, C>(dataFrame, null, null, visual.probing, visual.selection, visual.filter),
            dataFrame, true, false, 10
        ), DefaultParallelCoordinatesSettings()
    ) {
    }

    override fun getVisual(): Visual<Row, C> {
        return visual
    }

    override val objectCount: Int
        get() = dataFrame.rowCount

    /**
     * {@inheritDoc}
     */
    override fun getProbing(): MutableSingleSelection<Row> {
        return visual.probing
    }

    /**
     * {@inheritDoc}
     */
    override fun getSelection(): MutableSelection<Row> {
        return visual.selection
    }

    /**
     * {@inheritDoc}
     */
    override fun getFilter(): Filter<Row> {
        return visual.filter
    }

    /**
     * {@inheritDoc}
     */
    override fun getColorMapping(): MutableColorMapping<Row, C> {
        return visual.colorMapping
    }

    /**
     * {@inheritDoc}
     */
    override fun getColoring(): MutableColoring<Row> {
        return visual.coloring
    }

    /**
     * {@inheritDoc}
     */
    override fun getObject(index: Int): Row {
        return dataFrame.getRowKey(index)
    }

    override fun getAxisGroupModel(): AxisGroupModel<Row, C> {
        return axisGroupModel
    }

    override fun getDataFrame(): DataFrame<Row, C, *> {
        return dataFrame
    }

    override fun getAxisHierarchy(): AxisHierarchy<Row, C> {
        return axisHierarchy
    }

    override fun getSettings(): ParallelCoordinatesSettings {
        return settings
    }

    init {
        this.dataFrame = dataFrame
        this.axisGroupModel = axisGroupModel
        this.axisHierarchy = axisHierarchy
        this.settings = settings
        this.visual = visual
    }
}