/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.license.LicenseModel
import org.mkui.canvas.Rendering
import org.mkui.graphics.colortheme.ColorTheme

interface ParallelCoordinatesMatrixView<Row, Column> {
    fun getClosestRow(x: Int, y: Int): Any?
    fun isSelectionMode(): Boolean
    fun setSelectionMode(value: Boolean)

    /**
     * Returns whether information about refresh rate should be displayed.
     *
     * @return true to display refresh rate information, false otherwise
     */
    fun isShowTiming(): Boolean

    /**
     * Sets whether information about refresh rate should be displayed.
     *
     * @param showTiming true to display refresh rate information, false otherwise
     */
    fun setShowTiming(showTiming: Boolean)
    fun setLicenseModel(licenseModel: LicenseModel?)

    /**
     * Returns the ScatterPlotModel that provides the data displayed by this ScatterPlotView.
     *
     * @return the ScatterPlotModel that provides the data displayed by this ScatterPlotView
     *
     * @see .setModel
     */
    var model: ParallelCoordinatesMatrixModel<Row, Column>?

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    fun getColorTheme(): MutableProperty<ColorTheme>

    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    fun setColorTheme(colorTheme: MutableProperty<ColorTheme>)
    fun setShowFiltered(showFiltered: MutableProperty<Boolean>?)
    fun setRendering(rendering: MutableProperty<Rendering>?)
    fun setAntialiasing(antialiasing: MutableProperty<Boolean>?)
}