/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.scatterplotmatrix

abstract class AbstractScatterPlotMatrixModel<Row, Column> : ScatterPlotMatrixModel<Row, Column> {
    private val listeners: MutableList<ScatterPlotMatrixListener> = ArrayList<ScatterPlotMatrixListener>()

    /**
     * {@inheritDoc}
     */
    override fun addScatterPlotMatrixListener(listener: ScatterPlotMatrixListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeScatterPlotMatrixListener(listener: ScatterPlotMatrixListener) {
        listeners.remove(listener)
    }

    protected fun firedScatterPlotMatrixChanged() {
        for (listener in listeners) {
            listener.scatterPlotMatrixChanged()
        }
    }
}