/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.scatterplotmatrix

interface ScatterPlotMatrixController<Row, Column> {
    fun getMode(): Mode
    fun setMode(mode: Mode)

    /**
     * Interaction mode.
     */
    enum class Mode {
        /**
         * Selection mode.
         */
        Selection, Toggle, Filter, DoNothing
    }

    /**
     * Replace the view currently under control.
     *
     * @param view the ScatterPlotMatrixView to use
     */
    var view: ScatterPlotMatrixView<Row, Column>?
}