/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.som

import com.macrofocus.license.LicenseModel
import org.molap.dataframe.DataFrame

abstract class AbstractSOM<Row, Column>() : SOM<Row, Column> {
    override var model: SOMModel<Row, Column>? = null
    override var view: SOMView<Row, Column>? = null
    override var controller: SOMController<Row, Column>? = null

    /**
     * Loads the specified data frame.
     *
     * @param dataFrame a data frame
     */
    protected fun load(dataFrame: DataFrame<*, *, *>?) {
        model = createModel(dataFrame)
    }

    /**
     * Creates a model that can be used by the parallel coordinates component
     *
     * @param dataFrame a Swing TableModel
     *
     * @return a SOMModel instance
     */
    protected abstract fun createModel(dataFrame: DataFrame<*,*,*>?): SOMModel<Row, Column>

    /**
     * Creates a view that can be used by the parallel coordinates component
     *
     * @return a SOMView instance
     */
    protected abstract fun createView(): SOMView<Row, Column>?

    /**
     * Creates a controller that can be used by the parallel coordinates component
     *
     * @param view the view that should be controlled
     *
     * @return a SOMController instance
     */
    protected abstract fun createController(view: SOMView<*, *>?): SOMController<*, *>?

    companion object {
        protected var licenseModel: LicenseModel? = null

        /**
         * Register the license key that legally entitle the use of SOM. This should be called prior to the first
         * instantiation of this component.
         *
         * @param username the user name
         * @param key      the license key
         */
        fun setLicenseKey(username: String?, key: String?) {
//            licenseModel = SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key)
        }
    }
}