/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.tablelens

import com.macrofocus.high_d.tablelens.TableLensController.Mode
import org.mkui.canvas.MouseEvent
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener
import org.mkui.geom.Point
import org.mkui.geom.Rectangle2D

/**
 * Created by luc on 26/07/16.
 */
abstract class AbstractTableLensController<Row, Column> : TableLensController<Row, Column> {
    override var view: TableLensView<Row, Column>? = null
        set(value) {
            if (field != null) {
    //            this.view.removeMouseListener(mouseListener);
    //            this.view.removeMouseMotionListener(mouseListener);
            }
            field = view
            if (value != null) {
                value.addMouseListener(mouseListener)
                value.addMouseMotionListener(mouseListener)
            }
    
        }
    
    private val multipleSelectionEnabled = true
    private val selectOnPopupTrigger = false
    override var mode: Mode = Mode.Selection
    private val mouseListener: DefaultMouseListener = DefaultMouseListener()

    inner class DefaultMouseListener : MouseListener, MouseMotionListener {
        private var last: Point? = null
        private var selectOnRelease: Row? = null
        private var zoomOnRelease: Point? = null
        private val zoomingPoint: Point? = null
        private var pressedPoint: Point? = null
        override fun mouseClicked(e: MouseEvent) {}
        override fun mousePressed(event: MouseEvent) {
            if (view != null) {
                pressedPoint = Point(event.x, event.y)

//                view.getNativeComponent().requestFocus();
                val bestrow: Row? = view!!.getClosestRow(event.x, event.y)
                when (mode) {
                    Mode.Selection -> if (bestrow != null) {
                        if (!event.isMultipleSelectionKey) {
                            if (!view!!.model!!.getSelection().isSelected(bestrow) ||
                                view!!.model!!.getSelection().selectedCount > 1
                            ) {
                                view!!.model!!.getSelection().clearSelection()
                                view!!.model!!.getSelection().setSelectedElement(bestrow)
                                view!!.setSelectionMode(view!!.model!!.getSelection().isSelected(bestrow))
                            }
                        } else {
                            view!!.setSelectionMode(!view!!.model!!.getSelection().isSelected(bestrow))
                            if (view!!.isSelectionMode()) {
                                view!!.model!!.getSelection().setSelectedState(bestrow, true)
                            } else {
                                view!!.model!!.getSelection().setSelectedState(bestrow, false)
                            }
                        }
                    } else {
                        view!!.model!!.getSelection().clearSelection()
                    }
                    Mode.Toggle -> {
                        val selected: Boolean = view!!.model!!.getSelection().isSelected(bestrow)
                        view!!.model!!.getSelection().setSelectedState(bestrow!!, !selected)
                    }
                    Mode.Filter -> {
                        val filtered: Boolean = view!!.model!!.getFilter().isFilteredBy(bestrow!!, this)
                        view!!.model!!.getFilter().setFiltered(bestrow!!, !filtered, this)
                    }
                    Mode.DoNothing -> {}
                }
            }
        }

        override fun mouseReleased(event: MouseEvent) {
            if (view != null) {
                if (!event.isPopupTrigger) {
                    when (mode) {
                        Mode.Selection -> {
                            if (selectOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    view!!.model!!.getSelection().clearSelection()
                                    if (multipleSelectionEnabled) {
                                        addToSelection(selectOnRelease!!)
                                    } else {
                                        setSelection(selectOnRelease)
                                    }
                                    selectOnRelease = null
                                }
                            }
                            if (zoomOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    //                            zoom(-1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                } else {
                                    //                            zoom(1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                }
                                zoomOnRelease = null
                            }
                            view!!.getRubberBand().stopRubberBand()
                        }
                        Mode.Toggle -> {
                            if (selectOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    view!!.model!!.getSelection().clearSelection()
                                    if (multipleSelectionEnabled) {
                                        addToSelection(selectOnRelease!!)
                                    } else {
                                        setSelection(selectOnRelease)
                                    }
                                    selectOnRelease = null
                                }
                            }
                            if (zoomOnRelease != null) {
                                if (event.isLeftMouseButton) {
                                    //                            zoom(-1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                } else {
                                    //                            zoom(1.0 / 20.0, view.screenToWorldX(zoomOnRelease.x), view.screenToWorldY(zoomOnRelease.y));
                                }
                                zoomOnRelease = null
                            }
                            view!!.getRubberBand().stopRubberBand()
                        }
                        Mode.Filter -> {
                        }
                        Mode.DoNothing -> {}
                    }
                } else {
                    if (selectOnPopupTrigger) {
                        val node: Row? = view!!.getClosestRow(event.x, event.y)
                        setSelection(node)
                    }

//                    if (popupMenu != null) {
//                        popupMenu.show(_view, e.getX(), e.getY());
//                    }
                }
                last = null
            }
        }

        override fun mouseEntered(e: MouseEvent) {}
        override fun mouseExited(e: MouseEvent) {
            view!!.model!!.getProbing().clearSelection()
        }

        override fun mouseDragged(event: MouseEvent) {
            if (view != null) {
                if (view!!.model != null) {
                    val point = Point(event.x, event.y)
                    if (last != null) {
                        when (mode) {
                            Mode.Selection -> if (event.isLeftMouseButton) {
                                if (event.isAltKeyDown || event.isShiftKeyDown) {
                                    view!!.model!!.getProbing().clearSelection()
                                    if (multipleSelectionEnabled) {
                                        if (!view!!.getRubberBand().rubberBand.isActive) {
                                            view!!.getRubberBand().startRubberBand(pressedPoint!!.ix, pressedPoint!!.iy)
                                        }
                                        view!!.getRubberBand().stretchRubberBand(event.x, event.y)
                                        val rect: Rectangle2D? = view!!.getRubberBand().rubberBandScreen
                                        if (rect != null) {
                                            val toSelect: Collection<Row> = view!!.getRows(rect)
                                            if (event.isMultipleSelectionKey) {
                                                addToSelection(toSelect)
                                            } else {
                                                view!!.model!!.getSelection().setSelectedIterable(toSelect)
                                            }
                                            selectOnRelease = null
                                        }
                                    }
                                } else {
                                    val observation: Row? = view!!.getClosestRow(point.ix, point.iy)
                                    view!!.model!!.getProbing().selected = observation
                                    selectOnRelease = null
                                    val isAlreadySelected =
                                        view!!.model!!.getSelection() != null && view!!.model!!.getSelection().isSelected(observation)
                                    if (!isAlreadySelected && !event.isMenuShortcutKeyDown) {
                                        view!!.model!!.getSelection().clearSelection()
                                    }
                                    if (event.isMenuShortcutKeyDown) {
                                        if (multipleSelectionEnabled) {
                                            addToSelection(observation!!)
                                        } else {
                                            setSelection(observation)
                                        }
                                    } else {
                                        if (isAlreadySelected) {
                                            selectOnRelease = observation
                                        } else {
                                            if (multipleSelectionEnabled) {
                                                addToSelection(observation!!)
                                            } else {
                                                setSelection(observation)
                                            }
                                        }
                                    }
                                }
                            }
                            else -> {}
                        }
                    }
                    last = Point(event.x, event.y)
                }
            }
        }

        override fun mouseMoved(event: MouseEvent) {
            val closest: Row? = view!!.getClosestRow(event.x, event.y)
            view!!.model!!.getProbing().selected = closest
        }
    }

    private fun removeFromSelection(observation: Row) {
        view!!.model!!.getSelection().setSelectedState(observation, false)
    }

    private fun setSelection(observation: Row?) {
        if (observation != null) {
            view!!.model!!.getSelection().setSelectedElements(observation)
        } else {
            view!!.model!!.getSelection().clearSelection()
        }
    }

    private fun addToSelection(observation: Row) {
        view!!.model!!.getSelection().setSelectedState(observation, true)
    }

    private fun addToSelection(newSelection: Collection<Row>) {
        view!!.model!!.getSelection().setSelectedIterableState(newSelection, true)
    }
}