package com.macrofocus.high_d.tablelens

abstract class AbstractTableLensModel<O, C> : TableLensModel<O, C> {
    private val listeners: MutableList<TableLensListener> = ArrayList<TableLensListener>()

    /**
     * {@inheritDoc}
     */
    override fun addTableLensListener(listener: TableLensListener) {
        listeners.add(listener)
    }

    /**
     * {@inheritDoc}
     */
    override fun removeTableLensListener(listener: TableLensListener) {
        listeners.remove(listener)
    }

    fun firedTableLensChanged() {
        for (listener in listeners) {
            listener.tableLensChanged()
        }
    }
}