package com.macrofocus.high_d.tablelens

import org.mkui.canvas.CPCanvas
import org.mkui.canvas.MouseListener
import org.mkui.canvas.MouseMotionListener

class DefaultTableLensComponent<Row,Column>(view: TableLensView<Row, Column>) : AbstractTableLensComponent<Row,Column>(view) {
    override val component: CPCanvas
    get() {return canvas}

    override fun getWidth(): Int {
        return component.getWidth().toInt()
    }

    override fun getHeight(): Int {
        return component.getHeight().toInt()
    }

    override fun refresh() {
        canvas.refresh()
    }

    override fun repaint() {
        canvas.redraw()
    }

    override fun scheduleUpdate() {
        timer.restart()
        canvas.refresh()
    }

    override fun addMouseListener(mouseListener: MouseListener) {
        canvas.addMouseListener(mouseListener)
    }

    override fun addMouseMotionListener(mouseListener: MouseMotionListener) {
        canvas.addMouseMotionListener(mouseListener)
    }

    override fun removeMouseListener(mouseListener: MouseListener) {
        canvas.removeMouseListener(mouseListener)
    }

    override fun removeMouseMotionListener(l: MouseMotionListener) {
        canvas.removeMouseMotionListener(l)
    }
}