package com.macrofocus.high_d.tablelens

interface TableLensController<Row, Column> {
    var mode: Mode

    /**
     * Interaction mode.
     */
    enum class Mode {
        /**
         * Selection mode.
         */
        Selection, Toggle, Filter, DoNothing
    }

    /**
     * Replace the view currently under control.
     *
     * @param view the TableLensView to use
     */
    var view: TableLensView<Row, Column>?
}