/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d

import com.macrofocus.common.properties.EnumProperties
import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry
import org.mkui.canvas.Rendering
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.graphics.colortheme.LightColorTheme
import org.mkui.interaction.InteractionMode

class HighDSettings(colorTheme: ColorTheme) {
    enum class PropertyType {
        // General
        showFiltered, antialiasing, rendering, ColorTheme, InteractionMode,  // Parallel coordinates
        geometry, allowScrolling,  // Colormaps
        ColorMapping
    }

    val properties: MutableProperties<PropertyType> = EnumProperties<PropertyType>(PropertyType.values())

    constructor() : this(LightColorTheme()) {
    }

    fun getShowFiltered(): MutableProperty<Boolean> {
        return properties.getProperty(PropertyType.showFiltered) as MutableProperty<Boolean>
    }

    fun getAntialiasing(): MutableProperty<Boolean> {
        return properties.getProperty(PropertyType.antialiasing) as MutableProperty<Boolean>
    }

    fun getRendering(): MutableProperty<Rendering> {
        return properties.getProperty(PropertyType.rendering) as MutableProperty<Rendering>
    }

    fun getColorTheme(): MutableProperty<ColorTheme> {
        return properties.getProperty(PropertyType.ColorTheme) as MutableProperty<ColorTheme>
    }

    fun getGeometry(): MutableProperty<Geometry> {
        return properties.getProperty(PropertyType.geometry) as MutableProperty<Geometry>
    }

    fun getInteractionMode(): MutableProperty<InteractionMode> {
        return properties.getProperty(PropertyType.InteractionMode) as MutableProperty<InteractionMode>
    }

    fun getAllowScrolling(): MutableProperty<Boolean> {
        return properties.getProperty(PropertyType.allowScrolling) as MutableProperty<Boolean>
    }

    init {
        properties.createProperty<Boolean>(PropertyType.showFiltered, true)
        properties.createProperty<Boolean>(PropertyType.antialiasing, true)
        properties.createProperty<Any>(PropertyType.rendering, Rendering.Density)
        properties.createProperty<Any>(PropertyType.ColorTheme, colorTheme)
        properties.createProperty<Any>(PropertyType.InteractionMode, InteractionMode.Filter)
        properties.createProperty<Any>(PropertyType.geometry, Geometry.Polylines)
        properties.createProperty<Boolean>(PropertyType.allowScrolling, false)
    }
}