/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.high_d.command

import com.macrofocus.common.command.Command
import com.macrofocus.hierarchy.Hierarchy
import com.macrofocus.high_d.HighDFactory
import com.macrofocus.high_d.axis.group.AxisGroupModel

class ResetFiltersCommand(private val highDFactory: HighDFactory<Int, String, Any?>) : Command {
    override fun execute() {
        val axisGroupHierarchy: Hierarchy<AxisGroupModel<Int, String>> = highDFactory.axisHierarchy!!.axisGroupHierarchy
        for (axisGroup in axisGroupHierarchy.breadthFirstIterator()) {
            val g: AxisGroupModel<*, *> = axisGroup
            for (axisModel in g.axisModels) {
                axisModel.interval.reset()
            }
        }
        highDFactory.subsetDataFrame?.reset()
    }
}